/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.config.recipes.xml;

import com.enderio.core.common.util.EntityUtil;
import com.enderio.core.common.util.NNList;
import crazypants.enderio.base.config.recipes.InvalidRecipeConfigException;
import crazypants.enderio.base.config.recipes.StaxFactory;
import crazypants.enderio.base.config.recipes.xml.AbstractCrafting;
import crazypants.enderio.base.config.recipes.xml.Item;
import crazypants.enderio.base.config.recipes.xml.Soul;
import crazypants.enderio.base.filter.FilterRegistry;
import crazypants.enderio.base.filter.item.SoulFilter;
import crazypants.enderio.base.recipe.MachineRecipeRegistry;
import crazypants.enderio.base.recipe.soul.BasicSoulBinderRecipe;
import crazypants.enderio.base.recipe.spawner.PoweredSpawnerRecipeRegistry;
import crazypants.enderio.util.CapturedMob;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class Soulbinding
extends AbstractCrafting {
    private int energy;
    private int levels;
    private NNList<Soul> souls = new NNList();
    private Item input;
    @Nonnull
    private Logic logic = Logic.NONE;
    @Nonnull
    private SoulHandling soulHandling = SoulHandling.LISTED;

    @Override
    public Object readResolve() throws InvalidRecipeConfigException {
        try {
            super.readResolve();
            if (this.input == null) {
                throw new InvalidRecipeConfigException("No <input>");
            }
            if (this.souls.isEmpty() && this.soulHandling == SoulHandling.LISTED) {
                throw new InvalidRecipeConfigException("No <soul>");
            }
            if (!this.souls.isEmpty() && this.soulHandling != SoulHandling.LISTED) {
                throw new InvalidRecipeConfigException("Cannot give <soul> when using ALL or SPAWNABLE");
            }
            if (this.energy <= 0) {
                throw new InvalidRecipeConfigException("Invalid low value for 'energy'");
            }
            if (this.levels <= 0) {
                throw new InvalidRecipeConfigException("Invalid negative or zero value for 'levels'");
            }
            boolean hasValidSoul = this.soulHandling != SoulHandling.LISTED;
            for (Soul soul : this.souls) {
                hasValidSoul = hasValidSoul || soul.isValid();
            }
            this.valid = this.valid && this.input.isValid() && hasValidSoul;
        }
        catch (InvalidRecipeConfigException e) {
            throw new InvalidRecipeConfigException(e, "in <soulbinding>");
        }
        return this;
    }

    @Override
    public void enforceValidity() throws InvalidRecipeConfigException {
        super.enforceValidity();
        this.input.enforceValidity();
        for (Soul soul : this.souls) {
            if (!soul.isValid()) continue;
            soul.enforceValidity();
        }
    }

    @Override
    public void register(final @Nonnull String recipeName) {
        if (this.isValid() && this.isActive()) {
            final NNList soulnames = new NNList();
            switch (this.soulHandling) {
                case ALL: {
                    soulnames.addAll((Collection)EntityUtil.getAllRegisteredMobNames());
                    break;
                }
                case SPAWNABLE: {
                    soulnames.addAll((Collection)EntityUtil.getAllRegisteredMobNames());
                    NNList.NNIterator iterator = soulnames.iterator();
                    while (iterator.hasNext()) {
                        if (!PoweredSpawnerRecipeRegistry.getInstance().isBlackListed((ResourceLocation)iterator.next())) continue;
                        iterator.remove();
                    }
                    break;
                }
                default: {
                    for (Soul soul : this.souls) {
                        if (!soul.isValid()) continue;
                        soulnames.add((Object)soul.getMob().getEntityName());
                    }
                }
            }
            this.input.getThing().getItemStacks().apply((NNList.Callback)new NNList.Callback<ItemStack>(){
                int i = 0;

                public void apply(@Nonnull ItemStack anInput) {
                    MachineRecipeRegistry.instance.registerRecipe("soulbinder", new BasicSoulBinderRecipe(anInput, Soulbinding.this.getOutput().getItemStack(), Soulbinding.this.energy, Soulbinding.this.levels, recipeName + this.i++, (NNList<ResourceLocation>)soulnames, Soulbinding.this.logic));
                }
            });
        }
    }

    @Override
    public boolean setAttribute(StaxFactory factory, String name, String value) throws InvalidRecipeConfigException, XMLStreamException {
        if ("energy".equals(name)) {
            this.energy = Integer.parseInt(value);
            return true;
        }
        if ("levels".equals(name)) {
            this.levels = Integer.parseInt(value);
            return true;
        }
        if ("logic".equals(name)) {
            try {
                this.logic = Logic.valueOf(value);
            }
            catch (IllegalArgumentException e) {
                throw new InvalidRecipeConfigException("Invalid value for 'logic'");
            }
            return true;
        }
        if ("souls".equals(name)) {
            try {
                this.soulHandling = SoulHandling.valueOf(value);
            }
            catch (IllegalArgumentException e) {
                throw new InvalidRecipeConfigException("Invalid value for 'souls'");
            }
            return true;
        }
        return super.setAttribute(factory, name, value);
    }

    @Override
    public boolean setElement(StaxFactory factory, String name, StartElement startElement) throws InvalidRecipeConfigException, XMLStreamException {
        if ("input".equals(name)) {
            this.input = (Item)factory.read(new Item().setAllowDelaying(false), startElement);
            return true;
        }
        if ("soul".equals(name)) {
            this.souls.add((Object)factory.read(new Soul(), startElement));
            return true;
        }
        return super.setElement(factory, name, startElement);
    }

    private static enum SoulHandling {
        ALL,
        LISTED,
        SPAWNABLE;

    }

    private static enum Logic implements BasicSoulBinderRecipe.OutputFilter
    {
        NONE,
        APPLY{

            @Override
            @Nonnull
            public ItemStack apply(@Nonnull ItemStack output, @Nonnull CapturedMob mobType) {
                return mobType.toStack(output.func_77973_b(), output.func_77952_i(), output.func_190916_E());
            }
        }
        ,
        FILTER{

            @Override
            @Nonnull
            public ItemStack apply(@Nonnull ItemStack output, @Nonnull CapturedMob mobType) {
                Object filter = FilterRegistry.getFilterForUpgrade(output);
                if (filter instanceof SoulFilter) {
                    ((SoulFilter)filter).getSouls().add((Object)mobType);
                    FilterRegistry.writeFilterToStack(filter, output);
                }
                return output;
            }
        };

    }
}

