/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.handler.darksteel;

import com.enderio.core.common.util.Util;
import crazypants.enderio.base.config.config.BlockConfig;
import crazypants.enderio.base.config.config.DarkSteelConfig;
import crazypants.enderio.base.init.ModObject;
import crazypants.enderio.base.integration.tic.TicProxy;
import crazypants.enderio.base.item.darksteel.ItemDarkSteelSword;
import crazypants.enderio.base.item.darksteel.upgrade.energy.EnergyUpgradeManager;
import crazypants.enderio.base.material.material.Material;
import crazypants.enderio.util.Prep;
import info.loenwind.autoconfig.factory.IValue;
import java.lang.reflect.InvocationTargetException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityWitherSkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

@Mod.EventBusSubscriber(modid="enderio")
public class SwordHandler {
    @Nonnull
    public static final String HIT_BY_DARK_STEEL_SWORD = "hitByDarkSteelSword";
    @Nonnull
    private static final ResourceLocation ENDERZOO_ENDERMINY = new ResourceLocation("enderzoo", "enderminy");
    @Nonnull
    private static final ResourceLocation ENDERIOZOO_ENDERMINY = new ResourceLocation("enderiozoo", "enderminy");

    @SubscribeEvent
    public static void onEnderTeleport(EnderTeleportEvent evt) {
        if (evt.getEntityLiving().getEntityData().func_74767_n(HIT_BY_DARK_STEEL_SWORD)) {
            evt.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onEntityDrop(LivingDropsEvent evt) {
        Entity attacker = evt.getSource().func_76346_g();
        EntityLivingBase killedMob = evt.getEntityLiving();
        if (!(attacker instanceof EntityPlayer) || killedMob == null) {
            return;
        }
        EntityPlayer player = (EntityPlayer)attacker;
        if (SwordHandler.handleBeheadingWeapons(player, evt)) {
            return;
        }
        double skullDropChance = SwordHandler.getSkullDropChance(player, evt);
        if (player instanceof FakePlayer) {
            skullDropChance *= (double)((Float)BlockConfig.fakePlayerSkullChance.get()).floatValue();
        }
        if ((double)killedMob.field_70170_p.field_73012_v.nextFloat() < skullDropChance) {
            SwordHandler.dropSkull(evt, player);
        }
        if (SwordHandler.isEquipped(player)) {
            boolean isEnderminy;
            ResourceLocation name = EntityList.func_191301_a((Entity)killedMob);
            boolean isEnderman = killedMob instanceof EntityEnderman;
            boolean bl = isEnderminy = !isEnderman && (ENDERZOO_ENDERMINY.equals((Object)name) || ENDERIOZOO_ENDERMINY.equals((Object)name));
            if (isEnderman || isEnderminy) {
                double chance;
                ItemStack dropItem = isEnderminy ? Material.SHARD_ENDER.getStack() : new ItemStack(Items.field_151079_bi);
                int numPearls = 0;
                for (chance = ((Double)DarkSteelConfig.darkSteelSwordEnderPearlDropChance.get()).doubleValue(); chance >= 1.0; chance -= 1.0) {
                    ++numPearls;
                }
                if (chance > 0.0 && Math.random() <= chance) {
                    ++numPearls;
                }
                for (int i = 0; i < evt.getLootingLevel(); ++i) {
                    for (chance = ((Double)DarkSteelConfig.darkSteelSwordEnderPearlDropChancePerLooting.get()).doubleValue(); chance >= 1.0; chance -= 1.0) {
                        ++numPearls;
                    }
                    if (!(chance > 0.0) || !(Math.random() <= chance)) continue;
                    ++numPearls;
                }
                int existing = 0;
                for (EntityItem stack : evt.getDrops()) {
                    if (stack.func_92059_d().func_77973_b() != dropItem.func_77973_b() || stack.func_92059_d().func_77952_i() != dropItem.func_77952_i()) continue;
                    existing += stack.func_92059_d().func_190916_E();
                }
                int toDrop = numPearls - existing;
                if (toDrop > 0) {
                    dropItem.func_190920_e(toDrop);
                    evt.getDrops().add(Util.createDrop((World)player.field_70170_p, (ItemStack)dropItem, (double)killedMob.field_70165_t, (double)killedMob.field_70163_u, (double)killedMob.field_70161_v, (boolean)false));
                }
            }
        }
    }

    private static boolean handleBeheadingWeapons(EntityPlayer player, LivingDropsEvent evt) {
        if (player == null) {
            return false;
        }
        ItemStack equipped = player.func_184614_ca();
        NBTTagCompound tagCompound = equipped.func_77978_p();
        if (tagCompound == null) {
            return false;
        }
        int beheading = TicProxy.getBehadingLevel(equipped);
        if (beheading == 0) {
            return false;
        }
        if (!(evt.getEntityLiving() instanceof EntityEnderman)) {
            return true;
        }
        float chance = Math.max(((Float)BlockConfig.vanillaSwordSkullChance.get()).floatValue(), ((Float)BlockConfig.ticBeheadingSkullModifier.get()).floatValue() * (float)beheading);
        if (player instanceof FakePlayer) {
            chance *= ((Float)BlockConfig.fakePlayerSkullChance.get()).floatValue();
        }
        while (chance >= 1.0f) {
            SwordHandler.dropSkull(evt, player);
            chance -= 1.0f;
        }
        if (chance > 0.0f && Math.random() <= (double)chance) {
            SwordHandler.dropSkull(evt, player);
        }
        return true;
    }

    private static double getSkullDropChance(@Nonnull EntityPlayer player, LivingDropsEvent evt) {
        if (evt.getEntityLiving() instanceof EntityWitherSkeleton) {
            if (SwordHandler.isEquippedAndPowered(player, DarkSteelConfig.darkSteelSwordPowerUsePerHit)) {
                return ((Float)BlockConfig.darkSteelSwordWitherSkullChance.get()).floatValue() + ((Float)BlockConfig.darkSteelSwordWitherSkullLootingModifier.get()).floatValue() * (float)evt.getLootingLevel();
            }
            return 0.01;
        }
        if (SwordHandler.isEquippedAndPowered(player, DarkSteelConfig.darkSteelSwordPowerUsePerHit)) {
            return ((Float)BlockConfig.darkSteelSwordSkullChance.get()).floatValue() + ((Float)BlockConfig.darkSteelSwordSkullLootingModifier.get()).floatValue() * (float)evt.getLootingLevel();
        }
        return ((Float)BlockConfig.vanillaSwordSkullChance.get()).floatValue() + ((Float)BlockConfig.vanillaSwordSkullLootingModifier.get()).floatValue() * (float)evt.getLootingLevel();
    }

    public static boolean isEquippedAndPowered(EntityPlayer player, IValue<Integer> requiredPower) {
        return SwordHandler.isEquipped(player) && SwordHandler.getStoredPower(player) >= (Integer)requiredPower.get();
    }

    private static void dropSkull(LivingDropsEvent evt, EntityPlayer player) {
        ItemStack skull = SwordHandler.getSkullForEntity(evt.getEntityLiving());
        if (skull != null && !skull.func_190926_b() && !SwordHandler.containsDrop(evt, skull)) {
            evt.getDrops().add(Util.createEntityItem((World)player.field_70170_p, (ItemStack)skull, (double)evt.getEntityLiving().field_70165_t, (double)evt.getEntityLiving().field_70163_u, (double)evt.getEntityLiving().field_70161_v));
        }
    }

    private static boolean containsDrop(LivingDropsEvent evt, @Nonnull ItemStack skull) {
        for (EntityItem ei : evt.getDrops()) {
            if (ei == null || ei.func_92059_d().func_77973_b() != skull.func_77973_b() || ei.func_92059_d().func_77952_i() != skull.func_77952_i()) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private static ItemStack getSkullForEntity(EntityLivingBase entityLiving) {
        if (entityLiving instanceof EntitySkeleton) {
            return new ItemStack(Items.field_151144_bL, 1, 0);
        }
        if (entityLiving instanceof EntityWitherSkeleton) {
            return new ItemStack(Items.field_151144_bL, 1, 1);
        }
        if (entityLiving instanceof EntityZombie) {
            try {
                return (ItemStack)ReflectionHelper.findMethod(EntityZombie.class, (String)"getSkullDrop", (String)"func_190732_dj", (Class[])new Class[0]).invoke((Object)entityLiving, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                if (entityLiving.getClass() == EntityZombie.class) {
                    return new ItemStack(Items.field_151144_bL, 1, 2);
                }
            }
        } else {
            if (entityLiving instanceof EntityCreeper) {
                return new ItemStack(Items.field_151144_bL, 1, 4);
            }
            if (entityLiving instanceof EntityEnderman) {
                return new ItemStack(ModObject.blockEndermanSkull.getBlockNN());
            }
        }
        return Prep.getEmpty();
    }

    private static boolean isEquipped(EntityPlayer player) {
        return player != null && player.func_184614_ca().func_77973_b() instanceof ItemDarkSteelSword;
    }

    private static int getStoredPower(EntityPlayer player) {
        return EnergyUpgradeManager.getEnergyStored(player.func_184614_ca());
    }
}

