/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.integration.thaumcraft;

import crazypants.enderio.api.upgrades.IDarkSteelUpgrade;
import crazypants.enderio.base.Log;
import crazypants.enderio.base.events.EnderIOLifecycleEvent;
import crazypants.enderio.base.farming.FarmersRegistry;
import crazypants.enderio.base.integration.thaumcraft.GogglesOfRevealingUpgrade;
import crazypants.enderio.base.integration.thaumcraft.ThaumaturgeRobesUpgrade;
import crazypants.enderio.base.integration.thaumcraft.ThaumcraftAspects;
import javax.annotation.Nonnull;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="enderio")
public class ThaumcraftUtil {
    @Nonnull
    static final String MODID_THAUMCRAFT = "thaumcraft";

    @SubscribeEvent
    public static void onPost(EnderIOLifecycleEvent.PostInit.Post event) {
        if (Loader.isModLoaded((String)MODID_THAUMCRAFT)) {
            ThaumcraftAspects.loadAspects();
        }
    }

    @SubscribeEvent
    public static void registerDarkSteelUpgrades(@Nonnull RegistryEvent.Register<IDarkSteelUpgrade> event) {
        if (Loader.isModLoaded((String)MODID_THAUMCRAFT)) {
            IForgeRegistry registry = event.getRegistry();
            registry.register((IForgeRegistryEntry)ThaumaturgeRobesUpgrade.BOOTS);
            registry.register((IForgeRegistryEntry)ThaumaturgeRobesUpgrade.LEGS);
            registry.register((IForgeRegistryEntry)ThaumaturgeRobesUpgrade.CHEST);
            registry.register((IForgeRegistryEntry)GogglesOfRevealingUpgrade.INSTANCE);
            Log.info("Dark Steel Upgrades: Thaumcraft integration loaded");
        }
    }

    @SubscribeEvent
    public static void registerHoes(@Nonnull EnderIOLifecycleEvent.Init.Pre event) {
        FarmersRegistry.registerHoes(MODID_THAUMCRAFT, "thaumium_hoe", "void_hoe", "elemental_hoe");
    }
}

