/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.item.darksteel.upgrade.energy;

import crazypants.enderio.api.upgrades.IDarkSteelItem;
import crazypants.enderio.base.item.darksteel.upgrade.energy.EnergyUpgradeManager;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class EnergyUpgradeCap
implements IEnergyStorage,
ICapabilityProvider {
    @Nonnull
    private final ItemStack container;

    public EnergyUpgradeCap(@Nonnull ItemStack container) {
        this.container = container;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        return this.canReceive() ? EnergyUpgradeManager.receiveEnergy(this.container, maxReceive, simulate) : 0;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return this.canExtract() ? EnergyUpgradeManager.extractEnergy(this.container, maxExtract, simulate) : 0;
    }

    public int getEnergyStored() {
        return EnergyUpgradeManager.getEnergyStored(this.container);
    }

    public int getMaxEnergyStored() {
        return EnergyUpgradeManager.getMaxEnergyStored(this.container);
    }

    public boolean canExtract() {
        return ((IDarkSteelItem)this.container.func_77973_b()).allowExtractEnergy();
    }

    public boolean canReceive() {
        return true;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityEnergy.ENERGY;
    }

    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(capability == CapabilityEnergy.ENERGY ? this : null);
    }
}

