/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.network;

import com.enderio.core.common.util.NullHelper;
import crazypants.enderio.base.Log;
import crazypants.enderio.base.network.IRemoteExec;
import crazypants.enderio.base.network.PacketHandler;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class GuiPacket
implements IMessage {
    private static final DataType[][] PATTERN = new DataType[][]{new DataType[0], {DataType.INT}, {DataType.STRING}, {DataType.INT, DataType.INT, DataType.LONG}, {DataType.INT, DataType.INT, DataType.INT}};
    private int guiID;
    private int msgID;
    private int pattern;
    private int[] ints;
    private long[] longs;
    private String[] strings;
    private EntityPlayerMP player;

    public static void send(IRemoteExec gui, int msgID) {
        GuiPacket p = new GuiPacket(gui, msgID, 0, null, null, null);
        p.send();
    }

    public static void send(IRemoteExec gui, int msgID, int data) {
        GuiPacket p = new GuiPacket(gui, msgID, 1, new int[]{data}, null, null);
        p.send();
    }

    public static void send(IRemoteExec gui, int msgID, Enum<?> data) {
        GuiPacket p = new GuiPacket(gui, msgID, 1, new int[]{data.ordinal()}, null, null);
        p.send();
    }

    public static void send(IRemoteExec gui, int msgID, boolean data) {
        GuiPacket p = new GuiPacket(gui, msgID, 1, new int[]{data ? 1 : 0}, null, null);
        p.send();
    }

    public static void send(IRemoteExec gui, int msgID, String data) {
        GuiPacket p = new GuiPacket(gui, msgID, 2, null, null, new String[]{data});
        p.send();
    }

    public static void send(IRemoteExec gui, int msgID, int data1, int data2, long data3) {
        GuiPacket p = new GuiPacket(gui, msgID, 3, new int[]{data1, data2}, new long[]{0L, 0L, data3}, null);
        p.send();
    }

    public static void send(IRemoteExec gui, int msgID, boolean data1, int data2, int data3) {
        GuiPacket p = new GuiPacket(gui, msgID, 4, new int[]{data1 ? 1 : 0, data2, data3}, null, null);
        p.send();
    }

    public static void send(IRemoteExec gui, int msgID, int data1, boolean data2, BlockPos data3) {
        GuiPacket.send(gui, msgID, data1, data2 ? 1 : 0, data3.func_177986_g());
    }

    private GuiPacket(IRemoteExec gui, int msgID, int pattern, int[] ints, long[] longs, String[] strings) {
        this.guiID = gui.getGuiID();
        this.msgID = msgID;
        this.pattern = pattern;
        this.ints = ints;
        this.longs = longs;
        this.strings = strings;
    }

    public GuiPacket() {
    }

    public void toBytes(ByteBuf buf) {
        buf.writeShort(this.guiID);
        buf.writeShort(this.msgID);
        buf.writeShort(this.pattern);
        int idx = 0;
        block5: for (DataType dt : PATTERN[this.pattern]) {
            switch (dt) {
                case INT: {
                    buf.writeInt(this.ints[idx++]);
                    continue block5;
                }
                case LONG: {
                    buf.writeLong(this.longs[idx++]);
                    continue block5;
                }
                case STRING: {
                    buf.writeBoolean(this.strings[idx] != null);
                    if (this.strings[idx] != null) {
                        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.strings[idx]);
                    }
                    ++idx;
                }
            }
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.guiID = buf.readShort();
        this.msgID = buf.readShort();
        this.pattern = buf.readShort();
        if (this.pattern < 0 || this.pattern >= PATTERN.length) {
            Log.warn("Invalid network packet received (" + this.guiID + "/" + this.msgID + "/" + this.pattern + "): p invalid");
            return;
        }
        int idx = 0;
        block5: for (DataType dt : PATTERN[this.pattern]) {
            switch (dt) {
                case INT: {
                    if (this.ints == null) {
                        this.ints = new int[PATTERN[this.pattern].length];
                    }
                    this.ints[idx++] = buf.readInt();
                    continue block5;
                }
                case LONG: {
                    if (this.longs == null) {
                        this.longs = new long[PATTERN[this.pattern].length];
                    }
                    this.longs[idx++] = buf.readLong();
                    continue block5;
                }
                case STRING: {
                    if (this.strings == null) {
                        this.strings = new String[PATTERN[this.pattern].length];
                    }
                    if (buf.readBoolean()) {
                        this.strings[idx] = ByteBufUtils.readUTF8String((ByteBuf)buf);
                    }
                    ++idx;
                }
            }
        }
    }

    private boolean checkAccess(int idx, DataType type) {
        if (idx >= PATTERN[this.pattern].length) {
            Log.warn("Invalid network packet received (" + this.guiID + "/" + this.msgID + "/" + this.pattern + "): idx" + idx + " high");
            return false;
        }
        if (PATTERN[this.pattern][idx] != type) {
            Log.warn("Invalid network packet received (" + this.guiID + "/" + this.msgID + "/" + this.pattern + "): idx" + idx + " not " + (Object)((Object)type));
            return false;
        }
        if (type == DataType.INT && this.ints == null || type == DataType.LONG && this.longs == null || type == DataType.STRING && this.strings == null) {
            Log.warn("Invalid network packet received (" + this.guiID + "/" + this.msgID + "/" + this.pattern + "): idx" + idx + " no " + (Object)((Object)type) + " data");
            return false;
        }
        return true;
    }

    private void send() {
        PacketHandler.INSTANCE.sendToServer((IMessage)this);
    }

    @Nonnull
    public EntityPlayerMP getPlayer() {
        return (EntityPlayerMP)NullHelper.notnull((Object)this.player, (String)"got a network packet that wasn't sent by a player. what?");
    }

    public int getInt(int idx) {
        return this.checkAccess(idx, DataType.INT) ? this.ints[idx] : 0;
    }

    @Nonnull
    public <E extends Enum<?>> E getEnum(int idx, Class<E> clazz) {
        Enum[] enumConstants = (Enum[])clazz.getEnumConstants();
        return (E)((Enum)NullHelper.notnullJ((Object)enumConstants[MathHelper.func_76125_a((int)this.getInt(idx), (int)0, (int)(enumConstants.length - 1))], (String)"clazz.getEnumConstants()"));
    }

    public boolean getBoolean(int idx) {
        return this.getInt(idx) != 0;
    }

    public long getLong(int idx) {
        return this.checkAccess(idx, DataType.LONG) ? this.longs[idx] : 0L;
    }

    @Nonnull
    public BlockPos getBlockPos(int idx) {
        return BlockPos.func_177969_a((long)this.getLong(idx));
    }

    public String getString(int idx) {
        return this.checkAccess(idx, DataType.STRING) ? this.strings[idx] : null;
    }

    public static class Handler
    implements IMessageHandler<GuiPacket, IMessage> {
        public IMessage onMessage(GuiPacket message, MessageContext ctx) {
            message.player = ctx.getServerHandler().field_147369_b;
            Container openContainer = ((GuiPacket)message).player.field_71070_bA;
            if (openContainer instanceof IRemoteExec.IContainer && ((IRemoteExec.IContainer)openContainer).getGuiID() == message.guiID && message.guiID >= 0) {
                Log.debug("Exec (" + message.guiID + "/" + message.msgID + "/" + message.pattern + "): cont=" + openContainer);
                return ((IRemoteExec.IContainer)openContainer).networkExec(message.msgID, message);
            }
            Log.debug("Invalid network packet received (" + message.guiID + "/" + message.msgID + "/" + message.pattern + "): cont=" + openContainer + " id=" + (openContainer instanceof IRemoteExec.IContainer ? Integer.valueOf(((IRemoteExec.IContainer)openContainer).getGuiID()) : "n/a"));
            return null;
        }
    }

    private static enum DataType {
        INT,
        LONG,
        STRING;

    }
}

