/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.paint.render;

import com.enderio.core.common.util.IBlockAccessWrapper;
import crazypants.enderio.base.paint.IPaintable;
import crazypants.enderio.util.FacadeUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class PaintedBlockAccessWrapper
extends IBlockAccessWrapper {
    private static final ConcurrentHashMap<Block, Boolean> teBlackList = new ConcurrentHashMap();
    private static final ThreadLocal<PaintedBlockAccessWrapper> factory = new ThreadLocal<PaintedBlockAccessWrapper>(){

        @Override
        protected PaintedBlockAccessWrapper initialValue() {
            return new PaintedBlockAccessWrapper();
        }
    };
    private final Map<Block, TileEntity> teCache = new HashMap<Block, TileEntity>();

    @Nonnull
    public static PaintedBlockAccessWrapper instance(@Nonnull IBlockAccess ba) {
        return factory.get().setWorld(ba);
    }

    private PaintedBlockAccessWrapper() {
        super(null);
    }

    @Nonnull
    public PaintedBlockAccessWrapper setWorld(@Nonnull IBlockAccess ba) {
        this.wrapped = ba;
        return this;
    }

    public void free() {
        this.wrapped = null;
    }

    public boolean isSideSolid(@Nonnull BlockPos pos, @Nonnull EnumFacing side, boolean _default) {
        IBlockState paintSource = this.getPaintSource(pos);
        if (paintSource != null) {
            return paintSource.func_177230_c().isSideSolid(paintSource, (IBlockAccess)this, pos, side);
        }
        return super.isSideSolid(pos, side, _default);
    }

    public TileEntity func_175625_s(@Nonnull BlockPos pos) {
        IBlockState paintSource = this.getPaintSource(pos);
        if (paintSource != null && paintSource != super.func_180495_p(pos)) {
            return this.createTileEntity(paintSource, pos.func_185334_h());
        }
        return super.func_175625_s(pos);
    }

    public TileEntity getRealTileEntity(@Nonnull BlockPos pos) {
        return this.wrapped.func_175625_s(pos);
    }

    @Nonnull
    public IBlockState func_180495_p(@Nonnull BlockPos pos) {
        IBlockState paintSource = this.getPaintSource(pos);
        if (paintSource != null) {
            return paintSource;
        }
        return super.func_180495_p(pos);
    }

    private IBlockState getPaintSource(@Nonnull BlockPos pos) {
        IBlockState state = super.func_180495_p(pos);
        if (state.func_177230_c() instanceof IPaintable.IBlockPaintableBlock) {
            return ((IPaintable.IBlockPaintableBlock)state.func_177230_c()).getPaintSource(state, this.wrapped, pos);
        }
        return FacadeUtil.instance.getFacade(state, this.wrapped, pos, null);
    }

    private TileEntity createTileEntity(IBlockState state, @Nonnull BlockPos pos) {
        Block block = state.func_177230_c();
        if (!block.hasTileEntity(state) || teBlackList.containsKey(block)) {
            return null;
        }
        if (this.teCache.containsKey(block)) {
            try {
                TileEntity tileEntity = this.teCache.get(block);
                tileEntity.func_174878_a(pos);
                return tileEntity;
            }
            catch (Throwable t) {
                this.teCache.remove(block);
            }
        }
        try {
            TileEntity tileEntity = block.createTileEntity(null, state);
            tileEntity.func_174878_a(pos);
            this.teCache.put(block, tileEntity);
            return tileEntity;
        }
        catch (Throwable t) {
            teBlackList.put(block, true);
            return null;
        }
    }
}

