/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.power;

import com.enderio.core.common.transform.EnderCoreMethods;
import crazypants.enderio.base.power.IInternalPoweredItem;
import crazypants.enderio.base.render.itemoverlay.PowerBarOverlayRenderHelper;
import crazypants.enderio.util.NbtValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class PoweredBlockItem
extends ItemBlock
implements IInternalPoweredItem,
EnderCoreMethods.IOverlayRenderAware {
    public PoweredBlockItem(@Nonnull Block block) {
        super(block);
    }

    @Override
    public int getMaxEnergyStored(@Nonnull ItemStack container) {
        return NbtValue.ENERGY_BUFFER.getInt(container, 0);
    }

    @Override
    public int getMaxInput(@Nonnull ItemStack container) {
        return this.getMaxEnergyStored(container) / 100;
    }

    @Override
    public int getMaxOutput(@Nonnull ItemStack container) {
        return 0;
    }

    @Override
    @Nullable
    public ICapabilityProvider initCapabilities(@Nonnull ItemStack stack, @Nullable NBTTagCompound nbt) {
        return IInternalPoweredItem.super.initCapabilities(stack, nbt);
    }

    public void renderItemOverlayIntoGUI(@Nonnull ItemStack stack, int xPosition, int yPosition) {
        if (stack.func_190916_E() == 1) {
            PowerBarOverlayRenderHelper.instance_machine.render(stack, xPosition, yPosition);
        }
    }
}

