/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.obelisk.render;

import crazypants.enderio.base.machine.base.te.AbstractMachineEntity;
import crazypants.enderio.base.machine.render.MachineRenderMapper;
import crazypants.enderio.base.paint.render.PaintedBlockAccessWrapper;
import crazypants.enderio.base.render.IBlockStateWrapper;
import crazypants.enderio.base.render.util.ItemQuadCollector;
import crazypants.enderio.base.render.util.QuadCollector;
import crazypants.enderio.machines.machine.obelisk.render.ObeliskBakery;
import crazypants.enderio.machines.machine.obelisk.render.ObeliskRenderManager;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

public class ObeliskRenderMapper
extends MachineRenderMapper {
    @Nonnull
    public static final ObeliskRenderMapper instance = new ObeliskRenderMapper();

    private ObeliskRenderMapper() {
        super(null);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<Pair<IBlockState, ItemStack>> mapItemRender(@Nonnull Block block, @Nonnull ItemStack stack, @Nonnull ItemQuadCollector itemQuadCollector) {
        itemQuadCollector.addQuads(null, ObeliskBakery.bake(ObeliskRenderManager.INSTANCE.getActiveTextures()));
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<IBlockState> mapBlockRender(@Nonnull IBlockStateWrapper state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, BlockRenderLayer blockLayer, @Nonnull QuadCollector quadCollector) {
        TileEntity tileEntity = this.getTileEntity(state, pos);
        boolean isActive = tileEntity instanceof AbstractMachineEntity ? ((AbstractMachineEntity)tileEntity).isActive() : true;
        quadCollector.addQuads(null, BlockRenderLayer.CUTOUT, ObeliskBakery.bake(isActive ? ObeliskRenderManager.INSTANCE.getActiveTextures() : ObeliskRenderManager.INSTANCE.getTextures()));
        return null;
    }

    private TileEntity getTileEntity(@Nonnull IBlockStateWrapper state, @Nonnull BlockPos pos) {
        TileEntity te;
        IBlockAccess world = state.getWorld();
        if (world instanceof PaintedBlockAccessWrapper && (te = ((PaintedBlockAccessWrapper)world).getRealTileEntity(pos)) instanceof AbstractMachineEntity) {
            return te;
        }
        return state.getTileEntity();
    }
}

