/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.tank;

import com.enderio.core.api.common.util.ITankAccess;
import com.enderio.core.common.fluid.FluidWrapper;
import com.enderio.core.common.fluid.SmartTank;
import com.enderio.core.common.fluid.SmartTankFluidHandler;
import com.enderio.core.common.util.FluidUtil;
import com.enderio.core.common.util.ItemUtil;
import com.enderio.core.common.util.NNList;
import com.enderio.core.common.util.NullHelper;
import crazypants.enderio.base.EnderIO;
import crazypants.enderio.base.fluid.Fluids;
import crazypants.enderio.base.fluid.SmartTankFluidMachineHandler;
import crazypants.enderio.base.machine.baselegacy.AbstractInventoryMachineEntity;
import crazypants.enderio.base.machine.baselegacy.SlotDefinition;
import crazypants.enderio.base.paint.IPaintable;
import crazypants.enderio.base.recipe.IMachineRecipe;
import crazypants.enderio.base.recipe.MachineRecipeInput;
import crazypants.enderio.base.recipe.MachineRecipeRegistry;
import crazypants.enderio.base.recipe.RecipeLevel;
import crazypants.enderio.base.recipe.tank.TankMachineRecipe;
import crazypants.enderio.base.sound.SoundHelper;
import crazypants.enderio.base.sound.SoundRegistry;
import crazypants.enderio.base.xp.XpUtil;
import crazypants.enderio.machines.config.config.TankConfig;
import crazypants.enderio.machines.machine.tank.EnumTankType;
import crazypants.enderio.machines.machine.tank.PacketTankFluid;
import crazypants.enderio.machines.machine.tank.VoidMode;
import crazypants.enderio.machines.network.PacketHandler;
import crazypants.enderio.util.Prep;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.init.Enchantments;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

@Storable
public class TileTank
extends AbstractInventoryMachineEntity
implements ITankAccess.IExtendedTankAccess,
IPaintable.IPaintableTileEntity {
    private static int IO_MB_TICK = 100;
    @Store
    @Nonnull
    protected final SmartTank tank;
    protected int lastUpdateLevel = -1;
    private boolean tankDirty = false;
    private int lastFluidLuminosity = 0;
    @Nonnull
    private final EnumTankType tankType;
    @Store
    @Nonnull
    private VoidMode voidMode = VoidMode.NEVER;
    private static long lastSendTickAll = -1L;
    private long nextSendTickThis = -1L;
    private int sendPrio = 0;
    private SmartTankFluidHandler smartTankFluidHandler;

    public TileTank(@Nonnull EnumTankType tankType) {
        super(new SlotDefinition(0, 2, 3, 4, -1, -1));
        this.tank = tankType.getTank();
        this.tank.setTileEntity((TileEntity)this);
        this.tankType = tankType;
    }

    public TileTank() {
        this(EnumTankType.NORMAL);
    }

    @Override
    protected boolean doPush(@Nullable EnumFacing dir) {
        if (super.doPush(dir)) {
            return true;
        }
        if (dir != null && !this.tank.isEmpty() && FluidWrapper.transfer((FluidTank)this.tank, (IBlockAccess)this.field_145850_b, (BlockPos)this.func_174877_v().func_177972_a(dir), (EnumFacing)dir.func_176734_d(), (int)IO_MB_TICK) > 0) {
            this.setTanksDirty();
            return true;
        }
        return false;
    }

    @Override
    protected boolean doPull(@Nullable EnumFacing dir) {
        if (super.doPull(dir)) {
            return true;
        }
        if (dir != null && !this.tank.isFull() && FluidWrapper.transfer((IBlockAccess)this.field_145850_b, (BlockPos)this.func_174877_v().func_177972_a(dir), (EnumFacing)dir.func_176734_d(), (FluidTank)this.tank, (int)IO_MB_TICK) > 0) {
            this.setTanksDirty();
            return true;
        }
        return false;
    }

    private int getFilledLevel() {
        int level = (int)Math.floor(16.0f * this.tank.getFilledRatio());
        if (level == 0 && this.tank.getFluidAmount() > 0) {
            level = 1;
        }
        return level;
    }

    public boolean canVoidItems() {
        FluidStack fluid = this.tank.getFluid();
        return fluid != null && fluid.getFluid().getTemperature() > 973 && (Boolean)TankConfig.allowVoiding.get() != false;
    }

    @Nonnull
    public VoidMode getVoidMode() {
        return (Boolean)TankConfig.allowVoiding.get() != false ? this.voidMode : VoidMode.NEVER;
    }

    public void setVoidMode(@Nonnull VoidMode mode) {
        this.voidMode = mode;
    }

    @Override
    public boolean isMachineItemValidForSlot(int i, @Nonnull ItemStack item) {
        if (this.canVoidItems() && this.voidMode == VoidMode.ALWAYS && i < 2) {
            return false;
        }
        if (i == 0) {
            return FluidUtil.getFluidTypeFromItem((ItemStack)item) != null || this.isValidInputItem(item, false);
        }
        if (i == 1) {
            return FluidUtil.hasEmptyCapacity((ItemStack)item) || this.canBeMended(item) || this.isValidInputItem(item, true);
        }
        if (i == 2 && this.canVoidItems()) {
            return this.voidMode == VoidMode.ALWAYS || this.voidMode != VoidMode.NEVER && !FluidUtil.isFluidContainer((ItemStack)item);
        }
        return false;
    }

    private boolean isValidInputItem(@Nonnull ItemStack item, boolean isFilling) {
        NNList list = new NNList();
        list.add((Object)new MachineRecipeInput(0, item));
        list.add((Object)new MachineRecipeInput(1, (FluidStack)NullHelper.first((Object[])new FluidStack[]{this.tank.getFluid(), TankMachineRecipe.NOTHING})));
        return this.getRecipe(isFilling, (NNList<MachineRecipeInput>)list) != null;
    }

    private IMachineRecipe getRecipe(boolean isFilling, @Nonnull NNList<MachineRecipeInput> inputs) {
        return MachineRecipeRegistry.instance.getRecipeForInputs(this.tankType.isExplosionResistant() ? RecipeLevel.ADVANCED : RecipeLevel.NORMAL, isFilling ? "tankfill" : "tankempty", inputs);
    }

    @Nonnull
    private NNList<MachineRecipeInput> getRecipeInputs(boolean isFilling) {
        NNList list = new NNList();
        list.add((Object)new MachineRecipeInput(0, this.getStackInSlot(isFilling ? 1 : 0)));
        list.add((Object)new MachineRecipeInput(1, (FluidStack)NullHelper.first((Object[])new FluidStack[]{this.tank.getFluid(), TankMachineRecipe.NOTHING})));
        return list;
    }

    @Override
    public boolean isActive() {
        return false;
    }

    private boolean canSendClientUpdate() {
        long tick = EnderIO.proxy.getServerTickCount();
        if (this.nextSendTickThis > tick) {
            return false;
        }
        if (tick == lastSendTickAll && this.sendPrio++ < 200) {
            return false;
        }
        lastSendTickAll = tick;
        this.nextSendTickThis = lastSendTickAll + 10L + (long)(this.sendPrio * 2);
        this.sendPrio = 0;
        return true;
    }

    @Override
    protected boolean processTasks(boolean redstoneCheck) {
        this.processItems(redstoneCheck);
        int filledLevel = this.getFilledLevel();
        if (this.lastUpdateLevel != filledLevel) {
            this.lastUpdateLevel = filledLevel;
            this.setTanksDirty();
        }
        if (this.tankDirty && this.canSendClientUpdate()) {
            PacketHandler.sendToAllAround((IMessage)new PacketTankFluid(this), (TileEntity)this);
            this.field_145850_b.func_175666_e(this.field_174879_c, this.func_145838_q());
            this.updateLight();
            this.tankDirty = false;
        }
        return false;
    }

    public void updateLight() {
        int thisFluidLuminosity;
        FluidStack fluid = this.tank.getFluid();
        int n = thisFluidLuminosity = fluid == null || fluid.getFluid() == null || this.tank.isEmpty() ? 0 : fluid.getFluid().getLuminosity(fluid);
        if (thisFluidLuminosity != this.lastFluidLuminosity) {
            if (this.field_145850_b.func_180500_c(EnumSkyBlock.BLOCK, this.func_174877_v())) {
                this.updateBlock();
            }
            this.lastFluidLuminosity = thisFluidLuminosity;
        }
    }

    public int getComparatorOutput() {
        if (this.tank.isEmpty()) {
            return 0;
        }
        return (int)(1.0 + (double)this.tank.getFluidAmount() / (double)this.tank.getCapacity() * 14.0);
    }

    private boolean processItems(boolean redstoneCheck) {
        if (!redstoneCheck) {
            return false;
        }
        if (!this.shouldDoWorkThisTick(this.func_145832_p() > 0 ? 10 : 20)) {
            return false;
        }
        ItemStack stack = this.getStackInSlot(2);
        if (Prep.isValid(stack) && this.canVoidItems()) {
            if (((Boolean)TankConfig.tankSmeltTrashIntoLava.get()).booleanValue() && !this.tank.isFull() && this.tank.hasFluid(FluidRegistry.LAVA) && stack.func_77973_b() instanceof ItemBlock) {
                this.tank.addFluidAmount((int)MathHelper.func_151237_a((double)(this.field_145850_b.field_73012_v.nextGaussian() * 0.75 + 3.5), (double)1.0, (double)10.0));
                stack.func_190918_g(1);
            } else {
                stack.func_190918_g(10);
            }
            SoundHelper.playSound(this.field_145850_b, this.field_174879_c, SoundHelper.BLOCK_CENTER, SoundRegistry.ITEM_BURN, 0.05f, 2.0f + this.field_145850_b.field_73012_v.nextFloat() * 0.4f);
            this.func_70296_d();
        }
        return this.drainFullContainer() || this.fillEmptyContainer() || this.mendItem();
    }

    private boolean canBeMended(@Nonnull ItemStack stack) {
        return (Boolean)TankConfig.allowMending.get() != false && Prep.isValid(stack) && stack.func_77951_h() && EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185296_A, (ItemStack)stack) > 0 && this.tank.hasFluid(Fluids.XP_JUICE.getFluid());
    }

    private boolean mendItem() {
        int output = this.getSlotDefinition().getMaxOutputSlot();
        int input = this.getSlotDefinition().getMinInputSlot() + 1;
        if (this.tank.isEmpty() || !this.canBeMended(this.getStackInSlot(input)) || Prep.isValid(this.getStackInSlot(output))) {
            return false;
        }
        int damageMendable = Math.min(TileTank.xpToDurability(XpUtil.liquidToExperience(this.tank.getFluidAmount())), this.getStackInSlot(input).func_77952_i());
        if (damageMendable < 1) {
            return false;
        }
        this.getStackInSlot(input).func_77964_b(this.inventory[input].func_77952_i() - damageMendable);
        this.tank.drainInternal(XpUtil.experienceToLiquid(TileTank.durabilityToXp(damageMendable)), true);
        if (!this.getStackInSlot(input).func_77951_h()) {
            this.setInventorySlotContents(output, this.getStackInSlot(input));
            this.setInventorySlotContents(input, Prep.getEmpty());
        }
        this.func_70296_d();
        return true;
    }

    public static int durabilityToXp(int durability) {
        return durability / 2;
    }

    public static int xpToDurability(int xp) {
        return xp * 2;
    }

    private boolean fillEmptyContainer() {
        int output;
        ItemStack outputStack;
        int input = this.getSlotDefinition().getMinInputSlot() + 1;
        ItemStack inputStack = this.getStackInSlot(input);
        if (Prep.isInvalid(inputStack) || this.tank.isEmpty()) {
            return false;
        }
        IMachineRecipe recipe = null;
        FluidTank outputTank = this.getOutputTanks()[0];
        FluidUtil.FluidAndStackResult fill = FluidUtil.tryFillContainer((ItemStack)inputStack, (FluidStack)outputTank.getFluid());
        if (fill.result.fluidStack == null) {
            NNList<MachineRecipeInput> recipeInputs = this.getRecipeInputs(true);
            recipe = this.getRecipe(true, recipeInputs);
            if (recipe != null) {
                FluidStack fluidStack = null;
                ItemStack resultStack = null;
                for (IMachineRecipe.ResultStack result : recipe.getCompletedResult(0L, 0.0f, recipeInputs)) {
                    if (result.fluid != null) {
                        fluidStack = result.fluid;
                        continue;
                    }
                    resultStack = result.item;
                }
                if (fluidStack == null || resultStack == null) {
                    return false;
                }
                ItemStack remainderStack = inputStack.func_77946_l();
                remainderStack.func_190918_g(1);
                fill = new FluidUtil.FluidAndStackResult(resultStack, fluidStack, remainderStack, fluidStack);
            } else {
                return false;
            }
        }
        if (Prep.isValid(outputStack = this.getStackInSlot(output = this.getSlotDefinition().getMaxOutputSlot())) && Prep.isValid(fill.result.itemStack)) {
            if (outputStack.func_77985_e() && ItemUtil.areStackMergable((ItemStack)outputStack, (ItemStack)fill.result.itemStack) && fill.result.itemStack.func_190916_E() + outputStack.func_190916_E() <= outputStack.func_77976_d()) {
                fill.result.itemStack.func_190917_f(outputStack.func_190916_E());
            } else {
                return false;
            }
        }
        outputTank.setFluid(fill.remainder.fluidStack);
        this.setInventorySlotContents(input, fill.remainder.itemStack);
        this.setInventorySlotContents(output, fill.result.itemStack);
        if (recipe instanceof TankMachineRecipe) {
            ((TankMachineRecipe)recipe).getLogic().executeSFX(true, this.field_145850_b, this.field_174879_c);
        }
        this.setTanksDirty();
        this.func_70296_d();
        return false;
    }

    private boolean drainFullContainer() {
        int output;
        ItemStack outputStack;
        int input = this.getSlotDefinition().getMinInputSlot();
        ItemStack inputStack = this.getStackInSlot(input);
        if (Prep.isInvalid(inputStack) || this.tank.isFull()) {
            return false;
        }
        IMachineRecipe recipe = null;
        FluidUtil.FluidAndStackResult fill = FluidUtil.tryDrainContainer((ItemStack)inputStack, (ITankAccess)this);
        if (fill.result.fluidStack == null) {
            NNList<MachineRecipeInput> recipeInputs = this.getRecipeInputs(false);
            recipe = this.getRecipe(false, recipeInputs);
            if (recipe != null) {
                FluidStack fluidStack = null;
                ItemStack resultStack = null;
                for (IMachineRecipe.ResultStack result : recipe.getCompletedResult(0L, 0.0f, recipeInputs)) {
                    if (result.fluid != null) {
                        fluidStack = result.fluid;
                        continue;
                    }
                    resultStack = result.item;
                }
                if (fluidStack == null || resultStack == null) {
                    return false;
                }
                ItemStack remainderStack = inputStack.func_77946_l();
                remainderStack.func_190918_g(1);
                fill = new FluidUtil.FluidAndStackResult(resultStack, fluidStack, remainderStack, fluidStack);
            } else {
                return false;
            }
        }
        if (Prep.isValid(outputStack = this.getStackInSlot(output = this.getSlotDefinition().getMinOutputSlot())) && Prep.isValid(fill.result.itemStack)) {
            if (outputStack.func_77985_e() && ItemUtil.areStackMergable((ItemStack)outputStack, (ItemStack)fill.result.itemStack) && fill.result.itemStack.func_190916_E() + outputStack.func_190916_E() <= outputStack.func_77976_d()) {
                fill.result.itemStack.func_190917_f(outputStack.func_190916_E());
            } else {
                return false;
            }
        }
        this.getInputTank(fill.result.fluidStack).setFluid(fill.remainder.fluidStack);
        this.setInventorySlotContents(input, fill.remainder.itemStack);
        if (Prep.isValid(fill.result.itemStack)) {
            this.setInventorySlotContents(output, fill.result.itemStack);
        }
        if (recipe instanceof TankMachineRecipe) {
            ((TankMachineRecipe)recipe).getLogic().executeSFX(false, this.field_145850_b, this.field_174879_c);
        }
        this.setTanksDirty();
        this.func_70296_d();
        return false;
    }

    public FluidTank getInputTank(FluidStack forFluidType) {
        return this.tank;
    }

    @Nonnull
    public FluidTank[] getOutputTanks() {
        return new FluidTank[]{this.tank};
    }

    public void setTanksDirty() {
        if (!this.tankDirty) {
            this.tankDirty = true;
            this.func_70296_d();
        }
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 1 && this.tank.getFluidAmount() > 0;
    }

    @Nonnull
    public List<ITankAccess.ITankData> getTankDisplayData() {
        return Collections.singletonList(new ITankAccess.ITankData(){

            @Nonnull
            public ITankAccess.ITankData.EnumTankType getTankType() {
                return ITankAccess.ITankData.EnumTankType.STORAGE;
            }

            @Nullable
            public FluidStack getContent() {
                return TileTank.this.tank.getFluid();
            }

            public int getCapacity() {
                return TileTank.this.tank.getCapacity();
            }
        });
    }

    protected SmartTankFluidHandler getSmartTankFluidHandler() {
        if (this.smartTankFluidHandler == null) {
            this.smartTankFluidHandler = new SmartTankFluidMachineHandler(this, new IFluidHandler[]{this.tank});
        }
        return this.smartTankFluidHandler;
    }

    @Override
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facingIn) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)this.getSmartTankFluidHandler().get(facingIn);
        }
        return super.getCapability(capability, facingIn);
    }
}

