/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.util;

import com.enderio.core.common.util.DyeColor;
import com.enderio.core.common.util.EntityUtil;
import com.enderio.core.common.util.NNList;
import com.enderio.core.common.util.NullHelper;
import crazypants.enderio.base.EnderIO;
import crazypants.enderio.base.config.config.PersonalConfig;
import crazypants.enderio.base.init.ModObject;
import crazypants.enderio.base.lang.Lang;
import crazypants.enderio.base.scheduler.Celeb;
import crazypants.enderio.util.Prep;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.BlockWall;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityWitherSkeleton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public final class CapturedMob {
    @Nonnull
    private static final ResourceLocation PIG = new ResourceLocation("pig");
    @Nonnull
    private static final ResourceLocation DRAGON = new ResourceLocation("ender_dragon");
    @Nonnull
    public static final String ENTITY_KEY = "entity";
    @Nonnull
    public static final String ENTITY_ID_KEY = "entityId";
    @Nonnull
    public static final String CUSTOM_NAME_KEY = "customName";
    @Nonnull
    private static final NNList<ResourceLocation> blacklist = new NNList((Object[])new ResourceLocation[]{DRAGON});
    @Nonnull
    private static final NNList<ResourceLocation> unspawnablelist = new NNList();
    private static boolean bossesBlacklisted = true;
    @Nullable
    private final NBTTagCompound entityNbt;
    @Nonnull
    private final ResourceLocation entityId;
    @Nullable
    private final String customName;

    private CapturedMob(@Nonnull EntityLivingBase entity) {
        EntityLiving entLiv;
        ResourceLocation id = EntityList.func_191301_a((Entity)entity);
        this.entityId = id == null ? PIG : id;
        this.entityNbt = entity.serializeNBT();
        String name = null;
        if (entity instanceof EntityLiving && (entLiv = (EntityLiving)entity).func_145818_k_()) {
            name = entLiv.func_95999_t();
        }
        this.customName = name != null && name.length() > 0 ? name : null;
    }

    private CapturedMob(@Nonnull NBTTagCompound nbt) {
        this.entityNbt = nbt.func_74764_b(ENTITY_KEY) ? nbt.func_74775_l(ENTITY_KEY).func_74737_b() : null;
        String id = null;
        if (nbt.func_74764_b(ENTITY_ID_KEY)) {
            id = nbt.func_74779_i(ENTITY_ID_KEY);
        } else if (this.entityNbt != null && this.entityNbt.func_74764_b("id")) {
            id = ((NBTTagCompound)NullHelper.notnullJ((Object)this.entityNbt, (String)"private final field changed its value")).func_74779_i("id");
        }
        this.entityId = id == null || id.isEmpty() ? PIG : new ResourceLocation(id);
        this.customName = nbt.func_74764_b(CUSTOM_NAME_KEY) ? nbt.func_74779_i(CUSTOM_NAME_KEY) : null;
    }

    private CapturedMob(@Nonnull ResourceLocation entityId) {
        this.entityNbt = null;
        this.entityId = entityId;
        this.customName = null;
    }

    @Nullable
    public static CapturedMob create(@Nullable Entity entity) {
        if (!(entity instanceof EntityLivingBase) || !entity.func_70089_S() || entity.field_70170_p.field_72995_K || entity instanceof EntityPlayer || CapturedMob.isBlacklisted(entity)) {
            return null;
        }
        return new CapturedMob((EntityLivingBase)entity);
    }

    @Nullable
    public static CapturedMob create(@Nullable ResourceLocation entityId) {
        if (entityId == null || !EntityList.func_180125_b((ResourceLocation)entityId) || !EntityUtil.isRegisteredMob((ResourceLocation)entityId)) {
            return null;
        }
        return new CapturedMob(entityId);
    }

    @Nonnull
    public ItemStack toStack(@Nonnull Item item, int meta, int amount) {
        ItemStack stack = new ItemStack(item, amount, meta);
        stack.func_77982_d(this.toNbt(null));
        if (item == ModObject.itemSoulVial.getItem() && this.customName == null && PIG.equals((Object)this.entityId) && Math.random() < 0.01) {
            ((NBTTagCompound)NullHelper.notnullM((Object)stack.func_77978_p(), (String)"getTagCompound() doesn't produce value that was set with setTagCompound()")).func_74778_a(CUSTOM_NAME_KEY, Lang.EASTER_PIGGY.get());
        }
        return stack;
    }

    @Nonnull
    public ItemStack toStack(@Nonnull Block block, int meta, int amount) {
        ItemStack stack = new ItemStack(block, amount, meta);
        stack.func_77982_d(this.toNbt(null));
        return stack;
    }

    @Nonnull
    public ItemStack toGenericStack(@Nonnull Item item, int meta, int amount) {
        NBTTagCompound data = new NBTTagCompound();
        if (this.isUnspawnable(this.entityId)) {
            return this.toStack(item, meta, amount);
        }
        data.func_74778_a(ENTITY_ID_KEY, this.entityId.toString());
        if (item == ModObject.itemSoulVial.getItem() && this.customName == null && PIG.equals((Object)this.entityId) && Math.random() < 0.01) {
            data.func_74778_a(CUSTOM_NAME_KEY, Lang.EASTER_PIGGY.get());
        }
        ItemStack stack = new ItemStack(item, amount, meta);
        stack.func_77982_d(data);
        return stack;
    }

    @Nonnull
    public NBTTagCompound toNbt(@Nullable NBTTagCompound nbt) {
        NBTTagCompound data = nbt != null ? nbt : new NBTTagCompound();
        data.func_74778_a(ENTITY_ID_KEY, this.entityId.toString());
        if (this.entityNbt != null) {
            data.func_74782_a(ENTITY_KEY, (NBTBase)this.entityNbt.func_74737_b());
        }
        if (this.customName != null) {
            data.func_74778_a(CUSTOM_NAME_KEY, this.customName);
        }
        return data;
    }

    public static boolean containsSoul(@Nullable NBTTagCompound nbt) {
        return nbt != null && (nbt.func_74764_b(ENTITY_KEY) || nbt.func_74764_b(ENTITY_ID_KEY));
    }

    public static boolean containsSoul(@Nonnull ItemStack stack) {
        return Prep.isValid(stack) && stack.func_77942_o() && CapturedMob.containsSoul(stack.func_77978_p());
    }

    @Nullable
    public static CapturedMob create(@Nonnull ItemStack stack) {
        if (CapturedMob.containsSoul(stack)) {
            return new CapturedMob(stack.func_77978_p());
        }
        return null;
    }

    @Nullable
    public static CapturedMob create(@Nullable NBTTagCompound nbt) {
        if (nbt != null && CapturedMob.containsSoul(nbt)) {
            return new CapturedMob(nbt);
        }
        return null;
    }

    public static boolean isBlacklisted(@Nonnull Entity entity) {
        ResourceLocation entityId = EntityList.func_191301_a((Entity)entity);
        return entityId == null || CapturedMob.isBlacklistedBoss(entityId, entity) || blacklist.contains((Object)entityId);
    }

    private static boolean isBlacklistedBoss(ResourceLocation entityId, Entity entity) {
        return !bossesBlacklisted && !entity.func_184222_aU() && !"minecraft".equals(entityId.func_110624_b());
    }

    public boolean spawn(@Nullable World world, @Nullable BlockPos pos, @Nullable EnumFacing side, boolean clone) {
        return this.doSpawn(world, pos, side, clone) != null;
    }

    @Nullable
    public Entity doSpawn(@Nullable World world, @Nullable BlockPos pos, @Nullable EnumFacing side, boolean clone) {
        if (world == null || pos == null) {
            return null;
        }
        EnumFacing theSide = side != null ? side : EnumFacing.UP;
        Entity entity = this.getEntity(world, pos, null, clone);
        if (entity == null) {
            return null;
        }
        Block blk = world.func_180495_p(pos).func_177230_c();
        double spawnX = (double)(pos.func_177958_n() + theSide.func_82601_c()) + 0.5;
        double spawnY = pos.func_177956_o() + theSide.func_96559_d();
        double spawnZ = (double)(pos.func_177952_p() + theSide.func_82599_e()) + 0.5;
        if (theSide == EnumFacing.UP && (blk instanceof BlockFence || blk instanceof BlockWall || blk instanceof BlockFenceGate)) {
            spawnY += 0.5;
        }
        entity.func_70012_b(spawnX, spawnY, spawnZ, world.field_73012_v.nextFloat() * 360.0f, 0.0f);
        if (!world.func_72855_b(entity.func_174813_aQ()) || !world.func_184144_a(entity, entity.func_174813_aQ()).isEmpty()) {
            return null;
        }
        if (this.customName != null && entity instanceof EntityLiving) {
            ((EntityLiving)entity).func_96094_a(this.customName);
        }
        if (!world.func_72838_d(entity)) {
            entity.func_184221_a(MathHelper.func_180182_a((Random)world.field_73012_v));
            if (!world.func_72838_d(entity)) {
                return null;
            }
        }
        if (entity instanceof EntityLiving) {
            ((EntityLiving)entity).func_70642_aH();
        }
        return entity;
    }

    @Nullable
    public Entity getEntity(@Nullable World world, boolean clone) {
        return this.getEntity(world, null, null, clone);
    }

    @Nullable
    public Entity getEntity(@Nullable World world, @Nullable BlockPos pos, @Nullable DifficultyInstance difficulty, boolean clone) {
        if (world == null) {
            return null;
        }
        NBTTagCompound entityNbt_nullchecked = this.entityNbt;
        if (entityNbt_nullchecked != null && (clone || this.isUnspawnable(this.entityId))) {
            Entity entity = EntityList.func_75615_a((NBTTagCompound)entityNbt_nullchecked, (World)world);
            if (!clone && entity != null) {
                entity.func_184221_a(MathHelper.func_180182_a((Random)world.field_73012_v));
            }
            return entity;
        }
        Entity entity = EntityList.func_188429_b((ResourceLocation)this.entityId, (World)world);
        if (entity == null) {
            return null;
        }
        if (pos != null) {
            entity.func_70107_b((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        }
        if (entity instanceof EntityLiving) {
            if (pos != null && difficulty == null) {
                difficulty = world.func_175649_E(pos);
            }
            if (!(difficulty == null || pos != null && ForgeEventFactory.doSpecialSpawn((EntityLiving)((EntityLiving)entity), (World)world, (float)pos.func_177958_n(), (float)pos.func_177956_o(), (float)pos.func_177952_p(), null))) {
                ((EntityLiving)entity).func_180482_a(difficulty, null);
            }
        }
        if (entity instanceof EntityWitherSkeleton) {
            if (Celeb.H31.isOn() && Math.random() < 0.25 && ((Boolean)PersonalConfig.celebrateReformation.get()).booleanValue()) {
                entity.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack(Math.random() < 0.1 ? Blocks.field_150428_aP : Blocks.field_150423_aK));
                ((EntityWitherSkeleton)entity).func_184642_a(EntityEquipmentSlot.HEAD, 0.0f);
            } else if (Celeb.C06.isOn() && Math.random() < 0.25 && ((Boolean)PersonalConfig.celebrateNicholas.get()).booleanValue()) {
                entity.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack((Item)(Math.random() < 0.25 ? Items.field_151021_T : Items.field_151055_y)));
            } else if (Math.random() < 0.1) {
                entity.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(ModObject.itemDarkSteelSword.getItemNN()));
                ((EntityWitherSkeleton)entity).func_184642_a(EntityEquipmentSlot.MAINHAND, 1.0E-5f);
            }
        }
        return entity;
    }

    @Nonnull
    public String getDisplayName() {
        String baseName = EnderIO.lang.localizeExact("entity." + this.getTranslationName() + ".name");
        if (baseName.trim().isEmpty()) {
            if (this.customName != null && !this.customName.trim().isEmpty()) {
                return (String)NullHelper.notnullJ((Object)this.customName, (String)"private final field changed its value");
            }
            return "???";
        }
        if (this.customName != null && !this.customName.trim().isEmpty()) {
            return this.customName + " (" + baseName + ")";
        }
        return baseName;
    }

    public String getTranslationName() {
        return EntityList.func_191302_a((ResourceLocation)this.entityId);
    }

    public float getHealth() {
        if (this.entityNbt != null && this.entityNbt.func_74764_b("HealF")) {
            return ((NBTTagCompound)NullHelper.notnullJ((Object)this.entityNbt, (String)"private final field changed its value")).func_74760_g("HealF");
        }
        return Float.NaN;
    }

    public float getMaxHealth() {
        NBTTagCompound maxHealthAttrib = this.getAttribute("generic.maxHealth");
        if (maxHealthAttrib != null && maxHealthAttrib.func_74764_b("Base")) {
            return maxHealthAttrib.func_74760_g("Base");
        }
        return Float.NaN;
    }

    @Nullable
    public NBTTagCompound getAttribute(@Nullable String name) {
        NBTBase tag;
        if (name != null && this.entityNbt != null && this.entityNbt.func_74764_b("Attributes") && (tag = ((NBTTagCompound)NullHelper.notnullJ((Object)this.entityNbt, (String)"private final field changed its value")).func_74781_a("Attributes")) instanceof NBTTagList) {
            NBTTagList attributes = (NBTTagList)tag;
            for (int i = 0; i < attributes.func_74745_c(); ++i) {
                NBTTagCompound attrib = attributes.func_150305_b(i);
                if (!attrib.func_74764_b("Name") || !name.equals(attrib.func_74779_i("Name"))) continue;
                return attrib;
            }
        }
        return null;
    }

    @Nullable
    public DyeColor getColor() {
        int colorIdx;
        if (this.entityNbt != null && this.entityNbt.func_74764_b("Color") && (colorIdx = ((NBTTagCompound)NullHelper.notnullJ((Object)this.entityNbt, (String)"private final field changed its value")).func_74762_e("Color")) >= 0 && colorIdx <= 15) {
            return DyeColor.values()[15 - colorIdx];
        }
        return null;
    }

    @Nullable
    public String getFluidName() {
        if (this.entityNbt != null && this.entityNbt.func_74764_b("FluidName")) {
            return ((NBTTagCompound)NullHelper.notnullJ((Object)this.entityNbt, (String)"private final field changed its value")).func_74779_i("FluidName");
        }
        return null;
    }

    public static void addToBlackList(ResourceLocation entityName) {
        blacklist.add((Object)entityName);
    }

    public static void addToUnspawnableList(ResourceLocation entityName) {
        unspawnablelist.add((Object)entityName);
    }

    private boolean isUnspawnable(ResourceLocation entityName) {
        return unspawnablelist.contains((Object)entityName);
    }

    @Nonnull
    public ResourceLocation getEntityName() {
        return this.entityId;
    }

    public boolean isSameType(Entity entity) {
        return entity != null && this.getEntityName().equals((Object)EntityList.func_191301_a((Entity)entity));
    }

    public boolean isSameType(CapturedMob other) {
        return other != null && this.getEntityName().equals((Object)other.getEntityName());
    }

    public String toString() {
        return "CapturedMob [entityId=" + this.entityId + ", " + (this.customName != null ? "customName=" + this.customName + ", " : "") + (this.entityNbt != null ? "entityNbt=" + this.entityNbt + ", " : "") + "getDisplayName()=" + this.getDisplayName() + ", getHealth()=" + this.getHealth() + ", getMaxHealth()=" + this.getMaxHealth() + ", " + (this.getColor() != null ? "getColor()=" + this.getColor() + ", " : "") + (this.getFluidName() != null ? "getFluidName()=" + this.getFluidName() : "") + "]";
    }

    @Nonnull
    public static NNList<CapturedMob> getSouls(List<ResourceLocation> list) {
        NNList result = new NNList();
        for (ResourceLocation mobName : list) {
            CapturedMob soul = CapturedMob.create(mobName);
            if (soul == null || DRAGON.equals((Object)mobName)) continue;
            result.add((Object)soul);
        }
        return result;
    }

    @Nonnull
    public static NNList<CapturedMob> getAllSouls() {
        return CapturedMob.getSouls((List<ResourceLocation>)EntityUtil.getAllRegisteredMobNames());
    }

    public static void setBossesBlacklisted(boolean b) {
        bossesBlacklisted = b;
    }
}

