/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.api;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.registry.RegistryNamespaced;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import vazkii.psi.api.cad.ICAD;
import vazkii.psi.api.internal.DummyMethodHandler;
import vazkii.psi.api.internal.IInternalMethodHandler;
import vazkii.psi.api.recipe.TrickRecipe;
import vazkii.psi.api.spell.PieceGroup;
import vazkii.psi.api.spell.SpellPiece;

public final class PsiAPI {
    public static IInternalMethodHandler internalHandler = new DummyMethodHandler();
    public static RegistryNamespaced<String, Class<? extends SpellPiece>> spellPieceRegistry = new RegistryNamespaced();
    public static HashMap<String, ResourceLocation> simpleSpellTextures = new HashMap();
    public static HashMap<Class<? extends SpellPiece>, PieceGroup> groupsForPiece = new HashMap();
    public static HashMap<Class<? extends SpellPiece>, String> pieceMods = new HashMap();
    public static HashMap<String, PieceGroup> groupsForName = new HashMap();
    public static List<TrickRecipe> trickRecipes = new ArrayList<TrickRecipe>();
    public static Item.ToolMaterial PSIMETAL_TOOL_MATERIAL = EnumHelper.addToolMaterial((String)"PSIMETAL", (int)3, (int)900, (float)7.8f, (float)2.0f, (int)12);
    public static ItemArmor.ArmorMaterial PSIMETAL_ARMOR_MATERIAL = EnumHelper.addArmorMaterial((String)"PSIMETAL", (String)"psimetal", (int)18, (int[])new int[]{2, 6, 5, 2}, (int)12, (SoundEvent)SoundEvents.field_187725_r, (float)0.0f);
    public static int levelCap = 1;

    private static String getCurrentModId() {
        ModContainer activeModContainer = Loader.instance().activeModContainer();
        if (activeModContainer != null) {
            return activeModContainer.getModId();
        }
        return "minecraft";
    }

    public static void registerSpellPiece(String key, Class<? extends SpellPiece> clazz) {
        spellPieceRegistry.func_82595_a((Object)key, clazz);
        pieceMods.put(clazz, PsiAPI.getCurrentModId());
    }

    public static void registerSpellPieceAndTexture(String key, Class<? extends SpellPiece> clazz) {
        PsiAPI.registerSpellPieceAndTexture(key, PsiAPI.getCurrentModId(), clazz);
    }

    private static void registerSpellPieceAndTexture(String key, String mod, Class<? extends SpellPiece> clazz) {
        PsiAPI.registerSpellPiece(key, clazz);
        String textureName = key.replaceAll("([a-z0-9])([A-Z])", "$1_$2").toLowerCase();
        simpleSpellTextures.put(key, new ResourceLocation(mod, String.format("textures/spell/%s.png", textureName)));
    }

    public static void addPieceToGroup(Class<? extends SpellPiece> clazz, String groupName, boolean main) {
        if (!groupsForName.containsKey(groupName)) {
            PsiAPI.addGroup(groupName);
        }
        PieceGroup group = groupsForName.get(groupName);
        group.addPiece(clazz, main);
        groupsForPiece.put(clazz, group);
    }

    public static void setGroupRequirements(String groupName, int level, String ... reqs) {
        if (!groupsForName.containsKey(groupName)) {
            PsiAPI.addGroup(groupName);
        }
        PieceGroup group = groupsForName.get(groupName);
        group.setRequirements(level, reqs);
    }

    private static void addGroup(String groupName) {
        groupsForName.put(groupName, new PieceGroup(groupName));
        ++levelCap;
    }

    public static ItemStack getPlayerCAD(EntityPlayer player) {
        if (player == null) {
            return ItemStack.field_190927_a;
        }
        ItemStack cad = ItemStack.field_190927_a;
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack stackAt = player.field_71071_by.func_70301_a(i);
            if (stackAt.func_190926_b() || !(stackAt.func_77973_b() instanceof ICAD)) continue;
            if (!cad.func_190926_b()) {
                return ItemStack.field_190927_a;
            }
            cad = stackAt;
        }
        return cad;
    }

    public static int getPlayerCADSlot(EntityPlayer player) {
        if (player == null) {
            return -1;
        }
        int slot = -1;
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack stackAt = player.field_71071_by.func_70301_a(i);
            if (stackAt.func_190926_b() || !(stackAt.func_77973_b() instanceof ICAD)) continue;
            if (slot != -1) {
                return -1;
            }
            slot = i;
        }
        return slot;
    }

    public static boolean canCADBeUpdated(EntityPlayer player) {
        if (player == null) {
            return false;
        }
        if (player.field_71070_bA == null) {
            return true;
        }
        int cadSlot = PsiAPI.getPlayerCADSlot(player);
        return cadSlot < 9 || cadSlot == 40;
    }

    public static void registerTrickRecipe(String trick, Object input, ItemStack output, ItemStack minAssembly) {
        trickRecipes.add(new TrickRecipe(trick, CraftingHelper.getIngredient((Object)input), output, minAssembly));
    }
}

