/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.item.tool;

import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import vazkii.arl.item.ItemMod;
import vazkii.arl.item.ItemModTool;
import vazkii.arl.util.ItemNBTHelper;
import vazkii.psi.api.PsiAPI;
import vazkii.psi.api.cad.ISocketable;
import vazkii.psi.common.core.PsiCreativeTab;
import vazkii.psi.common.core.handler.PlayerDataHandler;
import vazkii.psi.common.item.ItemCAD;
import vazkii.psi.common.item.base.ModItems;
import vazkii.psi.common.item.tool.IPsimetalTool;

public class ItemPsimetalTool
extends ItemModTool
implements IPsimetalTool {
    private static final String TAG_REGEN_TIME = "regenTime";

    protected ItemPsimetalTool(String name, float attackDamage, float speed, Set<Block> effectiveBlocks, String ... variants) {
        super(name, attackDamage, speed, PsiAPI.PSIMETAL_TOOL_MATERIAL, effectiveBlocks, variants);
        this.func_77637_a(PsiCreativeTab.INSTANCE);
    }

    public boolean onBlockStartBreak(ItemStack itemstack, BlockPos pos, EntityPlayer player) {
        super.onBlockStartBreak(itemstack, pos, player);
        PlayerDataHandler.PlayerData data = PlayerDataHandler.get(player);
        ItemStack playerCad = PsiAPI.getPlayerCAD(player);
        if (!playerCad.func_190926_b()) {
            ItemStack bullet = this.getBulletInSocket(itemstack, this.getSelectedSlot(itemstack));
            ItemCAD.cast(player.func_130014_f_(), player, data, bullet, playerCad, 5, 10, 0.05f, context -> {
                context.tool = itemstack;
                context.positionBroken = ItemPsimetalTool.raytraceFromEntity(player.func_130014_f_(), (Entity)player, false, player.func_110140_aT().func_111151_a(EntityPlayer.REACH_DISTANCE).func_111126_e());
            });
        }
        return false;
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        ItemPsimetalTool.regen(stack, entityIn, isSelected);
    }

    public static void regen(ItemStack stack, Entity entityIn, boolean isSelected) {
        if (entityIn instanceof EntityPlayer && stack.func_77952_i() > 0 && !isSelected) {
            EntityPlayer player = (EntityPlayer)entityIn;
            PlayerDataHandler.PlayerData data = PlayerDataHandler.get(player);
            int regenTime = ItemNBTHelper.getInt((ItemStack)stack, (String)TAG_REGEN_TIME, (int)0);
            if (!data.overflowed && regenTime % 80 == 0 && (float)data.getAvailablePsi() / (float)data.getTotalPsi() > 0.5f) {
                data.deductPsi(600, 5, true);
                stack.func_77964_b(stack.func_77952_i() - 1);
            }
            ItemNBTHelper.setInt((ItemStack)stack, (String)TAG_REGEN_TIME, (int)(regenTime + 1));
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, @Nonnull ItemStack newStack, boolean slotChanged) {
        return slotChanged;
    }

    public void func_77624_a(ItemStack stack, World playerIn, List<String> tooltip, ITooltipFlag advanced) {
        String componentName = ItemMod.local((String)ISocketable.getSocketedItemName(stack, "psimisc.none"));
        ItemMod.addToTooltip(tooltip, (String)"psimisc.spellSelected", (Object[])new Object[]{componentName});
    }

    public boolean func_82789_a(ItemStack par1ItemStack, @Nonnull ItemStack par2ItemStack) {
        return par2ItemStack.func_77973_b() == ModItems.material && par2ItemStack.func_77952_i() == 1 ? true : super.func_82789_a(par1ItemStack, par2ItemStack);
    }

    public static RayTraceResult raytraceFromEntity(World world, Entity player, boolean par3, double range) {
        float f = 1.0f;
        float f1 = player.field_70127_C + (player.field_70125_A - player.field_70127_C) * f;
        float f2 = player.field_70126_B + (player.field_70177_z - player.field_70126_B) * f;
        double d0 = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)f;
        double d1 = player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)f;
        if (player instanceof EntityPlayer) {
            d1 += (double)((EntityPlayer)player).eyeHeight;
        }
        double d2 = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)f;
        Vec3d vec3 = new Vec3d(d0, d1, d2);
        float f3 = MathHelper.func_76134_b((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = MathHelper.func_76126_a((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f5 = -MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180)));
        float f6 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180)));
        float f7 = f4 * f5;
        float f8 = f3 * f5;
        double d3 = range;
        Vec3d vec31 = vec3.func_72441_c((double)f7 * d3, (double)f6 * d3, (double)f8 * d3);
        return world.func_72901_a(vec3, vec31, par3);
    }

    @Override
    public boolean requiresSneakForSpellSet(ItemStack stack) {
        return false;
    }
}

