/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.worlddata;

import appeng.core.AELog;
import appeng.core.worlddata.IWorldSpawnData;
import appeng.core.worlddata.MeteorDataNameEncoder;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

final class SpawnData
implements IWorldSpawnData {
    @Nonnull
    private final File spawnDirectory;
    @Nonnull
    private final MeteorDataNameEncoder encoder;

    public SpawnData(@Nonnull File spawnDirectory) {
        Preconditions.checkNotNull((Object)spawnDirectory);
        this.spawnDirectory = spawnDirectory;
        this.encoder = new MeteorDataNameEncoder(4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setGenerated(int dim, int chunkX, int chunkZ) {
        Class<SpawnData> clazz = SpawnData.class;
        synchronized (SpawnData.class) {
            NBTTagCompound data = this.loadSpawnData(dim, chunkX, chunkZ);
            data.func_74757_a(chunkX + "," + chunkZ, true);
            this.writeSpawnData(dim, chunkX, chunkZ, data);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasGenerated(int dim, int chunkX, int chunkZ) {
        Class<SpawnData> clazz = SpawnData.class;
        synchronized (SpawnData.class) {
            NBTTagCompound data = this.loadSpawnData(dim, chunkX, chunkZ);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return data.func_74767_n(chunkX + "," + chunkZ);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addNearByMeteorites(int dim, int chunkX, int chunkZ, NBTTagCompound newData) {
        Class<SpawnData> clazz = SpawnData.class;
        synchronized (SpawnData.class) {
            NBTTagCompound data = this.loadSpawnData(dim, chunkX, chunkZ);
            int size = data.func_74762_e("num");
            data.func_74782_a(String.valueOf(size), (NBTBase)newData);
            data.func_74768_a("num", size + 1);
            this.writeSpawnData(dim, chunkX, chunkZ, data);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<NBTTagCompound> getNearByMeteorites(int dim, int chunkX, int chunkZ) {
        ArrayList<NBTTagCompound> ll = new ArrayList<NBTTagCompound>();
        Class<SpawnData> clazz = SpawnData.class;
        synchronized (SpawnData.class) {
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    int cx = x + (chunkX >> 4);
                    int cz = z + (chunkZ >> 4);
                    NBTTagCompound data = this.loadSpawnData(dim, cx << 4, cz << 4);
                    if (data == null) continue;
                    int size = data.func_74762_e("num");
                    for (int s = 0; s < size; ++s) {
                        ll.add(data.func_74775_l(String.valueOf(s)));
                    }
                }
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return ll;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NBTTagCompound loadSpawnData(int dim, int chunkX, int chunkZ) {
        if (!Thread.holdsLock(SpawnData.class)) {
            throw new IllegalStateException("Invalid Request");
        }
        NBTTagCompound data = null;
        String fileName = this.encoder.encode(dim, chunkX, chunkZ);
        File file = new File(this.spawnDirectory, fileName);
        if (file.isFile()) {
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(file);
                data = CompressedStreamTools.func_74796_a((InputStream)fileInputStream);
            }
            catch (Throwable e) {
                data = new NBTTagCompound();
                AELog.debug(e);
            }
            finally {
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException e) {
                        AELog.debug(e);
                    }
                }
            }
        } else {
            data = new NBTTagCompound();
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeSpawnData(int dim, int chunkX, int chunkZ, NBTTagCompound data) {
        if (!Thread.holdsLock(SpawnData.class)) {
            throw new IllegalStateException("Invalid Request");
        }
        String fileName = this.encoder.encode(dim, chunkX, chunkZ);
        File file = new File(this.spawnDirectory, fileName);
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            CompressedStreamTools.func_74799_a((NBTTagCompound)data, (OutputStream)fileOutputStream);
        }
        catch (Throwable e) {
            AELog.debug(e);
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException e) {
                    AELog.debug(e);
                }
            }
        }
    }
}

