/*
 * Decompiled with CFR 0.152.
 */
package com.tattyseal.compactstorage.block;

import com.tattyseal.compactstorage.CompactStorage;
import com.tattyseal.compactstorage.exception.InvalidSizeException;
import com.tattyseal.compactstorage.tileentity.TileEntityChest;
import com.tattyseal.compactstorage.util.EntityUtil;
import com.tattyseal.compactstorage.util.LogHelper;
import java.awt.Color;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockChest
extends Block
implements ITileEntityProvider {
    protected static final AxisAlignedBB NOT_CONNECTED_AABB = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.875, 0.9375);

    public BlockChest() {
        super(Material.field_151575_d);
        this.func_149663_c("compactchest");
        this.setRegistryName("compactChest");
        this.func_149647_a(CompactStorage.tabCS);
        this.func_149711_c(2.0f);
        this.func_149752_b(2.0f);
        this.setHarvestLevel("axe", 1);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return NOT_CONNECTED_AABB;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase entity, ItemStack stack) {
        super.func_180633_a(world, pos, state, entity, stack);
        TileEntityChest chest = (TileEntityChest)world.func_175625_s(pos);
        if (chest == null) {
            return;
        }
        if (stack.func_82837_s()) {
            chest.setCustomName(stack.func_82833_r());
        }
        chest.direction = EntityUtil.get2dOrientation(entity);
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("size")) {
            if (stack.func_77978_p().func_74781_a("size") instanceof NBTTagIntArray) {
                chest.invX = stack.func_77978_p().func_74759_k("size")[0];
                chest.invY = stack.func_77978_p().func_74759_k("size")[1];
                if (stack.func_77978_p().func_74764_b("hue")) {
                    chest.setHue(stack.func_77978_p().func_74762_e("hue"));
                    chest.color = chest.getHue() == -1 ? Color.white : Color.getHSBColor(stack.func_77978_p().func_74762_e("hue"), 50.0f, 50.0f);
                } else if (stack.func_77978_p().func_74764_b("color") && !stack.func_77978_p().func_74764_b("hue")) {
                    String color = stack.func_77978_p().func_74779_i("color");
                    if (color.startsWith("0x")) {
                        color = "#" + color.substring(2);
                    }
                    chest.color = color.equals("") ? Color.white : Color.decode(color);
                    float[] hsbVals = new float[3];
                    hsbVals = Color.RGBtoHSB(chest.color.getRed(), chest.color.getGreen(), chest.color.getBlue(), hsbVals);
                    chest.setHue((int)hsbVals[0] * 360);
                } else {
                    chest.color = Color.white;
                }
                chest.items = new ItemStack[chest.invX * chest.invY];
            } else if (entity instanceof EntityPlayer) {
                entity.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "You attempted something bad! :("));
                chest.invX = 9;
                chest.invY = 3;
                chest.items = new ItemStack[chest.invX * chest.invY];
                chest.setHue(180);
                chest.color = Color.white;
                InvalidSizeException exception = new InvalidSizeException("You tried to pass off a " + stack.func_77978_p().func_74781_a("size").getClass().getName() + " as a Integer Array. Do not report this or you will be ignored. This is a user based error.");
                exception.printStackTrace();
            }
        } else if (entity instanceof EntityPlayer) {
            entity.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "You attempted something bad! :("));
            chest.invX = 9;
            chest.invY = 3;
            chest.items = new ItemStack[chest.invX * chest.invY];
            chest.setHue(180);
            chest.color = Color.white;
        }
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("chestData")) {
            NBTTagCompound chestData = stack.func_77978_p().func_74775_l("chestData");
            chestData.func_82580_o("facing");
            chestData.func_74768_a("x", pos.func_177958_n());
            chestData.func_74768_a("y", pos.func_177956_o());
            chestData.func_74768_a("z", pos.func_177952_p());
            chest.func_145839_a(chestData);
            chest.func_70296_d();
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float x, float y, float z) {
        if (!world.field_72995_K) {
            if (!player.func_70093_af()) {
                player.openGui((Object)CompactStorage.instance, 0, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                return true;
            }
            ItemStack held = player.func_184586_b(EnumHand.MAIN_HAND);
            TileEntityChest chest = (TileEntityChest)world.func_175625_s(pos);
            if (chest != null && !chest.getRetaining() && !held.func_190926_b() && held.func_77973_b() == Items.field_151045_i) {
                chest.setRetaining(true);
                held.func_190920_e(held.func_190916_E() - 1);
                player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.AQUA + "Chest will now retain items when broken!"));
                world.func_184133_a(null, pos, SoundEvents.field_187604_bf, SoundCategory.AMBIENT, 1.0f, 1.0f);
                chest.updateBlock();
            }
        }
        return !player.func_70093_af();
    }

    public TileEntity func_149915_a(@Nonnull World world, int dim) {
        return new TileEntityChest();
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.INVISIBLE;
    }

    public void func_180663_b(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        LogHelper.dump("breakBlock()");
        TileEntityChest chest = (TileEntityChest)world.func_175625_s(pos);
        if (chest != null) {
            ItemStack stack = new ItemStack(CompactStorage.ModBlocks.chest, 1);
            Random rand = new Random();
            stack.func_77982_d(new NBTTagCompound());
            int invX = chest.invX;
            int invY = chest.invY;
            int hue = chest.getHue();
            int color = chest.color.getRGB();
            String colorString = String.format("0x%06X", 0xFFFFFF & color);
            stack.func_77978_p().func_74783_a("size", new int[]{invX, invY});
            stack.func_77978_p().func_74778_a("color", colorString);
            stack.func_77978_p().func_74768_a("hue", hue);
            if (chest.getRetaining()) {
                NBTTagCompound chestData = new NBTTagCompound();
                chest.func_189515_b(chestData);
                stack.func_77978_p().func_74782_a("chestData", (NBTBase)chestData);
            } else {
                for (int slot = 0; slot < chest.items.length; ++slot) {
                    float randX = rand.nextFloat();
                    float randZ = rand.nextFloat();
                    if (chest.items == null || chest.items[slot] == null || chest.items[slot] == ItemStack.field_190927_a) continue;
                    world.func_72838_d((Entity)new EntityItem(world, (double)((float)pos.func_177958_n() + randX), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + randZ), chest.items[slot]));
                }
            }
            world.func_72838_d((Entity)new EntityItem(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), stack));
        }
        super.func_180663_b(world, pos, state);
    }

    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> items) {
        items.add((Object)new ItemStack((Block)this, 1, 4));
    }

    @Nonnull
    public ItemStack getPickBlock(@Nonnull IBlockState state, RayTraceResult target, @Nonnull World world, @Nonnull BlockPos pos, EntityPlayer player) {
        ItemStack stack = new ItemStack(CompactStorage.ModBlocks.chest, 1);
        TileEntityChest chest = (TileEntityChest)world.func_175625_s(pos);
        stack.func_77982_d(new NBTTagCompound());
        stack.func_77978_p().func_74783_a("size", new int[]{chest.invX, chest.invY});
        return stack;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return null;
    }
}

