/*
 * Decompiled with CFR 0.152.
 */
package com.tattyseal.compactstorage.inventory;

import com.tattyseal.compactstorage.inventory.slot.SlotChestBuilder;
import com.tattyseal.compactstorage.inventory.slot.SlotUnplaceable;
import com.tattyseal.compactstorage.tileentity.TileEntityChestBuilder;
import com.tattyseal.compactstorage.util.StorageInfo;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ContainerChestBuilder
extends Container {
    public World world;
    public EntityPlayer player;
    public BlockPos pos;
    public TileEntityChestBuilder chest;
    private int xSize;
    private int ySize;

    public ContainerChestBuilder(World world, EntityPlayer player, BlockPos pos) {
        this.world = world;
        this.player = player;
        this.pos = pos;
        this.chest = (TileEntityChestBuilder)world.func_175625_s(pos);
        this.xSize = 176;
        this.ySize = 211;
        this.setupSlots();
    }

    public boolean func_75145_c(@Nonnull EntityPlayer player) {
        return true;
    }

    private void setupSlots() {
        int x;
        int slotY = 62;
        int slotX = this.xSize / 2 - 36;
        for (int x2 = 0; x2 < 4; ++x2) {
            SlotChestBuilder slot = new SlotChestBuilder(this.chest, x2, slotX + x2 * 18 + 1, slotY + 21);
            this.func_75146_a(slot);
        }
        SlotUnplaceable chestSlot = new SlotUnplaceable(this.chest, 4, 5 + this.xSize - 29, 104);
        this.func_75146_a(chestSlot);
        slotX = this.xSize / 2 - 81 + 1;
        slotY = 126;
        for (x = 0; x < 9; ++x) {
            for (int y = 0; y < 3; ++y) {
                Slot slot = new Slot((IInventory)this.player.field_71071_by, x + y * 9 + 9, slotX + x * 18, slotY + y * 18);
                this.func_75146_a(slot);
            }
        }
        slotY = slotY + 54 + 4;
        for (x = 0; x < 9; ++x) {
            Slot slot = new Slot((IInventory)this.player.field_71071_by, x, slotX + x * 18, slotY);
            this.func_75146_a(slot);
        }
    }

    @Nonnull
    public ItemStack func_82846_b(EntityPlayer player, int slotIndex) {
        try {
            Slot slot = (Slot)this.field_75151_b.get(slotIndex);
            if (slot != null && slot.func_75216_d()) {
                ItemStack itemStack1 = slot.func_75211_c();
                ItemStack itemStack = itemStack1.func_77946_l();
                if (slotIndex < 5 ? !this.func_75135_a(itemStack1, 5, 41, false) : !this.func_75135_a(itemStack1, 0, 5, false)) {
                    return ItemStack.field_190927_a;
                }
                if (itemStack1.func_190916_E() == 0) {
                    slot.func_75215_d(ItemStack.field_190927_a);
                } else {
                    slot.func_75218_e();
                }
                return itemStack;
            }
            return ItemStack.field_190927_a;
        }
        catch (Exception e) {
            e.printStackTrace();
            return ItemStack.field_190927_a;
        }
    }

    public void func_75132_a(IContainerListener listener) {
        super.func_75132_a(listener);
        listener.func_71112_a((Container)this, 0, 9);
        listener.func_71112_a((Container)this, 1, 3);
    }

    public void func_75142_b() {
        super.func_75142_b();
        for (IContainerListener player : this.field_75149_d) {
            if (this.chest != null && this.chest.info != null) {
                player.func_71112_a((Container)this, 0, this.chest.info.getSizeX());
            }
            if (this.chest != null && this.chest.info != null) {
                player.func_71112_a((Container)this, 1, this.chest.info.getSizeY());
            }
            if (this.chest != null && this.chest.info != null) {
                player.func_71112_a((Container)this, 2, this.chest.info.getHue());
            }
            if (this.chest == null || this.chest.info == null) continue;
            player.func_71112_a((Container)this, 3, this.chest.info.getType().ordinal());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_75137_b(int id, int value) {
        if (this.chest.info == null) {
            this.chest.info = new StorageInfo(9, 3, 180, StorageInfo.Type.CHEST);
        }
        switch (id) {
            case 0: {
                this.chest.info.setSizeX(value);
                break;
            }
            case 1: {
                this.chest.info.setSizeY(value);
                break;
            }
            case 2: {
                this.chest.info.setHue(value);
                break;
            }
            case 3: {
                this.chest.info.setType(StorageInfo.Type.values()[value]);
            }
        }
    }
}

