/*
 * Decompiled with CFR 0.152.
 */
package com.tattyseal.compactstorage.network.handler;

import com.tattyseal.compactstorage.CompactStorage;
import com.tattyseal.compactstorage.network.packet.C02PacketCraftChest;
import com.tattyseal.compactstorage.tileentity.TileEntityChestBuilder;
import com.tattyseal.compactstorage.util.LogHelper;
import com.tattyseal.compactstorage.util.StorageInfo;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.oredict.OreDictionary;

public class C02HandlerCraftChest
implements IMessageHandler<C02PacketCraftChest, IMessage> {
    public IMessage onMessage(final C02PacketCraftChest message, MessageContext ctx) {
        if (!ctx.side.equals((Object)Side.SERVER)) {
            return null;
        }
        final WorldServer world = ctx.getServerHandler().field_147369_b.func_71121_q();
        world.func_152344_a(new Runnable(){

            @Override
            public void run() {
                TileEntityChestBuilder builder = (TileEntityChestBuilder)world.func_175625_s(new BlockPos(message.x, message.y, message.z));
                if (builder == null) {
                    return;
                }
                LogHelper.dump(builder.info.getType().name);
                ItemStack[] itemsArray = new ItemStack[4];
                System.arraycopy(builder.items, 0, itemsArray, 0, 4);
                List<ItemStack> items = Arrays.asList(itemsArray);
                List<ItemStack> requiredItems = builder.info.getMaterialCost();
                boolean hasRequiredMaterials = true;
                for (int slot = 0; slot < items.size(); ++slot) {
                    ItemStack stack = items.get(slot);
                    if (stack != null && slot < requiredItems.size() && requiredItems.get(slot) != null) {
                        if (!OreDictionary.itemMatches((ItemStack)requiredItems.get(slot), (ItemStack)stack, (boolean)false) || stack.func_190916_E() < requiredItems.get(slot).func_190916_E()) {
                            hasRequiredMaterials = requiredItems.get(slot) != null && requiredItems.get(slot).func_190916_E() == 0;
                            break;
                        }
                    } else {
                        hasRequiredMaterials = false;
                        break;
                    }
                    hasRequiredMaterials = true;
                }
                LogHelper.dump("HAS REQ MATS: " + hasRequiredMaterials);
                if (hasRequiredMaterials && builder.func_70301_a(4).func_190926_b()) {
                    ItemStack stack = new ItemStack(message.info.getType().equals((Object)StorageInfo.Type.BACKPACK) ? CompactStorage.ModItems.backpack : ItemBlock.func_150898_a((Block)CompactStorage.ModBlocks.chest), 1);
                    NBTTagCompound tag = new NBTTagCompound();
                    tag.func_74783_a("size", new int[]{message.info.getSizeX(), message.info.getSizeY()});
                    tag.func_74768_a("hue", message.info.getHue());
                    stack.func_77982_d(tag);
                    builder.func_70299_a(4, stack);
                    LogHelper.dump("SPAWNED ITEM ENTITY");
                    for (int x = 0; x < requiredItems.size(); ++x) {
                        builder.func_70298_a(x, requiredItems.get(x).func_190916_E());
                        LogHelper.dump("DECREASED ITEMS IN INVENTORY");
                    }
                    world.func_184133_a(null, builder.func_174877_v(), SoundEvents.field_187604_bf, SoundCategory.AMBIENT, 1.0f, 1.0f);
                } else {
                    world.func_184133_a(null, builder.func_174877_v(), SoundEvents.field_187604_bf, SoundCategory.AMBIENT, 1.0f, 0.0f);
                }
            }
        });
        return null;
    }
}

