/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.lib.gui;

import com.feed_the_beast.ftblib.FTBLibConfig;
import com.feed_the_beast.ftblib.events.client.CustomClickEvent;
import com.feed_the_beast.ftblib.lib.client.ClientUtils;
import com.feed_the_beast.ftblib.lib.gui.ContextMenu;
import com.feed_the_beast.ftblib.lib.gui.ContextMenuItem;
import com.feed_the_beast.ftblib.lib.gui.GuiWrapper;
import com.feed_the_beast.ftblib.lib.gui.IOpenableGui;
import com.feed_the_beast.ftblib.lib.gui.Panel;
import com.feed_the_beast.ftblib.lib.gui.Theme;
import com.feed_the_beast.ftblib.lib.gui.Widget;
import com.feed_the_beast.ftblib.lib.gui.WidgetType;
import com.feed_the_beast.ftblib.lib.gui.misc.GuiLoading;
import com.feed_the_beast.ftblib.lib.gui.misc.YesNoCallback;
import com.feed_the_beast.ftblib.lib.util.NetUtils;
import com.feed_the_beast.ftblib.lib.util.misc.MouseButton;
import java.net.URI;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiChat;
import net.minecraft.client.gui.GuiConfirmOpenLink;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiYesNo;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import org.lwjgl.input.Mouse;

public abstract class GuiBase
extends Panel
implements IOpenableGui {
    private int mouseX;
    private int mouseY;
    private boolean refreshWidgets;
    private ScaledResolution screen;
    public boolean fixUnicode;
    private GuiScreen prevScreen;
    public Panel contextMenu = null;

    public GuiBase() {
        super(null);
        this.setSize(176, 166);
        this.setOnlyRenderWidgetsInside(false);
        this.setOnlyInteractWithWidgetsInside(false);
        this.prevScreen = Minecraft.func_71410_x().field_71462_r;
    }

    @Override
    public final GuiBase getGui() {
        return this;
    }

    @Override
    public void alignWidgets() {
    }

    public final void initGui() {
        this.screen = this.parent instanceof GuiBase ? this.parent.getScreen() : new ScaledResolution(Minecraft.func_71410_x());
        if (this.onInit()) {
            super.refreshWidgets();
            this.fixUnicode = this.getScreen().func_78325_e() % 2 == 1;
            this.alignWidgets();
            this.onPostInit();
        }
    }

    public Theme getTheme() {
        return Theme.DEFAULT;
    }

    @Override
    public int getX() {
        return (this.getScreen().func_78326_a() - this.width) / 2;
    }

    @Override
    public int getY() {
        return (this.getScreen().func_78328_b() - this.height) / 2;
    }

    @Override
    public void setScrollX(int scroll) {
    }

    @Override
    public void setScrollY(int scroll) {
    }

    @Override
    public int getScrollX() {
        return 0;
    }

    @Override
    public int getScrollY() {
        return 0;
    }

    public boolean onInit() {
        return true;
    }

    protected boolean setFullscreen() {
        this.setWidth(this.screen.func_78326_a());
        this.setHeight(this.screen.func_78328_b());
        return true;
    }

    public void onPostInit() {
    }

    @Nullable
    public GuiScreen getPrevScreen() {
        if (this.prevScreen instanceof GuiWrapper && ((GuiWrapper)this.prevScreen).getGui() instanceof GuiLoading) {
            return ((GuiWrapper)this.prevScreen).getGui().getPrevScreen();
        }
        if (this.prevScreen instanceof GuiChat) {
            return null;
        }
        return this.prevScreen;
    }

    @Override
    public final void closeGui(boolean openPrevScreen) {
        int mx = Mouse.getX();
        int my = Mouse.getY();
        if (Minecraft.func_71410_x().field_71439_g != null) {
            Minecraft.func_71410_x().field_71439_g.func_71053_j();
            if (Minecraft.func_71410_x().field_71462_r == null) {
                Minecraft.func_71410_x().func_71381_h();
            }
        }
        if (openPrevScreen) {
            Minecraft.func_71410_x().func_147108_a(this.getPrevScreen());
            Mouse.setCursorPosition((int)mx, (int)my);
        }
        this.onClosed();
    }

    public boolean onClosedByKey(int key) {
        return key == 1 || Minecraft.func_71410_x().field_71474_y.field_151445_Q.isActiveAndMatches(key);
    }

    public void onBack() {
        this.closeGui(true);
    }

    public boolean doesGuiPauseGame() {
        return false;
    }

    @Override
    public final void refreshWidgets() {
        this.refreshWidgets = true;
    }

    public final void updateGui(int mx, int my) {
        this.mouseX = mx;
        this.mouseY = my;
        if (this.refreshWidgets) {
            super.refreshWidgets();
            this.refreshWidgets = false;
        }
        this.posX = this.getX();
        this.posY = this.getY();
        this.updateMouseOver(this.mouseX, this.mouseY);
    }

    @Override
    public void updateMouseOver(int mouseX, int mouseY) {
        this.isMouseOver = this.checkMouseOver(mouseX, mouseY);
        this.setOffset(true);
        if (this.contextMenu != null) {
            this.contextMenu.updateMouseOver(mouseX, mouseY);
        } else {
            for (Widget widget : this.widgets) {
                widget.updateMouseOver(mouseX, mouseY);
            }
        }
        this.setOffset(false);
    }

    @Override
    public final void draw(Theme theme, int x, int y, int w, int h) {
        super.draw(theme, x, y, w, h);
    }

    @Override
    public void openContextMenu(@Nullable Panel panel) {
        int px = 0;
        int py = 0;
        if (this.contextMenu != null) {
            px = this.contextMenu.posX;
            py = this.contextMenu.posY;
            this.contextMenu.onClosed();
            this.widgets.remove(this.contextMenu);
        }
        if (panel == null) {
            this.contextMenu = null;
            return;
        }
        int x = this.getX();
        int y = this.getY();
        if (this.contextMenu == null) {
            px = this.getMouseX() - x;
            py = this.getMouseY() - y;
        }
        this.contextMenu = panel;
        this.contextMenu.parent = this;
        this.widgets.add(this.contextMenu);
        this.contextMenu.refreshWidgets();
        px = Math.min(px, this.screen.func_78326_a() - this.contextMenu.width - x) - 3;
        py = Math.min(py, this.screen.func_78328_b() - this.contextMenu.height - y) - 3;
        this.contextMenu.setPos(px, py);
        if (this.contextMenu instanceof GuiBase) {
            ((GuiBase)this.contextMenu).initGui();
        }
    }

    public ContextMenu openContextMenu(List<ContextMenuItem> menu) {
        ContextMenu contextMenu = new ContextMenu(this, menu);
        this.openContextMenu(contextMenu);
        return contextMenu;
    }

    @Override
    public void closeContextMenu() {
        this.openContextMenu((Panel)null);
        this.onInit();
    }

    @Override
    public void onClosed() {
        super.onClosed();
        this.closeContextMenu();
    }

    @Override
    public void drawBackground(Theme theme, int x, int y, int w, int h) {
        theme.drawGui(x, y, w, h, WidgetType.NORMAL);
    }

    public boolean drawDefaultBackground() {
        return true;
    }

    public void drawForeground(Theme theme, int x, int y, int w, int h) {
    }

    @Override
    public boolean mousePressed(MouseButton button) {
        if (button == MouseButton.BACK) {
            this.closeGui(true);
        }
        return super.mousePressed(button);
    }

    @Override
    public boolean keyPressed(int key, char keyChar) {
        if (super.keyPressed(key, keyChar)) {
            return true;
        }
        if (FTBLibConfig.debugging.gui_widget_bounds && key == 48) {
            Theme.renderDebugBoxes = !Theme.renderDebugBoxes;
            return true;
        }
        return false;
    }

    @Override
    public boolean shouldAddMouseOverText() {
        return this.contextMenu == null;
    }

    public GuiScreen getWrapper() {
        return new GuiWrapper(this);
    }

    @Override
    public final void openGui() {
        Minecraft.func_71410_x().func_147108_a(this.getWrapper());
    }

    @Override
    public final ScaledResolution getScreen() {
        if (this.screen == null) {
            return this.parent.getScreen();
        }
        return this.screen;
    }

    @Override
    public final int getMouseX() {
        return this.mouseX;
    }

    @Override
    public final int getMouseY() {
        return this.mouseY;
    }

    public boolean isMouseOver(int x, int y, int w, int h) {
        return this.getMouseX() >= x && this.getMouseY() >= y && this.getMouseX() < x + w && this.getMouseY() < y + h;
    }

    public boolean isMouseOver(Widget widget) {
        if (widget == this) {
            return this.isMouseOver(this.getX(), this.getY(), this.width, this.height);
        }
        if (this.isMouseOver(widget.getX(), widget.getY(), widget.width, widget.height)) {
            boolean offset = widget.parent.isOffset();
            widget.parent.setOffset(false);
            boolean b = this.isMouseOver(widget.parent);
            widget.parent.setOffset(offset);
            return b;
        }
        return false;
    }

    @Override
    public boolean handleClick(String scheme, String path) {
        switch (scheme) {
            case "http": 
            case "https": {
                try {
                    URI uri = new URI(scheme + ':' + path);
                    if (Minecraft.func_71410_x().field_71474_y.field_74358_q) {
                        GuiScreen currentScreen = Minecraft.func_71410_x().field_71462_r;
                        Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiConfirmOpenLink((result, id) -> {
                            if (result) {
                                try {
                                    NetUtils.openURI(uri);
                                }
                                catch (Exception ex) {
                                    ex.printStackTrace();
                                }
                            }
                            Minecraft.func_71410_x().func_147108_a(currentScreen);
                        }, scheme + ':' + path, 0, false));
                    } else {
                        NetUtils.openURI(uri);
                    }
                    return true;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    return false;
                }
            }
            case "file": {
                try {
                    NetUtils.openURI(new URI("file:" + path));
                    return true;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    return false;
                }
            }
            case "command": {
                ClientUtils.execClientCommand(path, false);
                return true;
            }
            case "curseforgepages": {
                String[] s = path.split(":", 2);
                if (s.length == 2) {
                    return this.handleClick("https://minecraft.curseforge.com/projects/" + s[0] + "/pages/" + s[1]);
                }
                return false;
            }
            case "custom": {
                return new CustomClickEvent(new ResourceLocation(path)).post();
            }
        }
        return false;
    }

    public void openYesNoFull(String title, String desc, YesNoCallback callback) {
        Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiYesNo((result, id) -> {
            this.openGui();
            callback.onButtonClicked(result);
            this.refreshWidgets();
        }, title, desc, 0));
    }

    public final void openYesNo(String title, String desc, Runnable callback) {
        this.openYesNoFull(title, desc, result -> {
            if (result) {
                callback.run();
            }
        });
    }

    public static class PositionedTextData {
        public final int posX;
        public final int posY;
        public final int width;
        public final int height;
        public final ClickEvent clickEvent;
        public final HoverEvent hoverEvent;
        public final String insertion;

        public PositionedTextData(int x, int y, int w, int h, Style s) {
            this.posX = x;
            this.posY = y;
            this.width = w;
            this.height = h;
            this.clickEvent = s.func_150235_h();
            this.hoverEvent = s.func_150210_i();
            this.insertion = s.func_179986_j();
        }
    }
}

