/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.lib.icon;

import com.feed_the_beast.ftblib.lib.icon.AtlasSpriteIcon;
import com.feed_the_beast.ftblib.lib.icon.BulletIcon;
import com.feed_the_beast.ftblib.lib.icon.Color4I;
import com.feed_the_beast.ftblib.lib.icon.CombinedIcon;
import com.feed_the_beast.ftblib.lib.icon.IconAnimation;
import com.feed_the_beast.ftblib.lib.icon.IconPresets;
import com.feed_the_beast.ftblib.lib.icon.IconWithBorder;
import com.feed_the_beast.ftblib.lib.icon.IconWithOutline;
import com.feed_the_beast.ftblib.lib.icon.IconWithTint;
import com.feed_the_beast.ftblib.lib.icon.ImageIcon;
import com.feed_the_beast.ftblib.lib.icon.ItemIcon;
import com.feed_the_beast.ftblib.lib.icon.MutableColor4I;
import com.feed_the_beast.ftblib.lib.icon.PlayerHeadIcon;
import com.feed_the_beast.ftblib.lib.icon.URLImageIcon;
import com.feed_the_beast.ftblib.lib.util.JsonUtils;
import com.feed_the_beast.ftblib.lib.util.StringUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.net.URI;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class Icon {
    public static final Color4I EMPTY = new Color4I(255, 255, 255, 255){

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void draw(int x, int y, int w, int h, Color4I col) {
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void draw3D(Color4I col) {
        }

        @Override
        public MutableColor4I mutable() {
            return new MutableColor4I.None();
        }
    };

    public static Icon getIcon(@Nullable JsonElement json) {
        if (JsonUtils.isNull(json)) {
            return EMPTY;
        }
        if (json.isJsonObject()) {
            JsonObject o = json.getAsJsonObject();
            if (o.has("id")) {
                switch (o.get("id").getAsString()) {
                    case "color": {
                        Color4I color = Color4I.fromJson(o.get("color"));
                        return o.has("mutable") && o.get("mutable").getAsBoolean() ? color.mutable() : color;
                    }
                    case "border": {
                        return Icon.getIcon(o.get("parent")).withBorder(o.has("border") ? o.get("border").getAsInt() : 0);
                    }
                    case "tint": {
                        return Icon.getIcon(o.get("parent")).withTint(Color4I.fromJson(o.get("color")));
                    }
                    case "animation": {
                        ArrayList<Icon> icons = new ArrayList<Icon>();
                        for (JsonElement e : o.get("icons").getAsJsonArray()) {
                            icons.add(Icon.getIcon(e));
                        }
                        return IconAnimation.fromList(icons, true);
                    }
                    case "outline": {
                        Icon icon = EMPTY;
                        Color4I outline = EMPTY;
                        boolean roundEdges = false;
                        if (o.has("icon")) {
                            icon = Icon.getIcon(o.get("icon"));
                        }
                        if (o.has("color")) {
                            outline = Color4I.fromJson(o.get("color"));
                        }
                        if (o.has("round_edges")) {
                            roundEdges = o.get("round_edges").getAsBoolean();
                        }
                        return icon.withOutline(outline, roundEdges);
                    }
                    case "bullet": {
                        return new BulletIcon().setColor(o.has("color") ? Color4I.fromJson(o.get("color")) : EMPTY);
                    }
                }
            }
        } else if (json.isJsonArray()) {
            ArrayList<Icon> list = new ArrayList<Icon>();
            for (JsonElement e : json.getAsJsonArray()) {
                list.add(Icon.getIcon(e));
            }
            return CombinedIcon.getCombined(list);
        }
        String s = json.getAsString();
        if (s.isEmpty()) {
            return EMPTY;
        }
        Icon icon = IconPresets.MAP.get(s);
        return icon == null ? Icon.getIcon(s) : icon;
    }

    public static Icon getIcon(String id) {
        if (id.isEmpty()) {
            return EMPTY;
        }
        if (id.charAt(0) == '#') {
            return Color4I.fromJson((JsonElement)new JsonPrimitive(id));
        }
        String[] ida = id.split(":", 2);
        if (ida.length == 2) {
            switch (ida[0]) {
                case "item": {
                    return ItemIcon.getItemIcon(ida[1]);
                }
                case "http": 
                case "https": 
                case "file": {
                    try {
                        return new URLImageIcon(new URI(id));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                case "player": {
                    return new PlayerHeadIcon(StringUtils.fromString(ida[1]));
                }
            }
        }
        return id.endsWith(".png") || id.endsWith(".jpg") ? new ImageIcon(new ResourceLocation(id)) : new AtlasSpriteIcon(id);
    }

    public boolean isEmpty() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void bindTexture() {
    }

    public Icon copy() {
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public abstract void draw(int var1, int var2, int var3, int var4, Color4I var5);

    @SideOnly(value=Side.CLIENT)
    public final void draw(int x, int y, int w, int h) {
        this.draw(x, y, w, h, EMPTY);
    }

    @SideOnly(value=Side.CLIENT)
    public void draw3D(Color4I col) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179139_a((double)0.0625, (double)0.0625, (double)1.0);
        this.draw(-8, -8, 16, 16, col);
        GlStateManager.func_179121_F();
    }

    public JsonElement getJson() {
        return new JsonPrimitive(this.toString());
    }

    public final Icon combineWith(Icon icon) {
        if (icon.isEmpty()) {
            return this;
        }
        if (this.isEmpty()) {
            return icon;
        }
        return new CombinedIcon(this, icon);
    }

    public final Icon combineWith(Icon ... icons) {
        if (icons.length == 0) {
            return this;
        }
        if (icons.length == 1) {
            if (this.isEmpty()) {
                return icons[0];
            }
            if (icons[0].isEmpty()) {
                return this;
            }
            return new CombinedIcon(this, icons[0]);
        }
        ArrayList<Icon> list = new ArrayList<Icon>(icons.length + 1);
        list.add(this);
        for (Icon i : icons) {
            list.add(i);
        }
        return CombinedIcon.getCombined(list);
    }

    public final Icon withOutline(Color4I color, boolean roundEdges) {
        if (color.isEmpty()) {
            return this.withBorder(1);
        }
        return new IconWithOutline(this, color, roundEdges);
    }

    public final Icon withBorder(int border) {
        return border == 0 ? this : new IconWithBorder(this, border);
    }

    public Icon withTint(Color4I color) {
        return this.isEmpty() || color == Color4I.WHITE ? this : new IconWithTint(this, color);
    }

    public int hashCode() {
        return this.getJson().hashCode();
    }

    public boolean equals(Object o) {
        return o == this || o instanceof Icon && this.getJson().equals(((Icon)o).getJson());
    }
}

