/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.lib.icon;

import com.feed_the_beast.ftblib.FTBLib;
import com.feed_the_beast.ftblib.FTBLibConfig;
import com.feed_the_beast.ftblib.lib.gui.GuiHelper;
import com.feed_the_beast.ftblib.lib.icon.Color4I;
import com.feed_the_beast.ftblib.lib.icon.Icon;
import com.feed_the_beast.ftblib.lib.item.ItemStackSerializer;
import com.feed_the_beast.ftblib.lib.util.InvUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemIcon
extends Icon {
    ItemStack stack;

    public static Icon getItemIcon(ItemStack stack) {
        return stack.func_190926_b() ? EMPTY : new ItemIcon(stack);
    }

    public static Icon getItemIcon(String lazyStackString) {
        return lazyStackString.isEmpty() ? EMPTY : new LazyItemIcon(lazyStackString);
    }

    private ItemIcon(ItemStack is) {
        this.stack = is;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void draw(int x, int y, int w, int h, Color4I col) {
        if (!GuiHelper.drawItem(this.getStack(), x, y, (double)w / 16.0, (double)h / 16.0, true)) {
            this.stack = InvUtils.ERROR_ITEM;
        } else {
            GuiHelper.setupDrawing();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawItem3D(ItemStack stack) {
        Minecraft mc = Minecraft.func_71410_x();
        mc.func_110434_K().func_110577_a(TextureMap.field_110575_b);
        mc.func_110434_K().func_110581_b(TextureMap.field_110575_b).func_174936_b(false, false);
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)-0.02f);
        IBakedModel bakedmodel = mc.func_175599_af().func_184393_a(stack, (World)mc.field_71441_e, (EntityLivingBase)mc.field_71439_g);
        bakedmodel = ForgeHooksClient.handleCameraTransforms((IBakedModel)bakedmodel, (ItemCameraTransforms.TransformType)ItemCameraTransforms.TransformType.GUI, (boolean)false);
        mc.func_175599_af().func_180454_a(stack, bakedmodel);
        GlStateManager.func_179121_F();
        mc.func_110434_K().func_110577_a(TextureMap.field_110575_b);
        mc.func_110434_K().func_110581_b(TextureMap.field_110575_b).func_174935_a();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void draw3D(Color4I col) {
        ItemIcon.drawItem3D(this.getStack());
    }

    public String toString() {
        return "item:" + ItemStackSerializer.toString(this.getStack());
    }

    @Override
    public boolean equals(Object o) {
        return o == this || o instanceof ItemIcon && ItemStack.areItemStacksEqualUsingNBTShareTag((ItemStack)this.getStack(), (ItemStack)((ItemIcon)o).getStack());
    }

    private static class LazyItemIcon
    extends ItemIcon {
        private String lazyStackString;
        private boolean createdStack;

        private LazyItemIcon(String s) {
            super(ItemStack.field_190927_a);
            this.lazyStackString = s;
        }

        @Override
        public ItemStack getStack() {
            if (!this.createdStack) {
                this.stack = ItemStackSerializer.parseItem(this.lazyStackString);
                this.createdStack = true;
                if (FTBLibConfig.debugging.print_more_errors && this.stack.func_190926_b()) {
                    FTBLib.LOGGER.warn("Couldn't parse item '" + this.lazyStackString + "'!");
                }
            }
            return this.stack;
        }

        @Override
        public String toString() {
            return "item:" + this.lazyStackString;
        }
    }
}

