/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.java;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassKind;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.load.java.AnnotationTypeQualifierResolverKt;
import kotlin.reflect.jvm.internal.impl.load.java.JvmAnnotationNames;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.NullabilityQualifierWithApplicability;
import kotlin.reflect.jvm.internal.impl.load.java.typeEnhancement.NullabilityQualifierWithMigrationStatus;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ArrayValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ConstantValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.EnumValue;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlin.reflect.jvm.internal.impl.storage.MemoizedFunctionToNullable;
import kotlin.reflect.jvm.internal.impl.storage.StorageManager;
import kotlin.reflect.jvm.internal.impl.utils.Jsr305State;
import kotlin.reflect.jvm.internal.impl.utils.ReportLevel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AnnotationTypeQualifierResolver {
    private final MemoizedFunctionToNullable<ClassDescriptor, AnnotationDescriptor> resolvedNicknames;
    private final boolean disabled;
    private final Jsr305State jsr305State;

    /*
     * WARNING - void declaration
     */
    private final AnnotationDescriptor computeTypeQualifierNickname(ClassDescriptor classDescriptor) {
        AnnotationDescriptor annotationDescriptor;
        block2: {
            void $receiver$iv;
            if (!classDescriptor.getAnnotations().hasAnnotation(AnnotationTypeQualifierResolverKt.access$getTYPE_QUALIFIER_NICKNAME_FQNAME$p())) {
                return null;
            }
            Iterable iterable = classDescriptor.getAnnotations();
            AnnotationTypeQualifierResolver annotationTypeQualifierResolver = this;
            for (Object element$iv : $receiver$iv) {
                AnnotationDescriptor p1 = (AnnotationDescriptor)element$iv;
                AnnotationDescriptor result$iv = annotationTypeQualifierResolver.resolveTypeQualifierAnnotation(p1);
                if (result$iv == null) continue;
                annotationDescriptor = result$iv;
                break block2;
            }
            annotationDescriptor = null;
        }
        return annotationDescriptor;
    }

    private final AnnotationDescriptor resolveTypeQualifierNickname(ClassDescriptor classDescriptor) {
        if (classDescriptor.getKind() != ClassKind.ANNOTATION_CLASS) {
            return null;
        }
        return (AnnotationDescriptor)this.resolvedNicknames.invoke(classDescriptor);
    }

    @Nullable
    public final AnnotationDescriptor resolveTypeQualifierAnnotation(@NotNull AnnotationDescriptor annotationDescriptor) {
        Intrinsics.checkParameterIsNotNull(annotationDescriptor, "annotationDescriptor");
        if (this.jsr305State.getDisabled()) {
            return null;
        }
        ClassDescriptor classDescriptor = DescriptorUtilsKt.getAnnotationClass(annotationDescriptor);
        if (classDescriptor == null) {
            return null;
        }
        ClassDescriptor annotationClass = classDescriptor;
        if (AnnotationTypeQualifierResolverKt.access$isAnnotatedWithTypeQualifier$p(annotationClass)) {
            return annotationDescriptor;
        }
        return this.resolveTypeQualifierNickname(annotationClass);
    }

    @Nullable
    public final NullabilityQualifierWithApplicability resolveQualifierBuiltInDefaultAnnotation(@NotNull AnnotationDescriptor annotationDescriptor) {
        Intrinsics.checkParameterIsNotNull(annotationDescriptor, "annotationDescriptor");
        if (this.jsr305State.getDisabled()) {
            return null;
        }
        Object object = AnnotationTypeQualifierResolverKt.access$getBUILT_IN_TYPE_QUALIFIER_DEFAULT_ANNOTATIONS$p();
        FqName fqName2 = annotationDescriptor.getFqName();
        NullabilityQualifierWithApplicability nullabilityQualifierWithApplicability = (NullabilityQualifierWithApplicability)object.get(fqName2);
        if (nullabilityQualifierWithApplicability != null) {
            Object $qualifier_applicability = object = nullabilityQualifierWithApplicability;
            NullabilityQualifierWithMigrationStatus qualifier = ((NullabilityQualifierWithApplicability)$qualifier_applicability).component1();
            Collection<QualifierApplicabilityType> applicability = ((NullabilityQualifierWithApplicability)$qualifier_applicability).component2();
            ReportLevel reportLevel = this.resolveJsr305AnnotationState(annotationDescriptor);
            ReportLevel it = reportLevel;
            ReportLevel reportLevel2 = it != ReportLevel.IGNORE ? reportLevel : null;
            if (reportLevel2 == null) {
                return null;
            }
            ReportLevel state = reportLevel2;
            return new NullabilityQualifierWithApplicability(NullabilityQualifierWithMigrationStatus.copy$default(qualifier, null, state.isWarning(), 1, null), applicability);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final TypeQualifierWithApplicability resolveTypeQualifierDefaultAnnotation(@NotNull AnnotationDescriptor annotationDescriptor) {
        Object v3;
        int elementTypesMask;
        block8: {
            int initial$iv;
            Object element$iv$iv;
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            ClassDescriptor classDescriptor;
            Object it;
            Intrinsics.checkParameterIsNotNull(annotationDescriptor, "annotationDescriptor");
            if (this.jsr305State.getDisabled()) {
                return null;
            }
            ClassDescriptor classDescriptor2 = DescriptorUtilsKt.getAnnotationClass(annotationDescriptor);
            if (classDescriptor2 == null || (classDescriptor2 = (it = (classDescriptor = classDescriptor2)).getAnnotations().hasAnnotation(AnnotationTypeQualifierResolverKt.access$getTYPE_QUALIFIER_DEFAULT_FQNAME$p()) ? classDescriptor : null) == null) {
                return null;
            }
            ClassDescriptor typeQualifierDefaultAnnotatedClass = classDescriptor2;
            ClassDescriptor classDescriptor3 = DescriptorUtilsKt.getAnnotationClass(annotationDescriptor);
            if (classDescriptor3 == null) {
                Intrinsics.throwNpe();
            }
            AnnotationDescriptor annotationDescriptor2 = classDescriptor3.getAnnotations().findAnnotation(AnnotationTypeQualifierResolverKt.access$getTYPE_QUALIFIER_DEFAULT_FQNAME$p());
            if (annotationDescriptor2 == null) {
                Intrinsics.throwNpe();
            }
            it = annotationDescriptor2.getAllValueArguments();
            void $i$a$1$takeIf = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            void var7_12 = $receiver$iv$iv;
            Iterator iterator2 = var7_12.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry $parameter_argument;
                Map.Entry entry = $parameter_argument = (element$iv$iv = iterator2.next());
                Name parameter = (Name)entry.getKey();
                entry = $parameter_argument;
                ConstantValue argument = (ConstantValue)entry.getValue();
                Iterable list$iv$iv = Intrinsics.areEqual(parameter, JvmAnnotationNames.DEFAULT_ANNOTATION_MEMBER_NAME) ? this.mapConstantToQualifierApplicabilityTypes(argument) : CollectionsKt.emptyList();
                CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            int accumulator$iv = initial$iv = 0;
            for (Object element$iv : $receiver$iv) {
                void applicabilityType;
                element$iv$iv = (QualifierApplicabilityType)((Object)element$iv);
                int acc = accumulator$iv;
                accumulator$iv = acc | 1 << applicabilityType.ordinal();
            }
            elementTypesMask = accumulator$iv;
            Iterable $receiver$iv2 = typeQualifierDefaultAnnotatedClass.getAnnotations();
            for (Object element$iv : $receiver$iv2) {
                AnnotationDescriptor it2 = (AnnotationDescriptor)element$iv;
                if (!(this.resolveTypeQualifierAnnotation(it2) != null)) continue;
                v3 = element$iv;
                break block8;
            }
            v3 = null;
        }
        AnnotationDescriptor annotationDescriptor3 = v3;
        if (annotationDescriptor3 == null) {
            return null;
        }
        AnnotationDescriptor typeQualifier = annotationDescriptor3;
        return new TypeQualifierWithApplicability(typeQualifier, elementTypesMask);
    }

    @NotNull
    public final ReportLevel resolveJsr305AnnotationState(@NotNull AnnotationDescriptor annotationDescriptor) {
        Intrinsics.checkParameterIsNotNull(annotationDescriptor, "annotationDescriptor");
        ReportLevel reportLevel = this.resolveJsr305CustomState(annotationDescriptor);
        if (reportLevel != null) {
            ReportLevel reportLevel2;
            ReportLevel it = reportLevel2 = reportLevel;
            return it;
        }
        return this.jsr305State.getGlobal();
    }

    @Nullable
    public final ReportLevel resolveJsr305CustomState(@NotNull AnnotationDescriptor annotationDescriptor) {
        Intrinsics.checkParameterIsNotNull(annotationDescriptor, "annotationDescriptor");
        Object object = this.jsr305State.getUser();
        FqName fqName2 = annotationDescriptor.getFqName();
        String string = fqName2 != null ? fqName2.asString() : null;
        ReportLevel reportLevel = object.get(string);
        if (reportLevel != null) {
            Object it = object = reportLevel;
            return it;
        }
        ClassDescriptor classDescriptor = DescriptorUtilsKt.getAnnotationClass(annotationDescriptor);
        return classDescriptor != null ? this.migrationAnnotationStatus(classDescriptor) : null;
    }

    private final ReportLevel migrationAnnotationStatus(@NotNull ClassDescriptor $receiver) {
        ReportLevel reportLevel;
        AnnotationDescriptor annotationDescriptor = $receiver.getAnnotations().findAnnotation(AnnotationTypeQualifierResolverKt.access$getMIGRATION_ANNOTATION_FQNAME$p());
        ConstantValue<Object> constantValue = annotationDescriptor != null ? DescriptorUtilsKt.firstArgument(annotationDescriptor) : null;
        if (!(constantValue instanceof EnumValue)) {
            constantValue = null;
        }
        EnumValue enumValue = (EnumValue)constantValue;
        if (enumValue == null) {
            return null;
        }
        EnumValue enumValue2 = enumValue;
        ReportLevel reportLevel2 = this.jsr305State.getMigration();
        if (reportLevel2 != null) {
            ReportLevel reportLevel3;
            ReportLevel it = reportLevel3 = reportLevel2;
            return it;
        }
        switch (enumValue2.getEnumEntryName().asString()) {
            case "STRICT": {
                reportLevel = ReportLevel.STRICT;
                break;
            }
            case "WARN": {
                reportLevel = ReportLevel.WARN;
                break;
            }
            case "IGNORE": {
                reportLevel = ReportLevel.IGNORE;
                break;
            }
            default: {
                reportLevel = null;
            }
        }
        return reportLevel;
    }

    /*
     * WARNING - void declaration
     */
    private final List<QualifierApplicabilityType> mapConstantToQualifierApplicabilityTypes(@NotNull ConstantValue<?> $receiver) {
        List list;
        ConstantValue<?> constantValue = $receiver;
        if (constantValue instanceof ArrayValue) {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Iterable iterable = $receiver$iv = (Iterable)((ArrayValue)$receiver).getValue();
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                ConstantValue it = (ConstantValue)element$iv$iv;
                Iterable list$iv$iv = this.mapConstantToQualifierApplicabilityTypes(it);
                CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else if (constantValue instanceof EnumValue) {
            QualifierApplicabilityType qualifierApplicabilityType;
            switch (((EnumValue)$receiver).getEnumEntryName().getIdentifier()) {
                case "METHOD": {
                    qualifierApplicabilityType = QualifierApplicabilityType.METHOD_RETURN_TYPE;
                    break;
                }
                case "FIELD": {
                    qualifierApplicabilityType = QualifierApplicabilityType.FIELD;
                    break;
                }
                case "PARAMETER": {
                    qualifierApplicabilityType = QualifierApplicabilityType.VALUE_PARAMETER;
                    break;
                }
                case "TYPE_USE": {
                    qualifierApplicabilityType = QualifierApplicabilityType.TYPE_USE;
                    break;
                }
                default: {
                    qualifierApplicabilityType = null;
                }
            }
            list = CollectionsKt.listOfNotNull(qualifierApplicabilityType);
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    public final boolean getDisabled() {
        return this.disabled;
    }

    public AnnotationTypeQualifierResolver(@NotNull StorageManager storageManager, @NotNull Jsr305State jsr305State) {
        Intrinsics.checkParameterIsNotNull(storageManager, "storageManager");
        Intrinsics.checkParameterIsNotNull(jsr305State, "jsr305State");
        this.jsr305State = jsr305State;
        this.resolvedNicknames = storageManager.createMemoizedFunctionWithNullableValues((Function1)new Function1<ClassDescriptor, AnnotationDescriptor>(this){

            @Nullable
            public final AnnotationDescriptor invoke(@NotNull ClassDescriptor p1) {
                Intrinsics.checkParameterIsNotNull(p1, "p1");
                return AnnotationTypeQualifierResolver.access$computeTypeQualifierNickname((AnnotationTypeQualifierResolver)this.receiver, p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(AnnotationTypeQualifierResolver.class);
            }

            public final String getName() {
                return "computeTypeQualifierNickname";
            }

            public final String getSignature() {
                return "computeTypeQualifierNickname(Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;)Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;";
            }
        });
        this.disabled = this.jsr305State.getDisabled();
    }

    @Nullable
    public static final /* synthetic */ AnnotationDescriptor access$computeTypeQualifierNickname(AnnotationTypeQualifierResolver $this, @NotNull ClassDescriptor classDescriptor) {
        return $this.computeTypeQualifierNickname(classDescriptor);
    }

    public static final class QualifierApplicabilityType
    extends Enum<QualifierApplicabilityType> {
        public static final /* enum */ QualifierApplicabilityType METHOD_RETURN_TYPE;
        public static final /* enum */ QualifierApplicabilityType VALUE_PARAMETER;
        public static final /* enum */ QualifierApplicabilityType FIELD;
        public static final /* enum */ QualifierApplicabilityType TYPE_USE;
        private static final /* synthetic */ QualifierApplicabilityType[] $VALUES;

        static {
            QualifierApplicabilityType[] qualifierApplicabilityTypeArray = new QualifierApplicabilityType[4];
            QualifierApplicabilityType[] qualifierApplicabilityTypeArray2 = qualifierApplicabilityTypeArray;
            qualifierApplicabilityTypeArray[0] = METHOD_RETURN_TYPE = new QualifierApplicabilityType();
            qualifierApplicabilityTypeArray[1] = VALUE_PARAMETER = new QualifierApplicabilityType();
            qualifierApplicabilityTypeArray[2] = FIELD = new QualifierApplicabilityType();
            qualifierApplicabilityTypeArray[3] = TYPE_USE = new QualifierApplicabilityType();
            $VALUES = qualifierApplicabilityTypeArray;
        }

        public static QualifierApplicabilityType[] values() {
            return (QualifierApplicabilityType[])$VALUES.clone();
        }

        public static QualifierApplicabilityType valueOf(String string) {
            return Enum.valueOf(QualifierApplicabilityType.class, string);
        }
    }

    public static final class TypeQualifierWithApplicability {
        private final AnnotationDescriptor typeQualifier;
        private final int applicability;

        @NotNull
        public final AnnotationDescriptor component1() {
            return this.typeQualifier;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<QualifierApplicabilityType> component2() {
            void $receiver$iv$iv;
            void $receiver$iv;
            QualifierApplicabilityType[] qualifierApplicabilityTypeArray = QualifierApplicabilityType.values();
            TypeQualifierWithApplicability typeQualifierWithApplicability = this;
            void var3_3 = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            for (void element$iv$iv : $receiver$iv$iv) {
                void p1 = element$iv$iv;
                if (!typeQualifierWithApplicability.isApplicableTo((QualifierApplicabilityType)p1)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        private final boolean isApplicableTo(QualifierApplicabilityType elementType) {
            return this.isApplicableConsideringMask(QualifierApplicabilityType.TYPE_USE) || this.isApplicableConsideringMask(elementType);
        }

        private final boolean isApplicableConsideringMask(QualifierApplicabilityType elementType) {
            return (this.applicability & 1 << elementType.ordinal()) != 0;
        }

        public TypeQualifierWithApplicability(@NotNull AnnotationDescriptor typeQualifier, int applicability) {
            Intrinsics.checkParameterIsNotNull(typeQualifier, "typeQualifier");
            this.typeQualifier = typeQualifier;
            this.applicability = applicability;
        }
    }
}

