/*
 * Decompiled with CFR 0.152.
 */
package ru.fewizz.neid.asm;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.launchwrapper.IClassTransformer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;
import ru.fewizz.neid.asm.Name;
import ru.fewizz.neid.asm.TransformerGroup;
import ru.fewizz.neid.asm.group.block.TransformerGroupAnvilChunkLoader;
import ru.fewizz.neid.asm.group.block.TransformerGroupBlockHardcoredConstants;
import ru.fewizz.neid.asm.group.block.TransformerGroupChunkPrimer;
import ru.fewizz.neid.asm.group.block.TransformerGroupWorldEdit;
import ru.fewizz.neid.asm.group.item.TransformerGroupItemHardcoredConstants;
import ru.fewizz.neid.asm.group.item.TransformerGroupPacketBuffer;

public class Transformer
implements IClassTransformer {
    public static final Logger LOGGER = LogManager.getLogger((String)"neid");
    public static boolean envDeobfuscated;
    private ClassNode cn;
    private ClassReader cr;
    private ClassWriter cw;
    private List<TransformerGroup> transformerGroups = new ArrayList<TransformerGroup>();

    public Transformer() {
        this.addTransformerGroup(new TransformerGroupBlockHardcoredConstants());
        this.addTransformerGroup(new TransformerGroupAnvilChunkLoader());
        this.addTransformerGroup(new TransformerGroupChunkPrimer());
        this.addTransformerGroup(new TransformerGroupWorldEdit());
        this.addTransformerGroup(new TransformerGroupItemHardcoredConstants());
        this.addTransformerGroup(new TransformerGroupPacketBuffer());
    }

    private void addTransformerGroup(TransformerGroup group) {
        this.transformerGroups.add(group);
    }

    public byte[] transform(String name, String deobfName, byte[] bytes) {
        boolean transformed = false;
        Iterator<TransformerGroup> it = this.transformerGroups.iterator();
        block0: while (it.hasNext()) {
            TransformerGroup tg = it.next();
            for (Name clazz : tg.getRequiredClasses()) {
                if (!clazz.deobfDotted.equals(deobfName)) continue;
                if (!transformed) {
                    transformed = true;
                    this.start(bytes, deobfName, tg);
                }
                LOGGER.info("Patching class: \"" + deobfName + "\" with Transformer Group: \"" + tg.getClass().getSimpleName() + "\"");
                tg.startTransform(this.cn, clazz);
                if (!tg.isPatchedAllClasses()) continue;
                it.remove();
                continue block0;
            }
        }
        if (transformed) {
            this.end();
            return this.cw.toByteArray();
        }
        return bytes;
    }

    void start(byte[] bytes, String name, TransformerGroup tg) {
        this.cn = new ClassNode(327680);
        this.cr = new ClassReader(bytes);
        this.cr.accept((ClassVisitor)this.cn, 0);
    }

    void end() {
        this.cw = new ClassWriter(0);
        this.cn.accept((ClassVisitor)this.cw);
    }
}

