/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalfoundation.network;

import cofh.core.network.PacketBase;
import cofh.core.network.PacketCoFHBase;
import cofh.core.network.PacketHandler;
import cofh.thermalfoundation.ThermalFoundation;
import cofh.thermalfoundation.gui.container.ContainerLexiconStudy;
import cofh.thermalfoundation.gui.container.ContainerLexiconTransmute;
import net.minecraft.entity.player.EntityPlayer;

public class PacketTFBase
extends PacketCoFHBase {
    public static void initialize() {
        PacketHandler.instance.registerPacket(PacketTFBase.class);
    }

    public void handlePacket(EntityPlayer entityPlayer, boolean bl) {
        try {
            byte by = this.getByte();
            switch (PacketTypes.values()[by]) {
                case LEXICON_STUDY: {
                    if (entityPlayer.field_71070_bA instanceof ContainerLexiconStudy) {
                        ((ContainerLexiconStudy)entityPlayer.field_71070_bA).handlePacket(this);
                    }
                    return;
                }
                case LEXICON_TRANSMUTE: {
                    if (entityPlayer.field_71070_bA instanceof ContainerLexiconTransmute) {
                        ((ContainerLexiconTransmute)entityPlayer.field_71070_bA).handlePacket(this);
                    }
                    return;
                }
            }
            ThermalFoundation.log.error("Unknown Packet! Internal: TFPH, ID: " + by);
        }
        catch (Exception exception) {
            ThermalFoundation.log.error("Packet payload failure! Please check your config files!");
            exception.printStackTrace();
        }
    }

    public static PacketCoFHBase getPacket(PacketTypes packetTypes) {
        return new PacketTFBase().addByte(packetTypes.ordinal());
    }

    public static void sendLexiconStudyPacketToServer(int n) {
        PacketHandler.sendToServer((PacketBase)PacketTFBase.getPacket(PacketTypes.LEXICON_STUDY).addByte(n));
    }

    public static void sendLexiconStudySelectPacketToServer(int n, String string) {
        PacketHandler.sendToServer((PacketBase)PacketTFBase.getPacket(PacketTypes.LEXICON_STUDY).addByte(n).addString(string));
    }

    public static void sendLexiconTransmutePacketToServer(int n) {
        PacketHandler.sendToServer((PacketBase)PacketTFBase.getPacket(PacketTypes.LEXICON_TRANSMUTE).addByte(n));
    }

    public static enum PacketTypes {
        LEXICON_STUDY,
        LEXICON_TRANSMUTE,
        CONFIG_SYNC;

    }
}

