/*
 * Decompiled with CFR 0.152.
 */
package ichun.client.core;

import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ichun.client.core.TickHandlerClient;
import ichun.client.gui.GuiModUpdateNotification;
import ichun.client.keybind.KeyBind;
import ichun.client.thread.ThreadGetPatrons;
import ichun.client.voxel.EntityTrail;
import ichun.client.voxel.RenderVoxels;
import ichun.client.voxel.TrailTicker;
import ichun.common.core.CommonProxy;
import ichun.common.core.config.Config;
import ichun.common.core.util.ResourceHelper;
import java.io.File;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.settings.KeyBinding;
import net.minecraftforge.common.config.Configuration;

public class ClientProxy
extends CommonProxy {
    @Override
    public void init() {
        super.init();
        ResourceHelper.init();
        File file = new File(ResourceHelper.getConfigFolder(), "iChunUtil_KeyBinds.cfg");
        Config.configKeybind = new Configuration(file);
        Config.configKeybind.load();
        tickHandlerClient = new TickHandlerClient();
        FMLCommonHandler.instance().bus().register((Object)tickHandlerClient);
        trailTicker = new TrailTicker();
        FMLCommonHandler.instance().bus().register((Object)trailTicker);
        RenderingRegistry.registerEntityRenderingHandler(EntityTrail.class, (Render)new RenderVoxels());
        new ThreadGetPatrons().start();
    }

    @Override
    public void postInit() {
        super.postInit();
    }

    @Override
    public GameProfileRepository createProfileRepo() {
        return new YggdrasilAuthenticationService(Minecraft.func_71410_x().func_110437_J(), UUID.randomUUID().toString()).createProfileRepository();
    }

    @Override
    public MinecraftSessionService getSessionService() {
        return Minecraft.func_71410_x().func_152347_ac();
    }

    @Override
    public void notifyNewUpdate(String modName, String version) {
        versionChecker.put(modName, version);
        if (ClientProxy.tickHandlerClient.modUpdateNotification == null) {
            ClientProxy.tickHandlerClient.modUpdateNotification = new GuiModUpdateNotification(Minecraft.func_71410_x());
        }
        ClientProxy.tickHandlerClient.modUpdateNotification.addModUpdate(modName, version);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public KeyBind registerKeyBind(KeyBind bind, KeyBind replacing) {
        if (replacing != null) {
            if (bind.equals(replacing)) {
                return replacing;
            }
            for (int i = ClientProxy.tickHandlerClient.keyBindList.size() - 1; i >= 0; --i) {
                KeyBind keybind = ClientProxy.tickHandlerClient.keyBindList.get(i);
                if (!keybind.equals(replacing)) continue;
                --keybind.usages;
                if (keybind.usages <= 0) {
                    ClientProxy.tickHandlerClient.keyBindList.remove(i);
                }
                bind.setPulse(keybind.canPulse, keybind.pulseTime);
                bind.ignoreHold = keybind.ignoreHold;
            }
        }
        for (KeyBind keybind : ClientProxy.tickHandlerClient.keyBindList) {
            if (!keybind.equals(bind)) continue;
            ++keybind.usages;
            return keybind;
        }
        ++bind.usages;
        ClientProxy.tickHandlerClient.keyBindList.add(bind);
        return bind;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerMinecraftKeyBind(KeyBinding bind) {
        ClientProxy.tickHandlerClient.mcKeyBindList.put(bind, new KeyBind(bind.func_151463_i(), false, false, false, true).setIsMinecraftBind());
    }
}

