/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.common.multiblock.helpers;

import erogenousbeef.bigreactors.common.multiblock.interfaces.IConditionalUpdater;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;

public abstract class FluidHelper
implements IConditionalUpdater {
    private FluidStack[] fluids;
    private int capacity;
    private int ticksSinceLastUpdate;
    private static final int minimumTicksBetweenUpdates = 60;
    private static final int minimumDevianceForUpdate = 50;
    int[] fluidLevelAtLastUpdate;
    private static final int FORCE_UPDATE = -1000;
    private int numberOfFluids = this.getNumberOfFluidTanks();
    private boolean separateChambers;
    private static FluidTankInfo[] emptyTankArray = new FluidTankInfo[0];

    public FluidHelper(boolean separate) {
        this.fluids = new FluidStack[this.numberOfFluids];
        this.fluidLevelAtLastUpdate = new int[this.numberOfFluids];
        for (int i = 0; i < this.numberOfFluids; ++i) {
            this.fluids[i] = null;
            this.fluidLevelAtLastUpdate[i] = -1000;
        }
        this.capacity = 0;
        this.separateChambers = separate;
    }

    public abstract int getNumberOfFluidTanks();

    protected abstract String[] getNBTTankNames();

    @Override
    public boolean shouldUpdate() {
        ++this.ticksSinceLastUpdate;
        if (60 < this.ticksSinceLastUpdate) {
            int dev = 0;
            boolean shouldUpdate = false;
            for (int i = 0; i < this.numberOfFluids && !shouldUpdate; ++i) {
                if (this.fluids[i] == null && this.fluidLevelAtLastUpdate[i] > 0) {
                    shouldUpdate = true;
                } else if (this.fluids[i] != null) {
                    if (this.fluidLevelAtLastUpdate[i] == -1000) {
                        shouldUpdate = true;
                    } else {
                        dev += Math.abs(this.fluids[i].amount - this.fluidLevelAtLastUpdate[i]);
                    }
                }
                if (dev < 50) continue;
                shouldUpdate = true;
            }
            if (shouldUpdate) {
                this.resetLastSeenFluidLevels();
            }
            this.ticksSinceLastUpdate = 0;
            return shouldUpdate;
        }
        return false;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public void setCapacity(int newCapacity) {
        int oldCapacity = this.capacity;
        this.capacity = newCapacity;
        this.clampContentsToCapacity();
    }

    protected void merge(FluidHelper other) {
        if (other.capacity > this.capacity) {
            this.capacity = other.capacity;
            this.fluids = other.fluids;
        }
    }

    public int getTotalAmount() {
        int amt = 0;
        for (int i = 0; i < this.fluids.length; ++i) {
            amt += this.getFluidAmount(i);
        }
        return amt;
    }

    protected NBTTagCompound writeToNBT(NBTTagCompound destination) {
        String[] tankNames = this.getNBTTankNames();
        if (tankNames.length != this.fluids.length) {
            throw new IllegalArgumentException("getNBTTankNames must return the same number of strings as there are fluid stacks");
        }
        for (int i = 0; i < tankNames.length; ++i) {
            FluidStack stack = this.fluids[i];
            if (stack == null) continue;
            destination.func_74782_a(tankNames[i], (NBTBase)stack.writeToNBT(new NBTTagCompound()));
        }
        return destination;
    }

    protected void readFromNBT(NBTTagCompound data) {
        String[] tankNames = this.getNBTTankNames();
        if (tankNames.length != this.fluids.length) {
            throw new IllegalArgumentException("getNBTTankNames must return the same number of strings as there are fluid stacks");
        }
        for (int i = 0; i < tankNames.length; ++i) {
            if (data.func_74764_b(tankNames[i])) {
                this.fluids[i] = FluidStack.loadFluidStackFromNBT((NBTTagCompound)data.func_74775_l(tankNames[i]));
                this.fluidLevelAtLastUpdate[i] = this.fluids[i].amount;
                continue;
            }
            this.fluids[i] = null;
            this.fluidLevelAtLastUpdate[i] = 0;
        }
    }

    protected void setFluid(int idx, FluidStack newFluid) {
        this.fluids[idx] = newFluid;
    }

    protected int getFluidAmount(int idx) {
        if (this.fluids[idx] == null) {
            return 0;
        }
        return this.fluids[idx].amount;
    }

    protected Fluid getFluidType(int idx) {
        if (this.fluids[idx] == null) {
            return null;
        }
        return this.fluids[idx].getFluid();
    }

    protected abstract boolean isFluidValidForStack(int var1, Fluid var2);

    protected boolean canAddToStack(int idx, Fluid incoming) {
        if (idx < 0 || idx >= this.fluids.length || incoming == null) {
            return false;
        }
        if (this.fluids[idx] == null) {
            return this.isFluidValidForStack(idx, incoming);
        }
        return this.fluids[idx].getFluid().getID() == incoming.getID();
    }

    protected boolean canAddToStack(int idx, FluidStack incoming) {
        if (idx < 0 || idx >= this.fluids.length || incoming == null) {
            return false;
        }
        if (this.fluids[idx] == null) {
            return this.isFluidValidForStack(idx, incoming.getFluid());
        }
        return this.fluids[idx].isFluidEqual(incoming);
    }

    protected int addFluidToStack(int idx, int fluidAmount) {
        if (this.fluids[idx] == null || this.fluids[idx].getFluid() == null) {
            throw new IllegalArgumentException("Cannot add fluid with only an integer when tank is empty!");
        }
        int amtToAdd = Math.min(fluidAmount, this.getRemainingSpaceForFluid(idx));
        this.fluids[idx].amount += amtToAdd;
        return amtToAdd;
    }

    protected int drainFluidFromStack(int idx, Fluid fluid, int amount) {
        if (this.fluids[idx] == null) {
            return 0;
        }
        if (this.fluids[idx].getFluid().getID() != fluid.getID()) {
            return 0;
        }
        return this.drainFluidFromStack(idx, amount);
    }

    protected int drainFluidFromStack(int idx, int amount) {
        if (this.fluids[idx] == null) {
            return 0;
        }
        if (this.fluids[idx].amount <= amount) {
            amount = this.fluids[idx].amount;
            this.fluids[idx] = null;
        } else {
            this.fluids[idx].amount -= amount;
        }
        return amount;
    }

    protected void clampContentsToCapacity() {
        block4: {
            block3: {
                if (!this.separateChambers) break block3;
                for (int i = 0; i < this.fluids.length; ++i) {
                    if (this.fluids[i] == null) continue;
                    this.fluids[i].amount = Math.min(this.getCapacity(), this.fluids[i].amount);
                }
                break block4;
            }
            if (this.getTotalAmount() <= this.capacity) break block4;
            int diff = this.getTotalAmount() - this.capacity;
            for (int i = this.fluids.length - 1; i >= 0 && diff > 0; --i) {
                if (this.fluids[i] == null) continue;
                if (diff > this.fluids[i].amount) {
                    diff -= this.fluids[i].amount;
                    this.fluids[i] = null;
                    continue;
                }
                this.fluids[i].amount -= diff;
                diff = 0;
            }
        }
    }

    protected void resetLastSeenFluidLevels() {
        for (int i = 0; i < this.numberOfFluids; ++i) {
            this.fluidLevelAtLastUpdate[i] = this.fluids[i] == null ? 0 : this.fluids[i].amount;
        }
    }

    protected int getRemainingSpaceForFluid(int idx) {
        int containedFluidAmt = this.separateChambers ? this.getFluidAmount(idx) : this.getTotalAmount();
        return this.getCapacity() - containedFluidAmt;
    }

    public int fill(int idx, FluidStack incoming, boolean doFill) {
        if (incoming == null || idx < 0 || idx >= this.fluids.length) {
            return 0;
        }
        if (!this.canAddToStack(idx, incoming)) {
            return 0;
        }
        int amtToAdd = Math.min(incoming.amount, this.getRemainingSpaceForFluid(idx));
        if (amtToAdd <= 0) {
            return 0;
        }
        if (!doFill) {
            return amtToAdd;
        }
        if (this.fluids[idx] == null) {
            this.fluids[idx] = incoming.copy();
            this.fluids[idx].amount = amtToAdd;
        } else {
            this.fluids[idx].amount += amtToAdd;
        }
        return amtToAdd;
    }

    public FluidStack drain(int idx, FluidStack resource, boolean doDrain) {
        if (resource == null || resource.amount <= 0 || idx < 0 || idx >= this.fluids.length) {
            return null;
        }
        Fluid existingFluid = this.getFluidType(idx);
        if (existingFluid == null || existingFluid.getID() != resource.getFluid().getID()) {
            return null;
        }
        FluidStack drained = resource.copy();
        drained.amount = !doDrain ? Math.min(resource.amount, this.getFluidAmount(idx)) : this.drainFluidFromStack(idx, resource.amount);
        return drained;
    }

    public FluidStack drain(int idx, int maxDrain, boolean doDrain) {
        if (maxDrain <= 0 || idx < 0 || idx >= this.fluids.length) {
            return null;
        }
        if (this.getFluidType(idx) == null) {
            return null;
        }
        FluidStack drained = new FluidStack(this.getFluidType(idx), 0);
        drained.amount = !doDrain ? Math.min(this.getFluidAmount(idx), maxDrain) : this.drainFluidFromStack(idx, maxDrain);
        return drained;
    }

    public boolean canFill(int idx, Fluid fluid) {
        return this.canAddToStack(idx, fluid);
    }

    public boolean canDrain(int idx, Fluid fluid) {
        if (fluid == null || idx < 0 || idx >= this.fluids.length) {
            return false;
        }
        if (this.fluids[idx] == null) {
            return false;
        }
        return this.fluids[idx].getFluid().getID() == fluid.getID();
    }

    public FluidTankInfo[] getTankInfo(int idx) {
        if (idx >= this.fluids.length) {
            return emptyTankArray;
        }
        if (idx < 0) {
            FluidTankInfo[] info = new FluidTankInfo[this.fluids.length];
            for (int i = 0; i < this.fluids.length; ++i) {
                info[i] = new FluidTankInfo(this.fluids[i] == null ? null : this.fluids[i].copy(), this.getCapacity());
            }
            return info;
        }
        FluidTankInfo[] info = new FluidTankInfo[]{new FluidTankInfo(this.fluids[idx] == null ? null : this.fluids[idx].copy(), this.getCapacity())};
        return info;
    }

    public String getDebugInfo() {
        StringBuilder sb = new StringBuilder();
        sb.append("Capacity (per): ").append(Integer.toString(this.getCapacity()));
        String[] tankNames = this.getNBTTankNames();
        for (int i = 0; i < this.fluids.length; ++i) {
            sb.append("[").append(Integer.toString(i)).append("] ").append(tankNames[i]).append(": ");
            if (this.fluids[i] == null) {
                sb.append("NULL");
            } else {
                FluidStack stack = this.fluids[i];
                sb.append(stack.getFluid().getName()).append(", ").append(Integer.toString(stack.amount)).append(" mB");
            }
            sb.append("\n");
        }
        return sb.toString();
    }
}

