/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.common.multiblock.tileentity;

import cofh.lib.util.helpers.ItemHelper;
import erogenousbeef.bigreactors.api.IHeatEntity;
import erogenousbeef.bigreactors.api.IRadiationModerator;
import erogenousbeef.bigreactors.api.data.ReactorInteriorData;
import erogenousbeef.bigreactors.api.registry.ReactorInterior;
import erogenousbeef.bigreactors.common.data.RadiationData;
import erogenousbeef.bigreactors.common.data.RadiationPacket;
import erogenousbeef.bigreactors.common.multiblock.MultiblockReactor;
import erogenousbeef.bigreactors.common.multiblock.helpers.RadiationHelper;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorControlRod;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorPartBase;
import erogenousbeef.bigreactors.utils.StaticUtils;
import erogenousbeef.core.multiblock.MultiblockValidationException;
import erogenousbeef.core.multiblock.rectangular.RectangularMultiblockTileEntityBase;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.IFluidBlock;

public class TileEntityReactorFuelRod
extends TileEntityReactorPartBase
implements IRadiationModerator,
IHeatEntity {
    @Override
    public void moderateRadiation(RadiationData data, RadiationPacket radiation) {
        if (!this.isConnected()) {
            return;
        }
        MultiblockReactor reactor = this.getReactorController();
        float heat = reactor.getFuelHeat();
        int maxY = reactor.getMaximumCoord().y;
        TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c, maxY, this.field_145849_e);
        if (!(te instanceof TileEntityReactorControlRod)) {
            return;
        }
        float controlRodInsertion = Math.min(1.0f, Math.max(0.0f, (float)((TileEntityReactorControlRod)te).getControlRodInsertion() / 100.0f));
        float baseAbsorption = (float)(1.0 - 0.95 * Math.exp(-10.0 * Math.exp(-0.0022 * (double)heat))) * (1.0f - radiation.hardness / this.getFuelHardnessDivisor());
        float scaledAbsorption = Math.min(1.0f, baseAbsorption * this.getFuelAbsorptionCoefficient());
        float controlRodBonus = (1.0f - scaledAbsorption) * controlRodInsertion * 0.5f;
        float controlRodPenalty = scaledAbsorption * controlRodInsertion * 0.5f;
        float radiationAbsorbed = (scaledAbsorption + controlRodBonus) * radiation.intensity;
        float fertilityAbsorbed = (scaledAbsorption - controlRodPenalty) * radiation.intensity;
        float fuelModerationFactor = this.getFuelModerationFactor();
        fuelModerationFactor += fuelModerationFactor * controlRodInsertion + controlRodInsertion;
        radiation.intensity = Math.max(0.0f, radiation.intensity - radiationAbsorbed);
        radiation.hardness /= fuelModerationFactor;
        data.fuelRfChange += radiationAbsorbed * 10.0f;
        data.fuelAbsorbedRadiation += fertilityAbsorbed;
    }

    private float getFuelModerationFactor() {
        return 1.5f;
    }

    private float getFuelAbsorptionCoefficient() {
        return 0.5f;
    }

    private float getFuelHardnessDivisor() {
        return 1.0f;
    }

    @Override
    public float getThermalConductivity() {
        return 1.0f;
    }

    @Override
    public void isGoodForFrame() throws MultiblockValidationException {
        throw new MultiblockValidationException(String.format("%d, %d, %d - fuel rods may only be placed in the reactor interior", this.field_145851_c, this.field_145848_d, this.field_145849_e));
    }

    @Override
    public void isGoodForSides() throws MultiblockValidationException {
        throw new MultiblockValidationException(String.format("%d, %d, %d - fuel rods may only be placed in the reactor interior", this.field_145851_c, this.field_145848_d, this.field_145849_e));
    }

    @Override
    public void isGoodForTop() throws MultiblockValidationException {
        throw new MultiblockValidationException(String.format("%d, %d, %d - fuel rods may only be placed in the reactor interior", this.field_145851_c, this.field_145848_d, this.field_145849_e));
    }

    @Override
    public void isGoodForBottom() throws MultiblockValidationException {
        throw new MultiblockValidationException(String.format("%d, %d, %d - fuel rods may only be placed in the reactor interior", this.field_145851_c, this.field_145848_d, this.field_145849_e));
    }

    @Override
    public void isGoodForInterior() throws MultiblockValidationException {
        TileEntity entityAbove = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e);
        if (!(entityAbove instanceof TileEntityReactorFuelRod) && !(entityAbove instanceof TileEntityReactorControlRod)) {
            throw new MultiblockValidationException(String.format("Fuel rod at %d, %d, %d must be part of a vertical column that reaches the entire height of the reactor, with a control rod on top.", this.field_145851_c, this.field_145848_d, this.field_145849_e));
        }
        TileEntity entityBelow = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e);
        if (entityBelow instanceof TileEntityReactorFuelRod) {
            return;
        }
        if (entityBelow instanceof RectangularMultiblockTileEntityBase) {
            ((RectangularMultiblockTileEntityBase)entityBelow).isGoodForBottom();
            return;
        }
        throw new MultiblockValidationException(String.format("Fuel rod at %d, %d, %d must be part of a vertical column that reaches the entire height of the reactor, with a control rod on top.", this.field_145851_c, this.field_145848_d, this.field_145849_e));
    }

    @Override
    public void onMachineActivated() {
    }

    @Override
    public void onMachineDeactivated() {
    }

    public float getHeatTransferRate() {
        float heatTransferRate = 0.0f;
        for (ForgeDirection dir : StaticUtils.CardinalDirections) {
            TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ);
            if (te instanceof TileEntityReactorFuelRod) continue;
            if (te instanceof IHeatEntity) {
                heatTransferRate += ((IHeatEntity)te).getThermalConductivity();
                continue;
            }
            if (this.field_145850_b.func_147437_c(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ)) {
                heatTransferRate += 0.05f;
                continue;
            }
            Block block = this.field_145850_b.func_147439_a(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ);
            int metadata = this.field_145850_b.func_72805_g(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ);
            heatTransferRate += this.getConductivityFromBlock(block, metadata);
        }
        return heatTransferRate;
    }

    private float getConductivityFromBlock(Block block, int metadata) {
        ReactorInteriorData interiorData = null;
        if (block == Blocks.field_150339_S) {
            interiorData = ReactorInterior.getBlockData("blockIron");
        } else if (block == Blocks.field_150340_R) {
            interiorData = ReactorInterior.getBlockData("blockGold");
        } else if (block == Blocks.field_150484_ah) {
            interiorData = ReactorInterior.getBlockData("blockDiamond");
        } else if (block == Blocks.field_150475_bE) {
            interiorData = ReactorInterior.getBlockData("blockEmerald");
        } else {
            Fluid fluid;
            interiorData = ReactorInterior.getBlockData(ItemHelper.oreProxy.getOreName(new ItemStack(block, 1, metadata)));
            if (interiorData == null && block instanceof IFluidBlock && (fluid = ((IFluidBlock)block).getFluid()) != null) {
                interiorData = ReactorInterior.getFluidData(fluid.getName());
            }
        }
        if (interiorData == null) {
            interiorData = RadiationHelper.airData;
        }
        return interiorData.heatConductivity;
    }
}

