/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.platforms.client.renderer;

import cpw.mods.fml.client.FMLClientHandler;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;
import shetiphian.core.client.RenderItem2D;
import shetiphian.platforms.Values;
import shetiphian.platforms.client.model.ModelPlatform;
import shetiphian.platforms.common.helpers.CraftHelper;

public class RenderItemCustom
implements IItemRenderer {
    private Minecraft mc = FMLClientHandler.instance().getClient();
    RenderItem rItem = new RenderItem();
    private ModelPlatform modelPlatform = new ModelPlatform();

    private boolean isFlat(ItemStack itemStack) {
        return false;
    }

    private boolean isModel(ItemStack itemStack) {
        Item item = itemStack.func_77973_b();
        int dmg = itemStack.func_77960_j();
        return Values.blockPlatform != null && item == Item.func_150898_a((Block)Values.blockPlatform) && dmg != 50;
    }

    private boolean isExcluded(ItemStack itemStack) {
        Item item = itemStack.func_77973_b();
        int dmg = itemStack.func_77960_j();
        return Values.blockPlatform != null && item == Item.func_150898_a((Block)Values.blockPlatform) && dmg == 50;
    }

    public boolean handleRenderType(ItemStack itemStack, IItemRenderer.ItemRenderType type) {
        return (this.isFlat(itemStack) || this.isModel(itemStack)) && !this.isExcluded(itemStack);
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack itemStack, IItemRenderer.ItemRendererHelper helper) {
        if (Values.blockPlatform != null && itemStack.func_77973_b() == Item.func_150898_a((Block)Values.blockPlatform)) {
            return itemStack.func_77960_j() < 100 || !helper.equals((Object)IItemRenderer.ItemRendererHelper.ENTITY_BOBBING) && !helper.equals((Object)IItemRenderer.ItemRendererHelper.ENTITY_ROTATION);
        }
        return false;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack itemStack, Object ... data) {
        int color;
        IIcon icon;
        if (itemStack.func_77973_b() instanceof ItemBlock) {
            Block block = Block.func_149634_a((Item)itemStack.func_77973_b());
            icon = block.func_149691_a(0, itemStack.func_77960_j());
            color = block.func_149741_i(itemStack.func_77960_j());
        } else {
            icon = itemStack.func_77973_b().getIcon(itemStack, 0);
            color = itemStack.func_77973_b().func_82790_a(itemStack, 0);
        }
        if (this.isFlat(itemStack)) {
            if (type == IItemRenderer.ItemRenderType.ENTITY) {
                RenderItem2D.flatEntity((Minecraft)this.mc, (ItemStack)itemStack, (int)color, (IIcon)icon, (Object[])data);
            }
            if (type == IItemRenderer.ItemRenderType.INVENTORY) {
                RenderItem2D.flatInventory((ItemStack)itemStack, (int)color, (IIcon)icon, (Object[])data);
            }
            if (type == IItemRenderer.ItemRenderType.EQUIPPED || type == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON) {
                RenderItem2D.flatEquipped((Minecraft)this.mc, (ItemStack)itemStack, (int)color, (IIcon)icon, (Object[])data);
            }
        } else if (this.isModel(itemStack) && Values.blockPlatform != null && itemStack.func_77973_b() == Item.func_150898_a((Block)Values.blockPlatform)) {
            this.renderPlatform(type, itemStack, data);
        }
    }

    private void renderPlatform(IItemRenderer.ItemRenderType type, ItemStack itemStack, Object ... data) {
        int platformType = itemStack.func_77960_j() % 10;
        GL11.glPushMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (type == IItemRenderer.ItemRenderType.ENTITY) {
            switch (platformType) {
                case 0: {
                    GL11.glTranslatef((float)0.0f, (float)1.0f, (float)0.0f);
                    break;
                }
                case 3: {
                    GL11.glTranslatef((float)0.0f, (float)0.56f, (float)0.0f);
                    break;
                }
                case 4: {
                    GL11.glTranslatef((float)0.45f, (float)0.56f, (float)0.0f);
                    break;
                }
                case 5: {
                    GL11.glTranslatef((float)0.45f, (float)0.62f, (float)0.0f);
                    break;
                }
                default: {
                    GL11.glTranslatef((float)0.0f, (float)0.64f, (float)0.0f);
                }
            }
            GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
        } else if (type == IItemRenderer.ItemRenderType.INVENTORY) {
            switch (platformType) {
                case 0: {
                    GL11.glTranslatef((float)0.5f, (float)0.3f, (float)0.5f);
                    GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
                    break;
                }
                case 4: 
                case 5: {
                    GL11.glTranslatef((float)1.0f, (float)0.0f, (float)0.6f);
                    GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
                    break;
                }
                default: {
                    GL11.glTranslatef((float)0.5f, (float)0.0f, (float)0.5f);
                    GL11.glScalef((float)0.45f, (float)0.45f, (float)0.45f);
                    break;
                }
            }
        } else if (type == IItemRenderer.ItemRenderType.EQUIPPED || type == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON) {
            EntityLivingBase entity = null;
            for (Object obj : data) {
                if (!(obj instanceof EntityLivingBase)) continue;
                entity = (EntityLivingBase)obj;
            }
            if (entity == this.mc.field_71439_g && this.mc.field_71474_y.field_74320_O == 0) {
                switch (platformType) {
                    case 0: {
                        GL11.glTranslatef((float)0.7f, (float)0.7f, (float)0.7f);
                        GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
                        GL11.glRotatef((float)270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                        break;
                    }
                    case 4: 
                    case 5: {
                        GL11.glTranslatef((float)0.3f, (float)0.3f, (float)0.7f);
                        GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
                        GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                        break;
                    }
                    default: {
                        GL11.glTranslatef((float)0.3f, (float)0.3f, (float)0.7f);
                        GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
                        GL11.glRotatef((float)270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                        break;
                    }
                }
            } else {
                switch (platformType) {
                    case 4: 
                    case 5: {
                        GL11.glTranslatef((float)0.3f, (float)0.4f, (float)1.2f);
                        GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
                        GL11.glRotatef((float)270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                        break;
                    }
                    default: {
                        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
                        GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
                    }
                }
            }
        }
        String[] basepart = new String[]{"joist_", "floor_", "strut_", "brace_"};
        block27: for (int pass = 0; pass < 2; pass = (int)((byte)(pass + 1))) {
            try {
                String name = itemStack.func_77978_p().func_74779_i("texture" + (pass + 1));
                this.modelPlatform.bindTexture(CraftHelper.MaterialId.getFor(name).getTexture());
            }
            catch (Exception exception) {
                // empty catch block
            }
            switch (platformType) {
                case 0: {
                    this.modelPlatform.platform.renderPart(basepart[pass] + "flat_edge_r" + (pass == 1 ? "1" : ""));
                    continue block27;
                }
                case 1: {
                    if (pass == 0) {
                        this.modelPlatform.platform.renderPart(basepart[pass] + "ramp_post_n");
                    }
                    this.modelPlatform.platform.renderPart(basepart[pass] + "ramp_edge_r");
                    continue block27;
                }
                case 3: {
                    this.modelPlatform.platform.renderPart(basepart[pass + 2] + "frame");
                    continue block27;
                }
                case 4: {
                    this.modelPlatform.platform.renderPart(basepart[pass + 2] + "flat_rise_l");
                    continue block27;
                }
                case 5: {
                    this.modelPlatform.platform.renderPart(basepart[pass + 2] + "flat_rail_l");
                }
            }
        }
        GL11.glPopMatrix();
    }
}

