/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.platforms.client.renderer;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import shetiphian.core.backport.EnumFacingHelper;
import shetiphian.platforms.client.model.ModelPlatform;
import shetiphian.platforms.common.helpers.CraftHelper;
import shetiphian.platforms.common.helpers.EnumHelper;
import shetiphian.platforms.common.helpers.TileHelper;
import shetiphian.platforms.common.tileentity.TileEntityPlatformTypes;
import shetiphian.platforms.common.tileentity.TileEntityTypeBase;

public class RenderPlatform
extends TileEntitySpecialRenderer {
    private ModelPlatform modelPlatform = new ModelPlatform();
    private String[] basepart = new String[]{"joist_", "floor_", "strut_", "brace_"};
    private String[] flat = new String[]{"edge_r", "edge_l", "edge_i", "edge_i", "edge_i", "edge_i", "edge_o", "edge_o", "edge_o", "edge_o", "mean_n", "mean_c", "mean_c", "mean_c", "mean_c"};
    private String[] flat_floor = new String[]{"edge_r1", "edge_l1", "edge_i2", "edge_i4", "edge_i3", "edge_i1", "edge_o2", "edge_o3", "edge_o4", "edge_o1", "mean_n", "mean_c1", "mean_c3", "mean_c4", "mean_c2"};
    private String[] ramp = new String[]{"edge_r", "edge_l", "mean_n"};

    public void func_147500_a(TileEntity tile, double x, double y, double z, float partialTick) {
        if (tile instanceof TileEntityTypeBase) {
            this.renderTileEntityAt((TileEntityTypeBase)tile, x, y, z, partialTick);
        }
    }

    private void renderTileEntityAt(TileEntityTypeBase tile, double x, double y, double z, float partialTick) {
        EnumHelper.EnumPlatformTorch torch;
        GL11.glPushMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)32826);
        GL11.glEnable((int)32826);
        GL11.glTranslated((double)(x + 0.5), (double)y, (double)(z + 0.5));
        GL11.glScaled((double)0.5, (double)0.5, (double)0.5);
        int platformType = tile.func_145832_p() % 5;
        float direction = EnumFacingHelper.getHorizontalIndex((EnumFacing)tile.getFacing());
        byte index = TileHelper.getType(tile);
        direction = direction == 0.0f ? 180.0f : (direction == 1.0f ? 90.0f : (direction == 2.0f ? 0.0f : 270.0f));
        GL11.glRotatef((float)direction, (float)0.0f, (float)1.0f, (float)0.0f);
        boolean linkedRail = tile instanceof TileEntityPlatformTypes.TileEntityPlatformRise && ((TileEntityPlatformTypes.TileEntityPlatformRise)tile).isLinkedToRamp();
        CraftHelper.MaterialId[] materials = tile.getMaterials();
        block8: for (int part = 0; part < 4; part = (int)((byte)(part + 1))) {
            if (part > 1 && !TileHelper.hasRail(tile)) continue;
            try {
                this.modelPlatform.bindTexture(materials[part].getTexture());
            }
            catch (Exception e) {
                this.modelPlatform.bindTexture(new ResourceLocation("minecraft:textures/blocks/planks_oak.png"));
            }
            switch (platformType) {
                case 0: {
                    if (part < 2) {
                        this.modelPlatform.platform.renderPart(this.basepart[part] + "flat_" + (part == 1 ? this.flat_floor[index] : this.flat[index]));
                        continue block8;
                    }
                    EnumHelper.EnumPlatform rail = TileHelper.getRail(tile);
                    if (rail == null) continue block8;
                    if (rail.TYPE == EnumHelper.EnumPlatformType.RISE) {
                        this.modelPlatform.platform.renderPart(this.basepart[part] + "flat_rise_" + this.end(this.flat[index]));
                        if (part != 3) continue block8;
                        this.modelPlatform.platform.renderPart(this.basepart[part] + "flat_hand_" + this.end(this.flat[index]));
                        continue block8;
                    }
                    this.modelPlatform.platform.renderPart(this.basepart[part] + "flat_rail_" + this.end(this.flat[index]));
                    continue block8;
                }
                case 1: {
                    if (part < 2) {
                        if (part == 0) {
                            this.modelPlatform.platform.renderPart(this.basepart[part] + "ramp_post_" + (TileHelper.getAltSupport(tile) ? "f" : "n"));
                        }
                        this.modelPlatform.platform.renderPart(this.basepart[part] + "ramp_" + this.ramp[index]);
                        continue block8;
                    }
                    EnumHelper.EnumPlatform rail = TileHelper.getRail(tile);
                    if (rail == null) continue block8;
                    if (rail.TYPE == EnumHelper.EnumPlatformType.RISE) {
                        this.modelPlatform.platform.renderPart(this.basepart[part] + "ramp_rise_" + this.end(this.ramp[index]));
                        if (part != 3) continue block8;
                        this.modelPlatform.platform.renderPart(this.basepart[part] + "ramp_hand_" + this.end(this.ramp[index]));
                        continue block8;
                    }
                    this.modelPlatform.platform.renderPart(this.basepart[part] + "ramp_rail_" + this.end(this.ramp[index]));
                    continue block8;
                }
                case 3: {
                    this.modelPlatform.platform.renderPart(this.basepart[part + 2] + "frame");
                    continue block8;
                }
                case 4: {
                    if (linkedRail) continue block8;
                    this.modelPlatform.platform.renderPart(this.basepart[part + 2] + "flat_rise_" + this.end(this.flat[index]));
                }
            }
        }
        if (tile instanceof TileEntityPlatformTypes.TileEntityPlatformFrame && (torch = ((TileEntityPlatformTypes.TileEntityPlatformFrame)tile).getTorchType()) != null && torch != EnumHelper.EnumPlatformTorch.NONE) {
            this.modelPlatform.bindBrazierTexture(EnumHelper.EnumPlatformTorch.NONE, 0);
            this.modelPlatform.platform.renderPart("brazier");
            int time = (int)(Minecraft.func_71386_F() / 20L) % 600;
            int frame = time / 100;
            int current = MathHelper.func_76125_a((int)(frame > 3 ? 6 - frame : frame), (int)0, (int)3);
            int next = MathHelper.func_76125_a((int)(frame > 2 ? current - 1 : current + 1), (int)0, (int)3);
            float step = MathHelper.func_76131_a((float)((float)(time % 100) / 100.0f), (float)0.0f, (float)1.0f);
            GL11.glPushMatrix();
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.modelPlatform.bindBrazierTexture(torch, current);
            this.modelPlatform.platform.renderPart("brazier_fill");
            this.modelPlatform.bindBrazierTexture(torch, next);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)step);
            this.modelPlatform.platform.renderPart("brazier_fill");
            GL11.glPopMatrix();
        }
        GL11.glPopMatrix();
    }

    private char end(String name) {
        return name.charAt(name.length() - 1);
    }
}

