/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.platforms.common.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.common.util.ForgeDirection;
import shetiphian.core.backport.EnumFacingHelper;
import shetiphian.core.common.Function;
import shetiphian.core.common.MaterialImmovable;
import shetiphian.platforms.Platforms;
import shetiphian.platforms.Values;
import shetiphian.platforms.common.helpers.EnumHelper;
import shetiphian.platforms.common.helpers.PlatformHelper;
import shetiphian.platforms.common.helpers.TileHelper;
import shetiphian.platforms.common.tileentity.TileEntityPlatFormer;
import shetiphian.platforms.common.tileentity.TileEntityPlatformTypes;
import shetiphian.platforms.common.tileentity.TileEntityTypeBase;
import shetiphian.platforms.common.tileentity.TileEntityTypeBaseWithRail;

public class BlockPlatform
extends Block {
    private IIcon[] iconIndex = new IIcon[3];

    public BlockPlatform() {
        super((Material)MaterialImmovable.TRANSLUCENT);
        this.func_149647_a((CreativeTabs)Values.tabPlatforms);
        this.func_149711_c(3.0f);
    }

    public boolean hasTileEntity(int metadata) {
        EnumHelper.EnumPlatform enumPlatform = BlockPlatform.getEnumPlatform(metadata);
        return enumPlatform == EnumHelper.EnumPlatform.PLATFORMER || enumPlatform.TYPE != EnumHelper.EnumPlatformType.RAIL;
    }

    public TileEntity createTileEntity(World world, int metadata) {
        EnumHelper.EnumPlatform enumPlatform = BlockPlatform.getEnumPlatform(metadata);
        if (enumPlatform == EnumHelper.EnumPlatform.PLATFORMER) {
            return new TileEntityPlatFormer();
        }
        switch (enumPlatform.TYPE) {
            case FLAT: {
                return new TileEntityPlatformTypes.TileEntityPlatformFlat();
            }
            case RAMP: {
                return new TileEntityPlatformTypes.TileEntityPlatformRamp();
            }
            case FRAME: {
                return new TileEntityPlatformTypes.TileEntityPlatformFrame();
            }
            case RISE: {
                return new TileEntityPlatformTypes.TileEntityPlatformRise();
            }
        }
        return null;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149692_a(int metadata) {
        return -1;
    }

    public float func_149712_f(World world, int x, int y, int z) {
        return BlockPlatform.getEnumPlatform((int)world.func_72805_g((int)x, (int)y, (int)z)).MATERIAL == EnumHelper.EnumPlatformMaterial.WOOD ? 2.0f : 3.0f;
    }

    public boolean isWood(IBlockAccess world, int x, int y, int z) {
        if (BlockPlatform.getEnumPlatform((int)world.func_72805_g((int)x, (int)y, (int)z)).MATERIAL == EnumHelper.EnumPlatformMaterial.WOOD) {
            return true;
        }
        TileEntityTypeBase tile = TileHelper.getPlatformTile(world, x, y, z);
        EnumHelper.EnumPlatform rail = TileHelper.getRail(tile);
        return rail != null && rail.MATERIAL == EnumHelper.EnumPlatformMaterial.WOOD;
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        EnumHelper.EnumPlatform platform = BlockPlatform.getEnumPlatform(world.func_72805_g(x, y, z));
        if (platform == EnumHelper.EnumPlatform.PLATFORMER) {
            this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            return;
        }
        TileEntityTypeBase tile = TileHelper.getPlatformTile(world, x, y, z);
        if (tile == null) {
            this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            return;
        }
        this.setBounds(tile, platform);
    }

    public MovingObjectPosition func_149731_a(World world, int x, int y, int z, Vec3 start, Vec3 end) {
        TileEntityTypeBase tile;
        EnumHelper.EnumPlatform platform = BlockPlatform.getEnumPlatform(world.func_72805_g(x, y, z));
        if (platform.TYPE == EnumHelper.EnumPlatformType.FLAT && (tile = TileHelper.getPlatformTile((IBlockAccess)world, x, y, z)) != null && TileHelper.hasRail(tile)) {
            MovingObjectPosition areaHit = null;
            tile.rayTracing = true;
            double hitDist = 100.0;
            for (int check = 1; check < 3; check = (int)((byte)(check + 1))) {
                tile.traceBlock = check;
                this.setBounds(tile, platform);
                MovingObjectPosition mop = super.func_149731_a(world, x, y, z, start, end);
                if (mop == null) continue;
                mop.subHit = check;
                double ringDist = mop.field_72307_f.func_72436_e(start);
                if (!(ringDist < hitDist)) continue;
                hitDist = ringDist;
                areaHit = mop;
            }
            if (areaHit != null && areaHit.subHit > 0) {
                tile.traceBlock = areaHit.subHit;
                this.setBounds(tile, platform);
                return areaHit;
            }
            tile.rayTracing = false;
        }
        return super.func_149731_a(world, x, y, z, start, end);
    }

    private void setBounds(TileEntityTypeBase tile, EnumHelper.EnumPlatform platform) {
        int type = TileHelper.getType(tile);
        EnumFacing facing = tile.getFacing();
        switch (platform.TYPE) {
            case FLAT: {
                if (type < 10 && TileHelper.hasRail(tile) && tile.rayTracing && tile.traceBlock > 0) {
                    int n = type >= 2 && type <= 5 ? 2 : (type = type >= 6 && type <= 9 ? 3 : (int)type);
                    if (type == 3) {
                        type = 0;
                        if (tile.traceBlock == 2) {
                            facing = EnumFacingHelper.rotateYCCW((EnumFacing)facing);
                        }
                    }
                } else {
                    this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.125f, 1.0f);
                    return;
                }
            }
            case RISE: {
                if (type == 3) break;
                float[] railBounds = new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
                if (type != 1) {
                    railBounds[0] = facing == EnumFacing.NORTH ? 0.8125f : 0.0f;
                    railBounds[3] = facing == EnumFacing.SOUTH ? 0.1875f : 1.0f;
                    railBounds[2] = facing == EnumFacing.EAST ? 0.8125f : 0.0f;
                    float f = railBounds[5] = facing == EnumFacing.WEST ? 0.1875f : 1.0f;
                    if (type == 2) {
                        railBounds[0] = facing == EnumFacing.EAST ? 0.8125f : railBounds[0];
                        railBounds[3] = facing == EnumFacing.WEST ? 0.1875f : railBounds[3];
                        railBounds[2] = facing == EnumFacing.SOUTH ? 0.8125f : railBounds[2];
                        railBounds[5] = facing == EnumFacing.NORTH ? 0.1875f : railBounds[5];
                    }
                } else {
                    railBounds[0] = facing == EnumFacing.SOUTH ? 0.8125f : 0.0f;
                    railBounds[3] = facing == EnumFacing.NORTH ? 0.1875f : 1.0f;
                    railBounds[2] = facing == EnumFacing.WEST ? 0.8125f : 0.0f;
                    railBounds[5] = facing == EnumFacing.EAST ? 0.1875f : 1.0f;
                }
                this.func_149676_a(railBounds[0], railBounds[1], railBounds[2], railBounds[3], railBounds[4], railBounds[5]);
                return;
            }
        }
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    public void func_149743_a(World world, int x, int y, int z, AxisAlignedBB axisalignedbb, List list, Entity entity) {
        EnumHelper.EnumPlatform platform = BlockPlatform.getEnumPlatform(world.func_72805_g(x, y, z));
        if (platform == EnumHelper.EnumPlatform.PLATFORMER) {
            this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            super.func_149743_a(world, x, y, z, axisalignedbb, list, entity);
            return;
        }
        if (platform.TYPE == EnumHelper.EnumPlatformType.FRAME) {
            this.func_149676_a(0.0625f, 0.0f, 0.0625f, 0.9375f, 1.0f, 0.9375f);
            super.func_149743_a(world, x, y, z, axisalignedbb, list, entity);
            return;
        }
        TileEntityTypeBase tile = TileHelper.getPlatformTile((IBlockAccess)world, x, y, z);
        if (tile == null) {
            this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            super.func_149743_a(world, x, y, z, axisalignedbb, list, entity);
            return;
        }
        float minX = world.func_147439_a(x + 1, y, z) instanceof BlockPlatform ? 0.0f : 0.0625f;
        float minZ = world.func_147439_a(x, y, z - 1) instanceof BlockPlatform ? 0.0f : 0.0625f;
        float maxX = world.func_147439_a(x - 1, y, z) instanceof BlockPlatform ? 1.0f : 0.9375f;
        float maxZ = world.func_147439_a(x, y, z + 1) instanceof BlockPlatform ? 1.0f : 0.9375f;
        EnumHelper.EnumPlatform railType = TileHelper.getRail(tile);
        EnumFacing facing = tile.getFacing();
        int type = TileHelper.getType(tile);
        switch (platform.TYPE) {
            case FLAT: {
                this.func_149676_a(minX, -0.125f, minZ, maxX, 0.125f, maxZ);
                super.func_149743_a(world, x, y, z, axisalignedbb, list, entity);
                if (railType == null || type > 9) break;
                type = type >= 6 && type <= 9 ? 3 : (type >= 2 && type <= 5 ? 2 : (int)type);
            }
            case RISE: {
                if (type >= 4 || tile instanceof TileEntityPlatformTypes.TileEntityPlatformRise && ((TileEntityPlatformTypes.TileEntityPlatformRise)tile).isLinkedToRamp()) break;
                float[] railBounds = new float[]{minX, 0.8125f, minZ, maxX, 1.0f, maxZ};
                if (type == 3) {
                    railBounds[0] = facing == EnumFacing.EAST ? 0.8125f : minX;
                    railBounds[3] = facing == EnumFacing.WEST ? 0.1875f : maxX;
                    railBounds[2] = facing == EnumFacing.SOUTH ? 0.8125f : minZ;
                    railBounds[5] = facing == EnumFacing.NORTH ? 0.1875f : maxZ;
                    this.func_149676_a(railBounds[0], railBounds[1], railBounds[2], railBounds[3], railBounds[4], railBounds[5]);
                    super.func_149743_a(world, x, y, z, axisalignedbb, list, entity);
                }
                if (type != 1) {
                    railBounds[0] = facing == EnumFacing.NORTH ? 0.8125f : minX;
                    railBounds[3] = facing == EnumFacing.SOUTH ? 0.1875f : maxX;
                    railBounds[2] = facing == EnumFacing.EAST ? 0.8125f : minZ;
                    float f = railBounds[5] = facing == EnumFacing.WEST ? 0.1875f : maxZ;
                    if (type == 2) {
                        railBounds[0] = facing == EnumFacing.EAST ? 0.8125f : railBounds[0];
                        railBounds[3] = facing == EnumFacing.WEST ? 0.1875f : railBounds[3];
                        railBounds[2] = facing == EnumFacing.SOUTH ? 0.8125f : railBounds[2];
                        railBounds[5] = facing == EnumFacing.NORTH ? 0.1875f : railBounds[5];
                    }
                } else {
                    railBounds[0] = facing == EnumFacing.SOUTH ? 0.8125f : minX;
                    railBounds[3] = facing == EnumFacing.NORTH ? 0.1875f : maxX;
                    railBounds[2] = facing == EnumFacing.WEST ? 0.8125f : minZ;
                    float f = railBounds[5] = facing == EnumFacing.EAST ? 0.1875f : maxZ;
                }
                if (platform.TYPE == EnumHelper.EnumPlatformType.RISE) {
                    this.func_149676_a(railBounds[0], 0.0f, railBounds[2], railBounds[3], 1.0f, railBounds[5]);
                } else {
                    this.func_149676_a(railBounds[0], railBounds[1], railBounds[2], railBounds[3], railBounds[4], railBounds[5]);
                }
                super.func_149743_a(world, x, y, z, axisalignedbb, list, entity);
                break;
            }
            case RAMP: {
                boolean altRail = railType != null && railType.TYPE == EnumHelper.EnumPlatformType.RISE;
                float[] stepBounds = new float[]{minX, 0.0f, minZ, maxX, 0.125f, maxZ};
                float[] railBounds = new float[]{minX, 1.0f, minZ, maxX, 1.125f, maxZ};
                for (int step = 0; step < 4; step = (int)((byte)(step + 1))) {
                    if (step > 0) {
                        switch (facing) {
                            case SOUTH: {
                                stepBounds[2] = stepBounds[2] + 0.25f;
                                railBounds[2] = stepBounds[2];
                                break;
                            }
                            case WEST: {
                                stepBounds[3] = stepBounds[3] - 0.25f;
                                railBounds[3] = stepBounds[3];
                                break;
                            }
                            case NORTH: {
                                stepBounds[5] = stepBounds[5] - 0.25f;
                                railBounds[5] = stepBounds[5];
                                break;
                            }
                            case EAST: {
                                stepBounds[0] = stepBounds[0] + 0.25f;
                                railBounds[0] = stepBounds[0];
                            }
                        }
                    }
                    this.func_149676_a(stepBounds[0], stepBounds[1], stepBounds[2], stepBounds[3], stepBounds[4], stepBounds[5]);
                    super.func_149743_a(world, x, y, z, axisalignedbb, list, entity);
                    if (railType != null && type != 2 && !altRail) {
                        if (EnumFacingHelper.getAxis((EnumFacing)facing) == EnumFacingHelper.Axis.Z) {
                            railBounds[0] = facing == EnumFacing.SOUTH && type == 1 || facing == EnumFacing.NORTH && type == 0 ? 0.8125f : minX;
                            railBounds[3] = facing == EnumFacing.SOUTH && type == 0 || facing == EnumFacing.NORTH && type == 1 ? 0.1875f : maxX;
                        } else {
                            railBounds[2] = facing == EnumFacing.WEST && type == 1 || facing == EnumFacing.EAST && type == 0 ? 0.8125f : minZ;
                            railBounds[5] = facing == EnumFacing.WEST && type == 0 || facing == EnumFacing.EAST && type == 1 ? 0.1875f : maxZ;
                        }
                        railBounds[1] = step == 0 ? 0.0f : stepBounds[1] + 1.0f;
                        railBounds[4] = stepBounds[4] + 1.0f;
                        this.func_149676_a(railBounds[0], railBounds[1], railBounds[2], railBounds[3], railBounds[4], railBounds[5]);
                        super.func_149743_a(world, x, y, z, axisalignedbb, list, entity);
                    }
                    stepBounds[1] = stepBounds[1] + 0.25f;
                    stepBounds[4] = stepBounds[4] + 0.25f;
                }
                if (railType == null || type == 2 || !altRail) break;
                if (type != 1) {
                    railBounds[0] = facing == EnumFacing.NORTH ? 0.8125f : minX;
                    railBounds[3] = facing == EnumFacing.SOUTH ? 0.1875f : maxX;
                    railBounds[2] = facing == EnumFacing.EAST ? 0.8125f : minZ;
                    railBounds[5] = facing == EnumFacing.WEST ? 0.1875f : maxZ;
                } else {
                    railBounds[0] = facing == EnumFacing.SOUTH ? 0.8125f : minX;
                    railBounds[3] = facing == EnumFacing.NORTH ? 0.1875f : maxX;
                    railBounds[2] = facing == EnumFacing.WEST ? 0.8125f : minZ;
                    railBounds[5] = facing == EnumFacing.EAST ? 0.1875f : maxZ;
                }
                railBounds[4] = 2.0f;
                this.func_149676_a(railBounds[0], railBounds[1], railBounds[2], railBounds[3], railBounds[4], railBounds[5]);
                super.func_149743_a(world, x, y, z, axisalignedbb, list, entity);
                break;
            }
        }
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        EnumHelper.EnumPlatform enumPlatform = BlockPlatform.getEnumPlatform(world.func_72805_g(x, y, z));
        return enumPlatform == EnumHelper.EnumPlatform.PLATFORMER || enumPlatform.TYPE == EnumHelper.EnumPlatformType.FRAME && side == ForgeDirection.UP;
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z, boolean willHarvest) {
        return willHarvest || super.removedByPlayer(world, player, x, y, z, willHarvest);
    }

    public void func_149636_a(World world, EntityPlayer player, int x, int y, int z, int meta) {
        super.func_149636_a(world, player, x, y, z, meta);
        world.func_147468_f(x, y, z);
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        EnumHelper.EnumPlatform enumPlatform = BlockPlatform.getEnumPlatform(world.func_72805_g(x, y, z));
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        if (enumPlatform == EnumHelper.EnumPlatform.PLATFORMER) {
            ret.add(new ItemStack((Block)this, 1, 50));
            return ret;
        }
        TileEntityTypeBase tile = TileHelper.getPlatformTile((IBlockAccess)world, x, y, z);
        if (tile != null) {
            EnumHelper.EnumPlatformTorch torch;
            EnumHelper.EnumPlatform rail;
            ItemStack stack = this.getBaseStack(tile);
            if (stack != null) {
                ret.add(stack);
            }
            if ((rail = TileHelper.getRail(tile)) != null && (stack = this.getRailStack((TileEntityTypeBaseWithRail)tile)) != null) {
                ret.add(stack);
            }
            if ((torch = TileHelper.getTorch(tile)) != null && torch != EnumHelper.EnumPlatformTorch.NONE) {
                ret.add(torch.getItemStack());
                if (torch.isUpgrade()) {
                    ret.add(torch.getBaseItemStack());
                }
            }
        }
        return ret;
    }

    private ItemStack getBaseStack(TileEntityTypeBase tile) {
        if (tile != null) {
            EnumHelper.EnumPlatform enumplatform = BlockPlatform.getEnumPlatform(tile.func_145831_w().func_72805_g(tile.field_145851_c, tile.field_145848_d, tile.field_145849_e));
            return PlatformHelper.getStack(enumplatform, tile.getTextures()[0], tile.getTextures()[1]);
        }
        return null;
    }

    private ItemStack getRailStack(TileEntityTypeBaseWithRail tile) {
        if (tile != null) {
            return PlatformHelper.getStack(tile.getRail(), tile.getTextures()[2], tile.getTextures()[3]);
        }
        return null;
    }

    public void func_149699_a(World world, int x, int y, int z, EntityPlayer player) {
        if (player == null || !player.func_70093_af()) {
            return;
        }
        ItemStack currentItem = player.func_71045_bC();
        if (currentItem == null) {
            return;
        }
        if (currentItem.func_77973_b().getHarvestLevel(currentItem, "wrench") < 0) {
            return;
        }
        EnumHelper.EnumPlatformType platformType = BlockPlatform.getEnumPlatform((int)world.func_72805_g((int)x, (int)y, (int)z)).TYPE;
        if (platformType == EnumHelper.EnumPlatformType.RAIL || platformType == EnumHelper.EnumPlatformType.RISE) {
            return;
        }
        TileEntityTypeBase tile = TileHelper.getPlatformTile((IBlockAccess)world, x, y, z);
        if (tile == null || !TileHelper.hasRail(tile) && TileHelper.hasTorch(tile)) {
            return;
        }
        ItemStack stack = null;
        if (platformType == EnumHelper.EnumPlatformType.FRAME) {
            EnumHelper.EnumPlatformTorch torchType = TileHelper.getTorch(tile);
            stack = torchType != null ? torchType.getItemStack() : null;
        } else if (tile instanceof TileEntityTypeBaseWithRail) {
            stack = this.getRailStack((TileEntityTypeBaseWithRail)tile);
        }
        if (stack != null) {
            Function.giveItem((EntityPlayer)player, (ItemStack)stack);
            if (platformType == EnumHelper.EnumPlatformType.FRAME) {
                TileHelper.removeTorch(tile);
                world.func_147459_d(x, y, z, (Block)this);
            } else {
                TileHelper.removeRail(tile);
                if (tile instanceof TileEntityPlatformTypes.TileEntityPlatformRamp) {
                    this.editRampRail((TileEntityPlatformTypes.TileEntityPlatformRamp)tile);
                }
            }
            Function.syncTile((TileEntity)tile);
        }
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int face, float posX, float posY, float posZ) {
        boolean isGlowstone;
        EnumHelper.EnumPlatform platform = BlockPlatform.getEnumPlatform(world.func_72805_g(x, y, z));
        if (platform == EnumHelper.EnumPlatform.PLATFORMER) {
            if (!world.field_72995_K) {
                player.openGui((Object)Platforms.INSTANCE, 0, world, x, y, z);
            }
            return true;
        }
        ItemStack stack = player.func_71045_bC();
        if (stack == null) {
            return false;
        }
        TileEntityTypeBase tile = TileHelper.getPlatformTile((IBlockAccess)world, x, y, z);
        if (tile == null) {
            return false;
        }
        boolean bl = isGlowstone = stack.func_77973_b() == Items.field_151114_aO;
        if (stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150429_aA) || stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150478_aa) || isGlowstone) {
            if (platform.TYPE == EnumHelper.EnumPlatformType.FRAME) {
                EnumHelper.EnumPlatformTorch torch;
                boolean placed = false;
                if (!TileHelper.hasTorch(tile) && !isGlowstone) {
                    placed = stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150429_aA) ? TileHelper.setTorch(tile, this.isPowered(world, x, y, z) ? EnumHelper.EnumPlatformTorch.REDSTONE_OFF : EnumHelper.EnumPlatformTorch.REDSTONE_ON) : TileHelper.setTorch(tile, EnumHelper.EnumPlatformTorch.LIGHT);
                } else if (isGlowstone && (torch = TileHelper.getTorch(tile)) != null) {
                    switch (torch) {
                        case REDSTONE_OFF: {
                            placed = TileHelper.setTorch(tile, EnumHelper.EnumPlatformTorch.LAMP_ON);
                            break;
                        }
                        case REDSTONE_ON: {
                            placed = TileHelper.setTorch(tile, EnumHelper.EnumPlatformTorch.LAMP_OFF);
                            break;
                        }
                        case LIGHT: {
                            placed = TileHelper.setTorch(tile, EnumHelper.EnumPlatformTorch.GLOWSTONE);
                        }
                    }
                }
                if (placed) {
                    if (!player.field_71075_bZ.field_75098_d) {
                        --player.func_71045_bC().field_77994_a;
                    }
                    world.func_72980_b((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "platform.wood", 1.0f, world.field_73012_v.nextFloat() * 0.1f + 0.9f, false);
                    world.func_147459_d(x, y, z, (Block)this);
                    Function.syncTile((TileEntity)tile);
                    return true;
                }
            }
            return false;
        }
        if (stack.func_77973_b() == Item.func_150898_a((Block)this)) {
            EnumHelper.EnumPlatform heldPlatform = EnumHelper.getPlatform(stack);
            if (heldPlatform.TYPE != EnumHelper.EnumPlatformType.RAIL && heldPlatform.TYPE != EnumHelper.EnumPlatformType.RISE) {
                return false;
            }
            if (tile instanceof TileEntityTypeBaseWithRail) {
                EnumHelper.EnumPlatform rail;
                if (!TileHelper.hasRail(tile)) {
                    if (tile instanceof TileEntityPlatformTypes.TileEntityPlatformRamp && !world.func_147439_a(x, y + 1, z).func_149688_o().func_76222_j()) {
                        return false;
                    }
                    NBTTagCompound nbtTag = stack.func_77978_p();
                    if ((nbtTag.func_74764_b("texture1") || nbtTag.func_74764_b("texture2")) && ((TileEntityTypeBaseWithRail)tile).setRail(heldPlatform)) {
                        EnumHelper.EnumPlatform rail2;
                        ((TileEntityTypeBaseWithRail)tile).setRailTextures(nbtTag.func_74779_i("texture1"), nbtTag.func_74779_i("texture2"));
                        if (!player.field_71075_bZ.field_75098_d) {
                            --player.func_71045_bC().field_77994_a;
                        }
                        if ((rail2 = TileHelper.getRail(tile)) != null) {
                            String material = rail2.MATERIAL.name().toLowerCase();
                            world.func_72980_b((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "platform." + material, 1.0f, world.field_73012_v.nextFloat() * 0.1f + 0.9f, false);
                            Function.syncTile((TileEntity)tile);
                            if (tile instanceof TileEntityPlatformTypes.TileEntityPlatformRamp && TileHelper.getType(tile) < 2) {
                                this.editRampRail((TileEntityPlatformTypes.TileEntityPlatformRamp)tile);
                            }
                            return true;
                        }
                    }
                } else if (heldPlatform.TYPE == EnumHelper.EnumPlatformType.RISE && (rail = TileHelper.getRail(tile)) != null && rail.TYPE != EnumHelper.EnumPlatformType.RISE) {
                    return true;
                }
            }
        }
        return false;
    }

    private void editRampRail(TileEntityPlatformTypes.TileEntityPlatformRamp tile) {
        World world = tile.func_145831_w();
        int x = tile.field_145851_c;
        int y = tile.field_145848_d;
        int z = tile.field_145849_e;
        Block above = world.func_147439_a(x, y + 1, z);
        if (tile.getRampType() < 2 && tile.hasRail()) {
            TileEntityTypeBase oTile;
            if (above != this && above.isReplaceable((IBlockAccess)world, x, y + 1, z)) {
                EnumHelper.EnumPlatform platform = EnumHelper.getPlatform(tile.getRail().MATERIAL.VALUE, 4);
                Function.setBlock((World)world, (int)x, (int)(y + 1), (int)z, (Block)this, (int)EnumType.byPlatform(platform).getValue(), (boolean)false);
            }
            if ((oTile = TileHelper.getPlatformTile((IBlockAccess)world, x, y + 1, z)) instanceof TileEntityPlatformTypes.TileEntityPlatformRise) {
                oTile.setFacing(tile.getFacing());
                oTile.setTextures(tile.getTextures()[2], tile.getTextures()[3]);
                ((TileEntityPlatformTypes.TileEntityPlatformRise)oTile).setRiseType(tile.getRampType());
                ((TileEntityPlatformTypes.TileEntityPlatformRise)oTile).setLinkedToRamp(true);
                ((TileEntityPlatformTypes.TileEntityPlatformRise)oTile).setIsRail(tile.getRail().TYPE == EnumHelper.EnumPlatformType.RAIL);
                Function.syncTile((TileEntity)oTile);
            }
        } else {
            TileEntityTypeBase oTile = TileHelper.getPlatformTile((IBlockAccess)world, x, y + 1, z);
            if (oTile instanceof TileEntityPlatformTypes.TileEntityPlatformRise) {
                Function.removeBlock((World)world, (int)x, (int)(y + 1), (int)z, (boolean)true);
            }
        }
    }

    public boolean canCreatureSpawn(EnumCreatureType type, IBlockAccess world, int x, int y, int z) {
        return false;
    }

    public void func_149670_a(World world, int x, int y, int z, Entity entity) {
        ForgeModContainer.fullBoundingBoxLadders = true;
    }

    private boolean resetAndReturn(boolean isLadder, Entity entity) {
        if (!entity.func_70093_af()) {
            ForgeModContainer.fullBoundingBoxLadders = false;
        }
        return isLadder;
    }

    public boolean isLadder(IBlockAccess world, int x, int y, int z, EntityLivingBase entity) {
        if (entity.func_70115_ae()) {
            return this.resetAndReturn(false, (Entity)entity);
        }
        EnumHelper.EnumPlatform platform = BlockPlatform.getEnumPlatform(world.func_72805_g(x, y, z));
        if (platform == EnumHelper.EnumPlatform.PLATFORMER) {
            return this.resetAndReturn(false, (Entity)entity);
        }
        EnumHelper.EnumPlatformType platformType = platform.TYPE;
        if (platformType == EnumHelper.EnumPlatformType.FRAME) {
            return this.resetAndReturn(true, (Entity)entity);
        }
        if (platformType == EnumHelper.EnumPlatformType.RISE) {
            if (world.func_147439_a(x, y - 1, z) != this) {
                return this.resetAndReturn(true, (Entity)entity);
            }
            EnumHelper.EnumPlatformType typeDown = BlockPlatform.getEnumPlatform((int)world.func_72805_g((int)x, (int)(y - 1), (int)z)).TYPE;
            if (typeDown == EnumHelper.EnumPlatformType.FLAT || typeDown == EnumHelper.EnumPlatformType.RAMP) {
                return this.isLadder(world, x, y - 1, z, entity);
            }
            if (world.func_147439_a(x, y - 2, z) != this) {
                return this.resetAndReturn(true, (Entity)entity);
            }
            typeDown = BlockPlatform.getEnumPlatform((int)world.func_72805_g((int)x, (int)(y - 2), (int)z)).TYPE;
            if (entity.field_70122_E && (typeDown == EnumHelper.EnumPlatformType.FLAT || typeDown == EnumHelper.EnumPlatformType.RAMP)) {
                return this.resetAndReturn(false, (Entity)entity);
            }
            return this.resetAndReturn(true, (Entity)entity);
        }
        TileEntityTypeBase tile = TileHelper.getPlatformTile(world, x, y, z);
        if (tile == null) {
            return this.resetAndReturn(false, (Entity)entity);
        }
        double vY = entity.field_70163_u - entity.func_70033_W();
        int[] adj = Function.getBlockXZ((double)entity.field_70165_t, (double)entity.field_70161_v);
        boolean onPlatform = world.func_147439_a(adj[0], y, adj[1]) instanceof BlockPlatform;
        if (tile instanceof TileEntityPlatformTypes.TileEntityPlatformFlat) {
            if (!onPlatform && vY - (double)((int)vY) < (double)0.1f && world.func_147438_o(x, y - 1, z) instanceof TileEntityPlatformTypes.TileEntityPlatformFrame) {
                return this.resetAndReturn(true, (Entity)entity);
            }
            if (!TileHelper.hasRail(tile)) {
                return this.resetAndReturn(false, (Entity)entity);
            }
        }
        boolean atNorth = !onPlatform && entity.field_70161_v - (double)adj[1] > (double)0.7f;
        boolean atSouth = !onPlatform && entity.field_70161_v - (double)adj[1] < (double)0.3f;
        boolean atWest = !onPlatform && entity.field_70165_t - (double)adj[0] > (double)0.7f;
        boolean atEast = !onPlatform && entity.field_70165_t - (double)adj[0] < (double)0.3f;
        EnumFacing facing = tile.getFacing();
        int type = TileHelper.getType(tile);
        if (tile instanceof TileEntityPlatformTypes.TileEntityPlatformFlat) {
            int n = type >= 2 && type <= 5 ? 2 : (type >= 6 && type <= 9 ? 3 : (type == 10 ? 4 : (type = type >= 11 && type <= 14 ? 5 : type)));
        }
        if (tile instanceof TileEntityPlatformTypes.TileEntityPlatformRamp) {
            if (!onPlatform && vY - (double)((int)vY) < (double)0.1f && world.func_147438_o(x, y - 1, z) instanceof TileEntityPlatformTypes.TileEntityPlatformFrame && (atNorth && facing == EnumFacing.SOUTH || atEast && facing == EnumFacing.WEST || atSouth && facing == EnumFacing.NORTH || atWest && facing == EnumFacing.EAST)) {
                return this.resetAndReturn(true, (Entity)entity);
            }
            if (!TileHelper.hasRail(tile)) {
                return this.resetAndReturn(false, (Entity)entity);
            }
        }
        boolean isLadder = false;
        if (atNorth && (facing == EnumFacing.WEST && type == 0 || facing == EnumFacing.EAST && type == 1)) {
            isLadder = true;
        }
        if (atSouth && (facing == EnumFacing.WEST && type == 1 || facing == EnumFacing.EAST && type == 0)) {
            isLadder = true;
        }
        if (atWest && (facing == EnumFacing.SOUTH && type == 0 || facing == EnumFacing.NORTH && type == 1)) {
            isLadder = true;
        }
        if (atEast && (facing == EnumFacing.SOUTH && type == 1 || facing == EnumFacing.NORTH && type == 0)) {
            isLadder = true;
        }
        if (tile instanceof TileEntityPlatformTypes.TileEntityPlatformFlat) {
            if (atNorth && (facing == EnumFacing.WEST && type == 3 || facing == EnumFacing.NORTH && type == 3)) {
                isLadder = true;
            }
            if (atSouth && (facing == EnumFacing.SOUTH && type == 3 || facing == EnumFacing.EAST && type == 3)) {
                isLadder = true;
            }
            if (atWest && (facing == EnumFacing.SOUTH && type == 3 || facing == EnumFacing.WEST && type == 3)) {
                isLadder = true;
            }
            if (atEast && (facing == EnumFacing.NORTH && type == 3 || facing == EnumFacing.EAST && type == 3)) {
                isLadder = true;
            }
        }
        return this.resetAndReturn(isLadder, (Entity)entity);
    }

    public void func_149695_a(World world, int x, int y, int z, Block neighbor) {
        TileEntityTypeBase tile = TileHelper.getPlatformTile((IBlockAccess)world, x, y, z);
        EnumHelper.EnumPlatformType enumPlatformType = BlockPlatform.getEnumPlatform((int)world.func_72805_g((int)x, (int)y, (int)z)).TYPE;
        if (enumPlatformType == EnumHelper.EnumPlatformType.RAMP) {
            Block blockDown;
            boolean useAltSupport;
            if (TileHelper.hasRail(tile) && TileHelper.getType(tile) < 2 && world.func_147439_a(x, y + 1, z) != this) {
                TileHelper.removeRail(tile);
                Function.syncTile((TileEntity)tile);
            }
            if (!(useAltSupport = (blockDown = world.func_147439_a(x, y - 1, z)) instanceof BlockFence)) {
                boolean bl = useAltSupport = blockDown.func_149704_x() > 0.0625 || blockDown.func_149706_B() > 0.0625 || blockDown.func_149753_y() < 0.9375 || blockDown.func_149693_C() < 0.9375;
            }
            if (tile != null && TileHelper.getAltSupport(tile) != useAltSupport) {
                TileHelper.setAltSupport(tile, useAltSupport);
                Function.syncTile((TileEntity)tile);
            }
        } else if (enumPlatformType == EnumHelper.EnumPlatformType.FRAME) {
            if (tile != null && TileHelper.hasTorch(tile)) {
                EnumHelper.EnumPlatformTorch torch = TileHelper.getTorch(tile);
                if (torch == EnumHelper.EnumPlatformTorch.REDSTONE_OFF || torch == EnumHelper.EnumPlatformTorch.REDSTONE_ON) {
                    if (this.isPowered(world, x, y, z)) {
                        if (torch != EnumHelper.EnumPlatformTorch.REDSTONE_OFF) {
                            TileHelper.setTorch(tile, EnumHelper.EnumPlatformTorch.REDSTONE_OFF);
                            world.func_147459_d(x, y, z, (Block)this);
                            Function.syncTile((TileEntity)tile);
                        }
                    } else if (torch != EnumHelper.EnumPlatformTorch.REDSTONE_ON) {
                        TileHelper.setTorch(tile, EnumHelper.EnumPlatformTorch.REDSTONE_ON);
                        world.func_147459_d(x, y, z, (Block)this);
                        Function.syncTile((TileEntity)tile);
                    }
                } else if (torch == EnumHelper.EnumPlatformTorch.LAMP_OFF || torch == EnumHelper.EnumPlatformTorch.LAMP_ON) {
                    if (this.isPowered(world, x, y, z)) {
                        if (torch != EnumHelper.EnumPlatformTorch.LAMP_ON) {
                            TileHelper.setTorch(tile, EnumHelper.EnumPlatformTorch.LAMP_ON);
                            world.func_147459_d(x, y, z, (Block)this);
                            Function.syncTile((TileEntity)tile);
                        }
                    } else if (torch != EnumHelper.EnumPlatformTorch.LAMP_OFF) {
                        TileHelper.setTorch(tile, EnumHelper.EnumPlatformTorch.LAMP_OFF);
                        world.func_147459_d(x, y, z, (Block)this);
                        Function.syncTile((TileEntity)tile);
                    }
                }
            }
        } else if (enumPlatformType == EnumHelper.EnumPlatformType.RISE && tile instanceof TileEntityPlatformTypes.TileEntityPlatformRise && ((TileEntityPlatformTypes.TileEntityPlatformRise)tile).isLinkedToRamp() && !(TileHelper.getPlatformTile((IBlockAccess)world, x, y - 1, z) instanceof TileEntityPlatformTypes.TileEntityPlatformRamp)) {
            Function.removeBlock((World)world, (int)x, (int)y, (int)z, (boolean)true);
        }
    }

    public boolean rotateBlock(World world, int x, int y, int z, ForgeDirection axis) {
        return this.rotateBlock(TileHelper.getPlatformTile((IBlockAccess)world, x, y, z), axis.ordinal() != 1);
    }

    public boolean rotateBlock(TileEntityTypeBase tile, boolean changeType) {
        TileEntityTypeBase othertile;
        if (tile == null) {
            return false;
        }
        EnumHelper.EnumPlatform enumPlatform = BlockPlatform.getEnumPlatform(tile.func_145832_p());
        if (enumPlatform == null || enumPlatform == EnumHelper.EnumPlatform.PLATFORMER) {
            return false;
        }
        if (enumPlatform.TYPE == EnumHelper.EnumPlatformType.FRAME) {
            changeType = false;
        }
        if (enumPlatform.TYPE == EnumHelper.EnumPlatformType.RISE && (othertile = TileHelper.getPlatformTile((IBlockAccess)tile.func_145831_w(), tile.field_145851_c, tile.field_145848_d - 1, tile.field_145849_e)) instanceof TileEntityPlatformTypes.TileEntityPlatformRamp) {
            return this.rotateBlock(othertile, changeType);
        }
        if (!changeType) {
            tile.setFacing(EnumFacingHelper.rotateY((EnumFacing)tile.getFacing()));
        } else {
            int type = TileHelper.getType(tile);
            switch (enumPlatform.TYPE) {
                case FLAT: {
                    type = type == 14 ? 0 : type + 1;
                    break;
                }
                case RAMP: {
                    type = type == 2 ? 0 : type + 1;
                    break;
                }
                case RISE: {
                    type = type == 3 ? 0 : type + 1;
                    break;
                }
                default: {
                    return false;
                }
            }
            TileHelper.setType(tile, type);
        }
        Function.syncTile((TileEntity)tile);
        if (tile instanceof TileEntityPlatformTypes.TileEntityPlatformRamp) {
            this.editRampRail((TileEntityPlatformTypes.TileEntityPlatformRamp)tile);
        }
        return true;
    }

    public ForgeDirection[] getValidRotations(World world, int x, int y, int z) {
        ForgeDirection[] forgeDirectionArray;
        EnumHelper.EnumPlatform enumPlatform = BlockPlatform.getEnumPlatform(world.func_72805_g(x, y, z));
        if (enumPlatform == EnumHelper.EnumPlatform.PLATFORMER) {
            forgeDirectionArray = null;
        } else {
            ForgeDirection[] forgeDirectionArray2 = new ForgeDirection[2];
            forgeDirectionArray2[0] = ForgeDirection.DOWN;
            forgeDirectionArray = forgeDirectionArray2;
            forgeDirectionArray2[1] = ForgeDirection.UP;
        }
        return forgeDirectionArray;
    }

    private boolean isPowered(World world, int x, int y, int z) {
        if (world.func_94574_k(x, y - 1, z, 0)) {
            return true;
        }
        for (ForgeDirection dir : ForgeDirection.values()) {
            TileEntityTypeBase tile;
            if (dir == ForgeDirection.UP || dir == ForgeDirection.DOWN || dir == ForgeDirection.UNKNOWN || (tile = TileHelper.getPlatformTile((IBlockAccess)world, x + dir.offsetX, y, z + dir.offsetZ)) != null && TileHelper.hasTorch(tile) || world.func_72878_l(x + dir.offsetX, y, z + dir.offsetZ, dir.ordinal()) <= 1) continue;
            return true;
        }
        return false;
    }

    public int func_149748_c(IBlockAccess world, int x, int y, int z, int side) {
        return side == 0 ? this.func_149709_b(world, x, y, z, side) : 0;
    }

    public int func_149709_b(IBlockAccess world, int x, int y, int z, int side) {
        TileEntityTypeBase tile;
        if (side == 1) {
            return 0;
        }
        EnumHelper.EnumPlatformType enumPlatformType = BlockPlatform.getEnumPlatform((int)world.func_72805_g((int)x, (int)y, (int)z)).TYPE;
        if (enumPlatformType == EnumHelper.EnumPlatformType.FRAME && (tile = TileHelper.getPlatformTile(world, x, y, z)) != null) {
            EnumHelper.EnumPlatformTorch torch = TileHelper.getTorch(tile);
            return torch == EnumHelper.EnumPlatformTorch.REDSTONE_ON || torch == EnumHelper.EnumPlatformTorch.LAMP_ON ? (side == 0 ? 15 : 1) : 0;
        }
        return 0;
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        EnumHelper.EnumPlatformTorch torch;
        TileEntityTypeBase tile;
        EnumHelper.EnumPlatformType platformType = BlockPlatform.getEnumPlatform((int)world.func_72805_g((int)x, (int)y, (int)z)).TYPE;
        if (platformType == EnumHelper.EnumPlatformType.FRAME && (tile = TileHelper.getPlatformTile(world, x, y, z)) != null && (torch = TileHelper.getTorch(tile)) != null) {
            switch (torch) {
                case REDSTONE_ON: {
                    return Blocks.field_150429_aA.func_149750_m();
                }
                case LIGHT: {
                    return Blocks.field_150478_aa.func_149750_m();
                }
                case GLOWSTONE: {
                    return Blocks.field_150426_aN.func_149750_m();
                }
                case LAMP_ON: {
                    return Blocks.field_150374_bv.func_149750_m();
                }
            }
        }
        return super.getLightValue(world, x, y, z);
    }

    public boolean isToolEffective(String type, int metadata) {
        boolean isWood = BlockPlatform.getEnumPlatform((int)metadata).MATERIAL == EnumHelper.EnumPlatformMaterial.WOOD;
        return "axe".equals(type) && isWood || "pickaxe".equals(type) && isWood;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random rand) {
        EnumHelper.EnumPlatformType platformType = BlockPlatform.getEnumPlatform((World)world, (int)x, (int)y, (int)z).TYPE;
        if (platformType != EnumHelper.EnumPlatformType.FRAME) {
            return;
        }
        TileEntityTypeBase tile = TileHelper.getPlatformTile((IBlockAccess)world, x, y, z);
        if (tile == null || !TileHelper.hasTorch(tile)) {
            return;
        }
        EnumHelper.EnumPlatformTorch torch = TileHelper.getTorch(tile);
        if (torch != null) {
            double posX = (float)x + 0.5f;
            double posY = (float)y + 0.75f;
            double posZ = (float)z + 0.5f;
            switch (torch) {
                case REDSTONE_ON: 
                case LAMP_ON: {
                    float green = torch == EnumHelper.EnumPlatformTorch.REDSTONE_ON ? 0.0f : 0.75f - (rand.nextFloat() - 0.25f);
                    world.func_72869_a("reddust", posX += (double)(rand.nextFloat() - 0.5f) * 0.2, posY += (double)(rand.nextFloat() - 0.5f) * 0.2, posZ += (double)(rand.nextFloat() - 0.5f) * 0.2, 1.0, (double)green, 0.0);
                    break;
                }
                case LIGHT: {
                    world.func_72869_a("smoke", posX, posY, posZ, 0.0, 0.0, 0.0);
                    world.func_72869_a("flame", posX, posY, posZ, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149645_b() {
        return Values.renderID;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.iconIndex[0] = iconRegister.func_94245_a("platforms:platformer_bottom");
        this.iconIndex[1] = iconRegister.func_94245_a("platforms:platformer_top");
        this.iconIndex[2] = iconRegister.func_94245_a("platforms:platformer_side");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int metadata) {
        switch (metadata / 5) {
            case 0: {
                return Blocks.field_150344_f.func_149691_a(1, 0);
            }
            case 1: {
                return Blocks.field_150348_b.func_149691_a(1, 0);
            }
            case 2: {
                return Blocks.field_150339_S.func_149691_a(1, 0);
            }
        }
        return this.iconIndex[side > 1 ? 2 : side];
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        return this.getPickBlock(target, world, x, y, z, null);
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z, EntityPlayer player) {
        TileEntityTypeBase tile = TileHelper.getPlatformTile((IBlockAccess)world, x, y, z);
        if (tile != null) {
            if (target.subHit > 0 && TileHelper.hasRail(tile)) {
                return this.getRailStack((TileEntityTypeBaseWithRail)tile);
            }
            ItemStack stack = this.getBaseStack(tile);
            if (tile instanceof TileEntityPlatformTypes.TileEntityPlatformRise && ((TileEntityPlatformTypes.TileEntityPlatformRise)tile).isRail()) {
                stack.func_77964_b(stack.func_77960_j() + 1);
            }
            return stack;
        }
        return new ItemStack((Block)this, 1, 50);
    }

    public static EnumHelper.EnumPlatform getEnumPlatform(int metadata) {
        return EnumType.byValue(metadata).getPlatform();
    }

    public static EnumHelper.EnumPlatform getEnumPlatform(World world, int x, int y, int z) {
        return BlockPlatform.getEnumType(world, x, y, z).getPlatform();
    }

    private static EnumType getEnumType(World world, int x, int y, int z) {
        if (!(world.func_147439_a(x, y, z) instanceof BlockPlatform)) {
            return EnumType.WOOD_FLAT;
        }
        int meta = world.func_72805_g(x, y, z);
        if (meta % 5 == 2) {
            return EnumType.WOOD_FLAT;
        }
        return EnumType.byValue(meta);
    }

    private static class MaterialPlatform
    extends Material {
        public MaterialPlatform() {
            super(MapColor.field_151667_k);
            this.func_76225_o();
        }

        public boolean func_76218_k() {
            return false;
        }
    }

    public static enum EnumType {
        WOOD_FLAT(0, EnumHelper.EnumPlatform.WOOD_FLAT),
        WOOD_RAMP(1, EnumHelper.EnumPlatform.WOOD_RAMP),
        WOOD_FRAME(3, EnumHelper.EnumPlatform.WOOD_FRAME),
        WOOD_RISE(4, EnumHelper.EnumPlatform.WOOD_RISE),
        STONE_FLAT(5, EnumHelper.EnumPlatform.STONE_FLAT),
        STONE_RAMP(6, EnumHelper.EnumPlatform.STONE_RAMP),
        STONE_FRAME(8, EnumHelper.EnumPlatform.STONE_FRAME),
        STONE_RISE(9, EnumHelper.EnumPlatform.STONE_RISE),
        METAL_FLAT(10, EnumHelper.EnumPlatform.METAL_FLAT),
        METAL_RAMP(11, EnumHelper.EnumPlatform.METAL_RAMP),
        METAL_FRAME(13, EnumHelper.EnumPlatform.METAL_FRAME),
        METAL_RISE(14, EnumHelper.EnumPlatform.METAL_RISE),
        PLATFORMER(15, EnumHelper.EnumPlatform.PLATFORMER);

        private static final EnumType[] array;
        private final byte value;
        public final EnumHelper.EnumPlatform platform;

        private EnumType(int value, EnumHelper.EnumPlatform platform) {
            this.value = (byte)value;
            this.platform = platform;
        }

        public byte getValue() {
            return this.value;
        }

        public EnumHelper.EnumPlatform getPlatform() {
            return this.platform;
        }

        public static EnumType byValue(int value) {
            EnumType type = array[MathHelper.func_76125_a((int)value, (int)0, (int)(array.length - 1))];
            return type == null ? WOOD_FLAT : type;
        }

        public static EnumType byPlatform(EnumHelper.EnumPlatform platform) {
            for (EnumType value : EnumType.values()) {
                if (value.platform != platform) continue;
                return value;
            }
            return WOOD_FLAT;
        }

        public String getName() {
            return this.toString();
        }

        public String toString() {
            return this.name().toLowerCase();
        }

        static {
            array = new EnumType[16];
            for (EnumType value : EnumType.values()) {
                if (array[value.getValue()] != null) continue;
                EnumType.array[value.getValue()] = value;
            }
        }
    }
}

