/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.platforms.common.helpers;

import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class EnumHelper {
    public static EnumPlatform getPlatform(ItemStack stack) {
        int value = stack.func_77960_j();
        return value == 50 ? EnumPlatform.PLATFORMER : EnumHelper.getPlatform(value, value);
    }

    public static EnumPlatform getPlatform(int material, int type) {
        return EnumHelper.getPlatform(EnumHelper.getMaterial(material), EnumHelper.getType(type));
    }

    public static EnumPlatform getPlatform(EnumPlatformMaterial material, EnumPlatformType type) {
        for (EnumPlatform platform : EnumPlatform.values()) {
            if (platform.MATERIAL != material || platform.TYPE != type) continue;
            return platform;
        }
        return null;
    }

    public static EnumPlatformMaterial getMaterial(int value) {
        value = value / 10 * 10;
        for (EnumPlatformMaterial material : EnumPlatformMaterial.values()) {
            if (material.VALUE != value) continue;
            return material;
        }
        return null;
    }

    public static EnumPlatformType getType(int value) {
        value %= 10;
        for (EnumPlatformType type : EnumPlatformType.values()) {
            if (type.VALUE != value) continue;
            return type;
        }
        return null;
    }

    public static EnumPlatformTorch getTorch(int value) {
        for (EnumPlatformTorch type : EnumPlatformTorch.values()) {
            if (type.VALUE != value) continue;
            return type;
        }
        return null;
    }

    public static enum EnumPlatformTorch {
        NONE(null, 0),
        REDSTONE_OFF(Blocks.field_150429_aA, 1),
        REDSTONE_ON(Blocks.field_150429_aA, 2),
        LIGHT(Blocks.field_150478_aa, 3),
        GLOWSTONE(Items.field_151114_aO, 4),
        LAMP_OFF(Items.field_151114_aO, 5),
        LAMP_ON(Items.field_151114_aO, 6);

        private final ItemStack STACK;
        public final byte VALUE;

        private EnumPlatformTorch(Object object, int value) {
            this.STACK = object instanceof Block ? new ItemStack((Block)object) : (object instanceof Item ? new ItemStack((Item)object) : null);
            this.VALUE = (byte)value;
        }

        public ItemStack getItemStack() {
            return this.STACK != null ? this.STACK.func_77946_l() : null;
        }

        public boolean isUpgrade() {
            return this.STACK != null && this.STACK.func_77973_b() == Items.field_151114_aO;
        }

        public ItemStack getBaseItemStack() {
            return this == REDSTONE_OFF || this == REDSTONE_ON ? REDSTONE_ON.getItemStack() : (this == GLOWSTONE ? LIGHT.getItemStack() : null);
        }
    }

    public static enum EnumPlatformType {
        PLATFORMER(-1),
        FLAT(0),
        RAMP(1),
        FRAME(3),
        RISE(4),
        RAIL(5);

        public final byte VALUE;

        private EnumPlatformType(int value) {
            this.VALUE = (byte)value;
        }
    }

    public static enum EnumPlatformMaterial {
        WOOD("planks", 0),
        STONE("stone", 10),
        METAL("iron_block", 20);

        public final String DEFAULT;
        public final byte VALUE;

        private EnumPlatformMaterial(String material, int value) {
            this.DEFAULT = "minecraft:" + material + ":0";
            this.VALUE = (byte)value;
        }

        public ItemStack getPriItem() {
            switch (this) {
                case WOOD: {
                    return new ItemStack(Blocks.field_150344_f);
                }
                case STONE: {
                    return new ItemStack(Blocks.field_150348_b);
                }
                case METAL: {
                    return new ItemStack(Items.field_151042_j);
                }
            }
            return null;
        }

        public ItemStack getSecItem() {
            switch (this) {
                case WOOD: {
                    return new ItemStack(Items.field_151055_y);
                }
                case STONE: 
                case METAL: {
                    return new ItemStack(Blocks.field_150411_aY);
                }
            }
            return null;
        }
    }

    public static enum EnumPlatform {
        WOOD_FLAT(EnumPlatformMaterial.WOOD, EnumPlatformType.FLAT),
        STONE_FLAT(EnumPlatformMaterial.STONE, EnumPlatformType.FLAT),
        METAL_FLAT(EnumPlatformMaterial.METAL, EnumPlatformType.FLAT),
        WOOD_RAMP(EnumPlatformMaterial.WOOD, EnumPlatformType.RAMP),
        STONE_RAMP(EnumPlatformMaterial.STONE, EnumPlatformType.RAMP),
        METAL_RAMP(EnumPlatformMaterial.METAL, EnumPlatformType.RAMP),
        WOOD_FRAME(EnumPlatformMaterial.WOOD, EnumPlatformType.FRAME),
        STONE_FRAME(EnumPlatformMaterial.STONE, EnumPlatformType.FRAME),
        METAL_FRAME(EnumPlatformMaterial.METAL, EnumPlatformType.FRAME),
        WOOD_RISE(EnumPlatformMaterial.WOOD, EnumPlatformType.RISE),
        STONE_RISE(EnumPlatformMaterial.STONE, EnumPlatformType.RISE),
        METAL_RISE(EnumPlatformMaterial.METAL, EnumPlatformType.RISE),
        WOOD_RAIL(EnumPlatformMaterial.WOOD, EnumPlatformType.RAIL),
        STONE_RAIL(EnumPlatformMaterial.STONE, EnumPlatformType.RAIL),
        METAL_RAIL(EnumPlatformMaterial.METAL, EnumPlatformType.RAIL),
        PLATFORMER(EnumPlatformMaterial.METAL, null);

        public final EnumPlatformMaterial MATERIAL;
        public final EnumPlatformType TYPE;

        private EnumPlatform(EnumPlatformMaterial material, EnumPlatformType type) {
            this.MATERIAL = material;
            this.TYPE = type == null ? EnumPlatformType.PLATFORMER : type;
        }
    }
}

