/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.platforms.common.helpers;

import cpw.mods.fml.common.registry.GameData;
import joptsimple.internal.Strings;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import shetiphian.core.client.Localization;
import shetiphian.platforms.Values;
import shetiphian.platforms.common.helpers.CraftHelper;
import shetiphian.platforms.common.helpers.EnumHelper;
import shetiphian.platforms.common.tileentity.TileEntityTypeBase;

public class PlatformHelper {
    public static String getTextureFromStack(EnumHelper.EnumPlatformMaterial enumPlatformMaterial, ItemStack stack) {
        if (enumPlatformMaterial == EnumHelper.EnumPlatformMaterial.METAL && stack != null && !(stack.func_77973_b() instanceof ItemBlock)) {
            stack = CraftHelper.getOreBlock(stack);
        }
        return stack == null ? enumPlatformMaterial.DEFAULT : GameData.getItemRegistry().func_148750_c((Object)stack.func_77973_b()) + ":" + stack.func_77960_j();
    }

    public static ItemStack getStack(EnumHelper.EnumPlatform enumPlatform, ItemStack texJoistStrut, ItemStack texFloorBrace) {
        return enumPlatform != null ? PlatformHelper.getStack(enumPlatform, PlatformHelper.getTextureFromStack(enumPlatform.MATERIAL, texJoistStrut), PlatformHelper.getTextureFromStack(enumPlatform.MATERIAL, texFloorBrace)) : null;
    }

    public static ItemStack getStack(EnumHelper.EnumPlatform enumPlatform, String texJoistStrut, String texFloorBrace) {
        if (enumPlatform == null) {
            return null;
        }
        if (Strings.isNullOrEmpty((String)texJoistStrut)) {
            texJoistStrut = enumPlatform.MATERIAL.DEFAULT;
        }
        if (Strings.isNullOrEmpty((String)texFloorBrace)) {
            texFloorBrace = enumPlatform.MATERIAL.DEFAULT;
        }
        int metadata = enumPlatform.MATERIAL.VALUE + enumPlatform.TYPE.VALUE;
        ItemStack stack = new ItemStack(Values.blockPlatform, 1, metadata);
        NBTTagCompound nbtTag = new NBTTagCompound();
        nbtTag.func_74778_a("texture1", texJoistStrut);
        nbtTag.func_74778_a("texture2", texFloorBrace);
        stack.func_77982_d(nbtTag);
        return stack;
    }

    public static String getTooltip(TileEntityTypeBase platform) {
        return platform != null ? PlatformHelper.getTooltip(platform.getTextures()) : "";
    }

    public static String getTooltip(ItemStack itemStack) {
        if (itemStack != null && itemStack.func_77942_o()) {
            NBTTagCompound nbtTag = itemStack.func_77978_p();
            return PlatformHelper.getTooltip(nbtTag.func_74779_i("texture1"), nbtTag.func_74779_i("texture2"));
        }
        return "";
    }

    private static String getTooltip(String ... textures) {
        String tooltip = "";
        if (textures != null && textures.length >= 2) {
            if (textures.length == 4 && (Strings.isNullOrEmpty((String)textures[2]) || Strings.isNullOrEmpty((String)textures[3]))) {
                textures = new String[]{textures[0], textures[1]};
            }
            if (textures.length == 4) {
                tooltip = tooltip + Localization.get((String)"info.platforms.base.txt") + "\u00a7r<br>";
            }
            tooltip = tooltip + PlatformHelper.getNameForTexture(textures[1]) + "<br>";
            tooltip = tooltip + PlatformHelper.getNameForTexture(textures[0]);
            if (textures.length == 4) {
                tooltip = tooltip + "<br>" + Localization.get((String)"info.platforms.addon.txt") + "\u00a7r<br>";
                tooltip = tooltip + PlatformHelper.getNameForTexture(textures[3]) + "<br>";
                tooltip = tooltip + PlatformHelper.getNameForTexture(textures[2]);
            }
        }
        return tooltip;
    }

    private static String getNameForTexture(String texture) {
        String name = "";
        if (!Strings.isNullOrEmpty((String)texture)) {
            ItemStack stack = CraftHelper.MaterialId.getFor(texture).toStack();
            name = stack.func_82833_r();
        }
        return name;
    }
}

