/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.platforms.common.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.input.Keyboard;
import shetiphian.core.backport.EnumFacingHelper;
import shetiphian.core.client.Localization;
import shetiphian.core.common.Function;
import shetiphian.platforms.Values;
import shetiphian.platforms.common.block.BlockPlatform;
import shetiphian.platforms.common.helpers.EnumHelper;
import shetiphian.platforms.common.helpers.PlatformHelper;
import shetiphian.platforms.common.helpers.TileHelper;
import shetiphian.platforms.common.tileentity.TileEntityPlatformTypes;
import shetiphian.platforms.common.tileentity.TileEntityTypeBase;
import shetiphian.platforms.common.tileentity.TileEntityTypeBaseWithRail;

public class ItemBlockPlatform
extends ItemBlock {
    private String[] materials = new String[]{".wood", ".stone", ".metal"};
    private String[] types = new String[]{".flat", ".ramp", "", ".frame", ".rise", ".rail", "", "", "", ""};

    public ItemBlockPlatform(Block block) {
        super(block);
        this.func_77656_e(0);
        this.func_77627_a(true);
    }

    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        list.add(new ItemStack((Item)this, 1, 50));
        this.addStack(list, EnumHelper.EnumPlatform.WOOD_FLAT);
        this.addStack(list, EnumHelper.EnumPlatform.WOOD_RAMP);
        this.addStack(list, EnumHelper.EnumPlatform.WOOD_FRAME);
        this.addStack(list, EnumHelper.EnumPlatform.WOOD_RISE);
        this.addStack(list, EnumHelper.EnumPlatform.WOOD_RAIL);
        this.addStack(list, EnumHelper.EnumPlatform.STONE_FLAT);
        this.addStack(list, EnumHelper.EnumPlatform.STONE_RAMP);
        this.addStack(list, EnumHelper.EnumPlatform.STONE_FRAME);
        this.addStack(list, EnumHelper.EnumPlatform.STONE_RISE);
        this.addStack(list, EnumHelper.EnumPlatform.STONE_RAIL);
        this.addStack(list, EnumHelper.EnumPlatform.METAL_FLAT);
        this.addStack(list, EnumHelper.EnumPlatform.METAL_RAMP);
        this.addStack(list, EnumHelper.EnumPlatform.METAL_FRAME);
        this.addStack(list, EnumHelper.EnumPlatform.METAL_RISE);
        this.addStack(list, EnumHelper.EnumPlatform.METAL_RAIL);
    }

    private void addStack(List<ItemStack> list, EnumHelper.EnumPlatform platform) {
        ItemStack stack = PlatformHelper.getStack(platform, "", "");
        if (stack != null) {
            list.add(stack);
        }
    }

    public String func_77667_c(ItemStack itemStack) {
        String name = this.func_77658_a();
        int metadata = itemStack.func_77960_j();
        if (metadata == 50) {
            return name + ".platformer";
        }
        try {
            name = name + this.materials[metadata / 10];
        }
        catch (Exception e) {
            name = name + "material";
        }
        try {
            name = name + this.types[metadata % 10];
        }
        catch (Exception e) {
            name = name + "type";
        }
        return name;
    }

    public int func_77647_b(int dmg) {
        return dmg == 50 || dmg % 10 > 4 ? 15 : dmg / 10 * 5 + dmg % 10;
    }

    private TileEntityTypeBase getPlatformTile(World world, int x, int y, int z, ForgeDirection direction) {
        return TileHelper.getPlatformTile((IBlockAccess)world, x + direction.offsetX, y + direction.offsetY, z + direction.offsetZ);
    }

    public boolean func_150936_a(World world, int x, int y, int z, int sideIndex, EntityPlayer player, ItemStack stack) {
        return stack.func_77960_j() % 10 == 3 && player.func_70093_af() || super.func_150936_a(world, x, y, z, sideIndex, player, stack);
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int sideIndex, float hitX, float hitY, float hitZ) {
        if (stack.func_77960_j() % 10 == 3 && player.func_70093_af()) {
            int facing = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
            EnumFacing direction = EnumFacingHelper.getHorizontal((int)facing);
            Block block = world.func_147439_a(x, y, z);
            if (block instanceof BlockPlatform && BlockPlatform.getEnumPlatform((World)world, (int)x, (int)y, (int)z).TYPE == EnumHelper.EnumPlatformType.FRAME) {
                int sY = y;
                for (int scan = 1; scan < 17; scan = (int)((byte)(scan + 1))) {
                    if (world.func_147437_c(x, ++sY, z)) {
                        if (this.placePlatform(stack, world, x, sY, z, direction, 0) && !player.field_71075_bZ.field_75098_d) {
                            --stack.field_77994_a;
                        }
                        world.func_72908_a((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), this.field_150939_a.field_149762_H.func_150495_a(), (this.field_150939_a.field_149762_H.func_150497_c() + 1.0f) / 2.0f, this.field_150939_a.field_149762_H.func_150494_d() * 0.8f);
                        return false;
                    }
                    block = world.func_147439_a(x, sY, z);
                    if (!(block instanceof BlockPlatform) || BlockPlatform.getEnumPlatform((World)world, (int)x, (int)sY, (int)z).TYPE != EnumHelper.EnumPlatformType.FRAME) break;
                }
                return false;
            }
        }
        return super.func_77648_a(stack, player, world, x, y, z, sideIndex, hitX, hitY, hitZ);
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int sideIndex, float hitX, float hitY, float hitZ, int metadata) {
        TileEntityTypeBase oTile;
        int dmg = stack.func_77960_j();
        if (dmg == 50) {
            return Function.setBlock((World)world, (int)x, (int)y, (int)z, (Block)this.field_150939_a, (int)15, (boolean)false);
        }
        if (dmg > 50) {
            return false;
        }
        EnumFacing side = EnumFacingHelper.VALUES[sideIndex];
        int facing = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        EnumFacing direction = EnumFacingHelper.getHorizontal((int)facing);
        int partType = 0;
        int platformType = dmg % 10;
        if (platformType > 4) {
            return false;
        }
        boolean setDirection = true;
        if ((platformType == 0 && EnumFacingHelper.getAxis((EnumFacing)side) != EnumFacingHelper.Axis.Y || platformType == 4) && (oTile = this.getPlatformTile(world, x, y, z, ForgeDirection.getOrientation((int)sideIndex).getOpposite())) != null) {
            boolean zAxis = EnumFacingHelper.getAxis((EnumFacing)direction) == EnumFacingHelper.Axis.Z;
            byte oType = TileHelper.getType(oTile);
            if (oTile.func_145832_p() == platformType) {
                if (platformType == 0 && oType == 4 || platformType == 4 || zAxis && EnumFacingHelper.getAxis((EnumFacing)side) != EnumFacingHelper.Axis.Z || !zAxis && EnumFacingHelper.getAxis((EnumFacing)side) != EnumFacingHelper.Axis.X) {
                    direction = oTile.getFacing();
                    partType = oType;
                    setDirection = false;
                }
            } else if (side == EnumFacing.UP && platformType == 4 && oTile instanceof TileEntityTypeBaseWithRail) {
                direction = oTile.getFacing();
                EnumHelper.EnumPlatform rail = TileHelper.getRail(oTile);
                if (rail != null && rail.TYPE == EnumHelper.EnumPlatformType.RISE) {
                    if (oTile instanceof TileEntityPlatformTypes.TileEntityPlatformFlat) {
                        if (oType > 3) {
                            return false;
                        }
                        partType = oType;
                    } else {
                        if (oType > 1 || !world.func_147439_a(x, y + 1, z).func_149688_o().func_76222_j()) {
                            return false;
                        }
                        ++y;
                        partType = oType;
                    }
                    setDirection = false;
                }
            }
        }
        if (setDirection) {
            boolean zAxis = EnumFacingHelper.getAxis((EnumFacing)direction) == EnumFacingHelper.Axis.Z;
            switch (platformType) {
                case 0: {
                    if (zAxis) {
                        if (hitX > 0.45f && hitX < 0.55f) {
                            partType = 10;
                            break;
                        }
                        if (direction == EnumFacing.SOUTH) {
                            partType = hitX > 0.5f ? 0 : 1;
                            break;
                        }
                        partType = hitX > 0.5f ? 1 : 0;
                        break;
                    }
                    if (hitZ > 0.45f && hitZ < 0.55f) {
                        partType = 10;
                        break;
                    }
                    if (direction == EnumFacing.WEST) {
                        partType = hitZ > 0.5f ? 0 : 1;
                        break;
                    }
                    partType = hitZ > 0.5f ? 1 : 0;
                    break;
                }
                case 1: {
                    if (zAxis) {
                        if (hitX > 0.45f && hitX < 0.55f) {
                            partType = 2;
                            break;
                        }
                        if (direction == EnumFacing.SOUTH) {
                            partType = hitX > 0.5f ? 0 : 1;
                            break;
                        }
                        partType = hitX > 0.5f ? 1 : 0;
                        break;
                    }
                    if (hitZ > 0.45f && hitZ < 0.55f) {
                        partType = 2;
                        break;
                    }
                    if (direction == EnumFacing.WEST) {
                        partType = hitZ > 0.5f ? 0 : 1;
                        break;
                    }
                    partType = hitZ > 0.5f ? 1 : 0;
                    break;
                }
                case 4: {
                    partType = 0;
                    if (EnumFacingHelper.getAxis((EnumFacing)side) == EnumFacingHelper.Axis.Y) {
                        if (hitX <= 0.5f && hitZ < 0.5f) {
                            direction = hitX < hitZ ? EnumFacing.SOUTH : EnumFacing.WEST;
                            break;
                        }
                        if (hitX > 0.5f && hitZ <= 0.5f) {
                            direction = 1.0f - hitX < hitZ ? EnumFacing.NORTH : EnumFacing.WEST;
                            break;
                        }
                        if (hitX <= 0.5f && hitZ > 0.5f) {
                            direction = hitX < 1.0f - hitZ ? EnumFacing.SOUTH : EnumFacing.EAST;
                            break;
                        }
                        if (!(hitX > 0.5f) || !(hitZ >= 0.5f)) break;
                        direction = hitX > hitZ ? EnumFacing.NORTH : EnumFacing.EAST;
                        break;
                    }
                    direction = EnumFacingHelper.rotateYCCW((EnumFacing)EnumFacingHelper.getOpposite((EnumFacing)side));
                }
            }
        }
        if ((platformType == 0 || platformType == 1) && EnumFacingHelper.getAxis((EnumFacing)side) != EnumFacingHelper.Axis.Y && EnumFacingHelper.getAxis((EnumFacing)side) != EnumFacingHelper.getAxis((EnumFacing)direction)) {
            partType = partType == 0 ? 1 : (partType == 1 ? 0 : partType);
        }
        return this.placePlatform(stack, world, x, y, z, direction, partType);
    }

    private boolean placePlatform(ItemStack stack, World world, int x, int y, int z, EnumFacing direction, int partType) {
        NBTTagCompound nbtTag;
        int platformType;
        int dmg = stack.func_77960_j();
        int metadata = dmg / 10 * 5 + (platformType = dmg % 10);
        if (!Function.setBlock((World)world, (int)x, (int)y, (int)z, (Block)this.field_150939_a, (int)metadata, (boolean)false)) {
            return false;
        }
        TileEntityTypeBase tile = TileHelper.getPlatformTile((IBlockAccess)world, x, y, z);
        if (tile == null) {
            Function.removeBlock((World)world, (int)x, (int)y, (int)z, (boolean)false);
            return false;
        }
        if (stack.func_77942_o() && (nbtTag = stack.func_77978_p()).func_74764_b("texture1") && nbtTag.func_74764_b("texture2")) {
            tile.setTextures(nbtTag.func_74779_i("texture1"), nbtTag.func_74779_i("texture2"));
        }
        TileHelper.setType(tile, partType);
        tile.setFacing(direction);
        Values.blockPlatform.func_149695_a(world, x, y, z, Values.blockPlatform);
        world.func_147444_c(x, y, z, Values.blockPlatform);
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean par4) {
        if (itemStack.func_77942_o()) {
            if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
                String[] lines;
                for (String line : lines = PlatformHelper.getTooltip(itemStack).split("<br>")) {
                    list.add(line);
                }
            } else {
                list.add(Localization.get((String)"info.shetiphian.holdshift.txt"));
            }
        }
    }
}

