/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.platforms.common.tileentity;

import net.minecraft.block.Block;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import shetiphian.core.common.Function;
import shetiphian.core.common.inventory.IOutputSlot;
import shetiphian.core.common.tileentity.TileEntityBase;
import shetiphian.platforms.common.helpers.CraftHelper;
import shetiphian.platforms.common.helpers.EnumHelper;
import shetiphian.platforms.common.helpers.PlatformHelper;

public class TileEntityPlatFormer
extends TileEntityBase
implements ISidedInventory,
IOutputSlot {
    public byte platformType = 0;
    public ItemStack[] inventory = new ItemStack[15];
    private ItemStack[] deconstructCache = new ItemStack[4];
    private byte[] craftAmount = new byte[]{4, 2, 0, 2, 4, 4};
    public EntityItem displayItem = null;
    private ItemStack outputItem;

    protected void buildNBT(NBTTagCompound nbtTag) {
        nbtTag.func_74774_a("type", this.platformType);
        NBTTagList listItems = new NBTTagList();
        for (int slot = 0; slot < this.inventory.length; ++slot) {
            if (this.inventory[slot] == null) continue;
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74774_a("slot", (byte)slot);
            this.inventory[slot].func_77955_b(compound);
            listItems.func_74742_a((NBTBase)compound);
        }
        nbtTag.func_74782_a("inventory", (NBTBase)listItems);
    }

    protected void processNBT(NBTTagCompound nbtTag) {
        this.platformType = nbtTag.func_74771_c("type");
        NBTTagList listItems = nbtTag.func_150295_c("inventory", 10);
        for (int entry = 0; entry < listItems.func_74745_c(); ++entry) {
            NBTTagCompound compound = listItems.func_150305_b(entry);
            byte slot = compound.func_74771_c("slot");
            if (slot < 0 || slot >= this.inventory.length) continue;
            this.inventory[slot] = ItemStack.func_77949_a((NBTTagCompound)compound);
        }
    }

    public boolean canUpdate() {
        return true;
    }

    public void func_145845_h() {
        byte needed;
        if (this.outputItem == null) {
            this.updateOutput();
        }
        if (this.inventory[5] != null && this.inventory[5].field_77994_a >= (needed = this.getCraftedAmount())) {
            this.deconstruct(needed);
        }
    }

    private void deconstruct(int needed) {
        if (!Function.areItemStacksEqual((ItemStack)this.deconstructCache[0], (ItemStack)this.inventory[5])) {
            this.deconstructCache[0] = this.inventory[5];
            EnumHelper.EnumPlatformMaterial material = EnumHelper.getMaterial(this.inventory[5].func_77960_j());
            NBTTagCompound nbtTag = this.inventory[5].func_77978_p();
            if (nbtTag != null && nbtTag.func_74764_b("texture1") && nbtTag.func_74764_b("texture2")) {
                CraftHelper.MaterialId materialId = CraftHelper.MaterialId.getFor(nbtTag.func_74779_i("texture1"));
                if (materialId != null) {
                    ItemStack itemStack = this.deconstructCache[1] = material == EnumHelper.EnumPlatformMaterial.METAL ? CraftHelper.getIngot(materialId.toStack()) : materialId.toStack();
                }
                if ((materialId = CraftHelper.MaterialId.getFor(nbtTag.func_74779_i("texture2"))) != null) {
                    this.deconstructCache[2] = material == EnumHelper.EnumPlatformMaterial.METAL ? CraftHelper.getIngot(materialId.toStack()) : materialId.toStack();
                }
            }
            this.deconstructCache[3] = material == EnumHelper.EnumPlatformMaterial.WOOD ? new ItemStack(Items.field_151055_y) : new ItemStack(Blocks.field_150411_aY);
        }
        int[] slots = new int[]{-1, -1, -1};
        ItemStack[] temp = (ItemStack[])this.inventory.clone();
        block0: for (int item = 0; item < 3; item = (int)((byte)(item + 1))) {
            for (int pass = 0; pass < 2; pass = (int)((byte)(pass + 1))) {
                for (int slot = 6; slot < 15; slot = (int)((byte)(slot + 1))) {
                    if (temp[slot] != null) {
                        if (temp[slot].field_77994_a >= temp[slot].func_77976_d() || !Function.areItemStacksEqual((ItemStack)temp[slot], (ItemStack)this.deconstructCache[1 + item])) continue;
                        slots[item] = slot;
                        ++temp[slot].field_77994_a;
                        continue block0;
                    }
                    if (pass != 1) continue;
                    slots[item] = slot;
                    temp[slot] = this.deconstructCache[1 + item].func_77946_l();
                    continue block0;
                }
            }
        }
        if (slots[0] > -1 && slots[1] > -1 && slots[2] > -1) {
            this.inventory[slots[0]] = temp[slots[0]];
            this.inventory[slots[1]] = temp[slots[1]];
            this.inventory[slots[2]] = temp[slots[2]];
            if (this.inventory[5].field_77994_a - needed < 1) {
                this.inventory[5] = null;
            } else {
                this.inventory[5].field_77994_a -= needed;
            }
            this.func_70296_d();
        }
    }

    public void dropItems() {
        for (int slotId = 4; slotId < this.inventory.length; ++slotId) {
            Function.dropItem((World)this.field_145850_b, (int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e, (ItemStack)this.inventory[slotId]);
        }
    }

    private byte getCraftedAmount() {
        int type = this.outputItem.func_77960_j() % 10;
        if (type < this.craftAmount.length) {
            return this.craftAmount[type];
        }
        return 0;
    }

    public void updateOutput() {
        this.setGhostSlot(0, this.inventory[0]);
        this.setGhostSlot(1, this.inventory[1]);
        this.setGhostSlot(2, this.inventory[2]);
        EnumHelper.EnumPlatform enumplatform = EnumHelper.getPlatform(this.platformType, this.platformType % 10);
        this.outputItem = PlatformHelper.getStack(enumplatform, this.inventory[1], this.inventory[0]);
        if (this.outputItem != null) {
            this.outputItem.field_77994_a = this.getCraftedAmount();
            ItemStack displaystack = this.outputItem.func_77946_l();
            displaystack.func_77964_b(displaystack.func_77960_j() + 100);
            displaystack.field_77994_a = 1;
            this.displayItem = new EntityItem(this.field_145850_b, 0.0, 0.0, 0.0, displaystack);
            this.inventory[3] = this.outputItem.func_77946_l();
        }
    }

    public EntityItem getEntity() {
        if (this.displayItem == null) {
            this.updateOutput();
        }
        return this.displayItem;
    }

    public boolean canCraft() {
        ItemStack[] craftStacks = CraftHelper.getCraftStacks(EnumHelper.getMaterial(this.platformType), this.inventory[0], this.inventory[1], this.inventory[2]);
        boolean[] hasItem = new boolean[]{false, false, false};
        for (int slot = 6; slot < 15; slot = (int)((byte)(slot + 1))) {
            if (this.inventory[slot] == null) continue;
            if (!hasItem[0] && Function.areItemStacksEqual((ItemStack)this.inventory[slot], (ItemStack)craftStacks[0])) {
                hasItem[0] = true;
                if (hasItem[1] || !Function.areItemStacksEqual((ItemStack)craftStacks[0], (ItemStack)craftStacks[1]) || this.inventory[slot].field_77994_a <= 1) continue;
                hasItem[1] = true;
            }
            if (!hasItem[1] && Function.areItemStacksEqual((ItemStack)this.inventory[slot], (ItemStack)craftStacks[1])) {
                hasItem[1] = true;
            }
            if (hasItem[2] || !Function.areItemStacksEqual((ItemStack)this.inventory[slot], (ItemStack)craftStacks[2])) continue;
            hasItem[2] = true;
        }
        return hasItem[0] && hasItem[1] && hasItem[2];
    }

    public void doCraft() {
        ItemStack[] craftStacks = CraftHelper.getCraftStacks(EnumHelper.getMaterial(this.platformType), this.inventory[0], this.inventory[1], this.inventory[2]);
        boolean[] hasItem = new boolean[]{false, false, false};
        for (int slot = 6; slot < 15; slot = (int)((byte)(slot + 1))) {
            if (this.inventory[slot] == null) continue;
            for (int part = 0; part < 3; part = (int)((byte)(part + 1))) {
                if (hasItem[part] || !Function.areItemStacksEqual((ItemStack)this.inventory[slot], (ItemStack)craftStacks[part])) continue;
                hasItem[part] = true;
                if (this.inventory[slot].field_77994_a == 1) {
                    this.inventory[slot] = null;
                    continue;
                }
                --this.inventory[slot].field_77994_a;
            }
        }
    }

    public void setGhostSlot(int slotId, ItemStack stack) {
        if (stack == null) {
            if (slotId >= 0 && slotId < 3) {
                this.inventory[slotId] = null;
            }
            return;
        }
        boolean itemOK = false;
        if (slotId == 0 || slotId == 1) {
            switch (this.platformType / 10) {
                case 0: {
                    itemOK = CraftHelper.isPlanks(stack);
                    break;
                }
                case 1: {
                    itemOK = CraftHelper.isStone(stack);
                    break;
                }
                case 2: {
                    itemOK = CraftHelper.isMetal(stack);
                }
            }
        } else if (slotId == 2) {
            switch (this.platformType / 10) {
                case 0: {
                    itemOK = stack.func_77973_b() == Items.field_151055_y;
                    break;
                }
                default: {
                    itemOK = stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150411_aY);
                }
            }
        }
        this.inventory[slotId] = itemOK ? stack.func_77946_l().func_77979_a(1) : null;
    }

    public boolean canTakeFromOutputSlot(int slotId, EntityPlayer player) {
        return slotId != 3 || player.field_71075_bZ.field_75098_d || this.canCraft();
    }

    public void onPickupFromOutputSlot(int slotId, EntityPlayer player, ItemStack stack) {
        if (slotId == 3 && player.field_71075_bZ.field_75098_d) {
            stack = this.inventory[slotId].func_77946_l();
            stack.field_77994_a = 64;
            player.field_71071_by.func_70437_b(stack);
        }
    }

    public int func_70302_i_() {
        return this.inventory.length;
    }

    public ItemStack func_70301_a(int slotId) {
        if (slotId >= 0 && slotId < this.func_70302_i_()) {
            return this.inventory[slotId];
        }
        return null;
    }

    public ItemStack func_70298_a(int slotId, int amount) {
        if (slotId == 3) {
            if (this.inventory[4] == null && this.canCraft()) {
                this.doCraft();
                ItemStack stack = this.outputItem.func_77946_l();
                if (stack.field_77994_a <= amount) {
                    this.func_70296_d();
                    return stack;
                }
                this.inventory[4] = this.outputItem.func_77946_l();
                return this.func_70298_a(4, amount);
            }
            return null;
        }
        if (this.func_70301_a(slotId) != null) {
            ItemStack stack = this.func_70301_a(slotId);
            if (stack.field_77994_a <= amount) {
                this.inventory[slotId] = null;
                this.func_70296_d();
                return stack;
            }
            stack = this.func_70301_a(slotId).func_77979_a(amount);
            if (this.inventory[slotId] != null && this.inventory[slotId].field_77994_a < 1) {
                this.inventory[slotId] = null;
            }
            this.func_70296_d();
            return stack;
        }
        return null;
    }

    public ItemStack func_70304_b(int slotId) {
        ItemStack returnStack = this.func_70301_a(slotId);
        this.func_70299_a(slotId, null);
        return returnStack;
    }

    public void func_70299_a(int slotId, ItemStack stack) {
        if (slotId >= 0 && slotId < this.func_70302_i_()) {
            this.inventory[slotId] = stack;
            if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
                stack.field_77994_a = this.func_70297_j_();
            }
        }
    }

    public String func_145825_b() {
        return "platform.crafter";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this ? false : player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slotId, ItemStack stack) {
        return slotId > 4;
    }

    public int[] func_94128_d(int side) {
        return new int[]{3, 4, 6, 7, 8, 9, 10, 11, 12, 13, 14};
    }

    public boolean func_102007_a(int slotId, ItemStack stack, int side) {
        return slotId > 5;
    }

    public boolean func_102008_b(int slotId, ItemStack stack, int side) {
        return slotId == 4 || slotId == 3 && this.inventory[4] == null;
    }
}

