/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.platforms.common.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import shetiphian.platforms.common.helpers.EnumHelper;
import shetiphian.platforms.common.tileentity.TileEntityTypeBase;
import shetiphian.platforms.common.tileentity.TileEntityTypeBaseWithRail;

public class TileEntityPlatformTypes
extends TileEntityTypeBaseWithRail {

    public static class TileEntityPlatformRise
    extends TileEntityTypeBase {
        private byte riseType = 0;
        private boolean linkedToRamp = false;
        private boolean isRail = false;

        @Override
        protected void buildNBT(NBTTagCompound nbtTag) {
            super.buildNBT(nbtTag);
            nbtTag.func_74774_a("riseType", this.riseType);
            nbtTag.func_74757_a("linkedToRamp", this.linkedToRamp);
            nbtTag.func_74757_a("isRail", this.isRail);
        }

        @Override
        protected void processNBT(NBTTagCompound nbtTag) {
            super.processNBT(nbtTag);
            this.riseType = nbtTag.func_74771_c("riseType");
            this.linkedToRamp = nbtTag.func_74767_n("linkedToRamp");
            this.isRail = nbtTag.func_74767_n("isRail");
        }

        public byte getRiseType() {
            return this.riseType;
        }

        public void setRiseType(int riseType) {
            this.riseType = (byte)MathHelper.func_76125_a((int)riseType, (int)0, (int)5);
        }

        public void setLinkedToRamp(boolean linkToRamp) {
            this.linkedToRamp = linkToRamp;
        }

        public boolean isLinkedToRamp() {
            return this.linkedToRamp;
        }

        public void setIsRail(boolean isRail) {
            this.isRail = isRail;
        }

        public boolean isRail() {
            return this.isRail;
        }
    }

    public static class TileEntityPlatformFrame
    extends TileEntityTypeBase {
        private EnumHelper.EnumPlatformTorch torchType = EnumHelper.EnumPlatformTorch.NONE;

        @Override
        protected void buildNBT(NBTTagCompound nbtTag) {
            super.buildNBT(nbtTag);
            nbtTag.func_74774_a("torchType", this.torchType.VALUE);
        }

        @Override
        protected void processNBT(NBTTagCompound nbtTag) {
            super.processNBT(nbtTag);
            this.torchType = EnumHelper.getTorch(nbtTag.func_74771_c("torchType"));
        }

        protected void processNBT_SyncOnly(NBTTagCompound nbtTag) {
            super.processNBT_SyncOnly(nbtTag);
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.field_145850_b.func_147451_t(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }

        public EnumHelper.EnumPlatformTorch getTorchType() {
            return this.torchType;
        }

        public boolean setTorchType(EnumHelper.EnumPlatformTorch torchType) {
            if (torchType != null && torchType != EnumHelper.EnumPlatformTorch.NONE) {
                this.torchType = torchType;
                return true;
            }
            return false;
        }

        public void removeTorch() {
            switch (this.torchType) {
                case GLOWSTONE: {
                    this.torchType = EnumHelper.EnumPlatformTorch.LIGHT;
                    return;
                }
                case LAMP_OFF: {
                    this.torchType = EnumHelper.EnumPlatformTorch.REDSTONE_ON;
                    return;
                }
                case LAMP_ON: {
                    this.torchType = EnumHelper.EnumPlatformTorch.REDSTONE_OFF;
                    return;
                }
            }
            this.torchType = EnumHelper.EnumPlatformTorch.NONE;
        }
    }

    public static class TileEntityPlatformRamp
    extends TileEntityTypeBaseWithRail {
        public byte rampType = 0;
        public boolean altSupport = false;

        @Override
        protected void buildNBT(NBTTagCompound nbtTag) {
            super.buildNBT(nbtTag);
            nbtTag.func_74774_a("rampType", this.rampType);
            nbtTag.func_74774_a("altSupport", (byte)(this.altSupport ? 1 : 0));
        }

        @Override
        protected void processNBT(NBTTagCompound nbtTag) {
            super.processNBT(nbtTag);
            this.rampType = nbtTag.func_74771_c("rampType");
            this.altSupport = nbtTag.func_74771_c("altSupport") == 1;
        }

        public byte getRampType() {
            return this.rampType;
        }

        public void setRampType(int flatType) {
            this.rampType = (byte)MathHelper.func_76125_a((int)flatType, (int)0, (int)5);
        }

        public boolean getAltSupport() {
            return this.altSupport;
        }

        public void setAltSupport(boolean useAltSupport) {
            this.altSupport = useAltSupport;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public AxisAlignedBB getRenderBoundingBox() {
            AxisAlignedBB aabb = super.getRenderBoundingBox();
            aabb.func_72321_a(0.0, 0.25, 0.0);
            return aabb;
        }
    }

    public static class TileEntityPlatformFlat
    extends TileEntityTypeBaseWithRail {
        private byte flatType = 0;

        @Override
        protected void buildNBT(NBTTagCompound nbtTag) {
            super.buildNBT(nbtTag);
            nbtTag.func_74774_a("flatType", this.flatType);
        }

        @Override
        protected void processNBT(NBTTagCompound nbtTag) {
            super.processNBT(nbtTag);
            this.flatType = nbtTag.func_74771_c("flatType");
        }

        public byte getFlatType() {
            return this.flatType;
        }

        public void setFlatType(int flatType) {
            this.flatType = (byte)MathHelper.func_76125_a((int)flatType, (int)0, (int)14);
        }
    }
}

