/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.platforms.common.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumFacing;
import shetiphian.core.backport.EnumFacingHelper;
import shetiphian.core.common.tileentity.TileEntityBase;
import shetiphian.platforms.common.helpers.CraftHelper;

public abstract class TileEntityTypeBase
extends TileEntityBase {
    private EnumFacing facing = EnumFacing.NORTH;
    protected CraftHelper.MaterialId texture1;
    protected CraftHelper.MaterialId texture2;
    protected ItemStack resource1;
    protected ItemStack resource2;
    public boolean rayTracing = false;
    public int traceBlock = 0;

    protected void buildNBT(NBTTagCompound nbtTag) {
        nbtTag.func_74778_a("facing", EnumFacingHelper.getName((EnumFacing)this.facing));
        nbtTag.func_74778_a("texture1", this.getTexture(this.texture1));
        nbtTag.func_74778_a("texture2", this.getTexture(this.texture2));
    }

    protected void processNBT(NBTTagCompound nbtTag) {
        this.facing = EnumFacingHelper.byName((String)nbtTag.func_74779_i("facing"));
        this.setTextures(nbtTag.func_74779_i("texture1"), nbtTag.func_74779_i("texture2"));
    }

    public void setFacing(EnumFacing facing) {
        this.facing = EnumFacingHelper.getAxis((EnumFacing)facing) == EnumFacingHelper.Axis.Y ? EnumFacing.NORTH : facing;
    }

    public EnumFacing getFacing() {
        return this.facing;
    }

    public CraftHelper.MaterialId[] getMaterials() {
        return new CraftHelper.MaterialId[]{this.texture1, this.texture2};
    }

    public String[] getTextures() {
        return new String[]{this.getTexture(this.texture1), this.getTexture(this.texture2)};
    }

    protected String getTexture(CraftHelper.MaterialId id) {
        return id == null ? "" : id.toString();
    }

    public void setTextures(String mId1, String mId2) {
        this.texture1 = CraftHelper.MaterialId.getFor(mId1);
        this.texture2 = CraftHelper.MaterialId.getFor(mId2);
        this.resource1 = this.texture1.toStack();
        this.resource2 = this.texture2.toStack();
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return super.getRenderBoundingBox().func_72314_b((double)0.55f, (double)0.55f, (double)0.55f);
    }
}

