/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.machine;

import cofh.api.energy.IEnergyContainerItem;
import cofh.lib.util.helpers.EnergyHelper;
import cofh.lib.util.helpers.ItemHelper;
import cofh.lib.util.helpers.MathHelper;
import cofh.lib.util.helpers.ServerHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.TileTEBase;
import cofh.thermalexpansion.block.machine.BlockMachine;
import cofh.thermalexpansion.block.machine.TileMachineBase;
import cofh.thermalexpansion.gui.client.machine.GuiCharger;
import cofh.thermalexpansion.gui.container.machine.ContainerCharger;
import cofh.thermalexpansion.util.crafting.ChargerManager;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class TileCharger
extends TileMachineBase {
    static int[] RATE;
    int inputTracker;
    int outputTracker;
    IEnergyContainerItem containerItem = null;

    public static void initialize() {
        int n = BlockMachine.Types.CHARGER.ordinal();
        TileMachineBase.defaultSideConfig[n] = new TileTEBase.SideConfig();
        TileMachineBase.defaultSideConfig[n].numConfig = 4;
        TileMachineBase.defaultSideConfig[n].slotGroups = new int[][]{new int[0], {0}, {2}, {0, 2}};
        TileMachineBase.defaultSideConfig[n].allowInsertionSide = new boolean[]{false, true, false, true};
        TileMachineBase.defaultSideConfig[n].allowExtractionSide = new boolean[]{false, true, true, true};
        TileMachineBase.defaultSideConfig[n].allowInsertionSlot = new boolean[]{true, false, false, false};
        TileMachineBase.defaultSideConfig[n].allowExtractionSlot = new boolean[]{true, false, true, false};
        TileMachineBase.defaultSideConfig[n].sideTex = new int[]{0, 1, 4, 7};
        TileMachineBase.defaultSideConfig[n].defaultSides = new byte[]{1, 1, 2, 2, 2, 2};
        String string = "Machine.Charger";
        int n2 = MathHelper.clamp((int)ThermalExpansion.config.get(string, "BasePower", 8000), (int)100, (int)20000);
        ThermalExpansion.config.set(string, "BasePower", n2);
        TileMachineBase.defaultEnergyConfig[n] = new TileTEBase.EnergyConfig();
        TileMachineBase.defaultEnergyConfig[n].setParams(1, n2, Math.max(400000, n2 * 50));
        RATE = new int[4];
        TileCharger.RATE[0] = n2;
        TileCharger.RATE[1] = n2 * 2;
        TileCharger.RATE[2] = n2 * 3;
        TileCharger.RATE[3] = n2 * 4;
        GameRegistry.registerTileEntity(TileCharger.class, (String)"thermalexpansion.Charger");
    }

    public TileCharger() {
        super(BlockMachine.Types.CHARGER);
        this.inventory = new ItemStack[4];
    }

    @Override
    public void func_145845_h() {
        if (ServerHelper.isClientWorld((World)((TileEntity)this).field_145850_b)) {
            if (this.inventory[1] == null) {
                this.processRem = 0;
                this.containerItem = null;
            } else if (EnergyHelper.isEnergyContainerItem((ItemStack)this.inventory[1])) {
                this.containerItem = (IEnergyContainerItem)this.inventory[1].func_77973_b();
            }
            return;
        }
        if (this.containerItem == null && EnergyHelper.isEnergyContainerItem((ItemStack)this.inventory[1])) {
            this.updateContainerItem();
        }
        if (this.containerItem != null) {
            boolean bl = this.isActive;
            this.processContainerItem();
            this.updateIfChanged(bl);
            this.chargeEnergy();
        } else {
            super.func_145845_h();
        }
    }

    @Override
    protected int calcEnergy() {
        if (!this.isActive) {
            return 0;
        }
        int n = 0;
        n = this.energyStorage.getEnergyStored() > this.energyConfig.maxPowerLevel ? this.energyConfig.maxPower : (this.energyStorage.getEnergyStored() < this.energyConfig.energyRamp ? this.energyConfig.minPower : this.energyStorage.getEnergyStored() / this.energyConfig.energyRamp);
        return this.containerItem != null ? Math.min(n, this.containerItem.receiveEnergy(this.inventory[1], n, true)) : n;
    }

    @Override
    protected int getMaxInputSlot() {
        return -1;
    }

    @Override
    protected boolean canStart() {
        ChargerManager.RecipeCharger recipeCharger;
        if (this.inventory[0] == null) {
            return false;
        }
        if (EnergyHelper.isEnergyContainerItem((ItemStack)this.inventory[0])) {
            this.inventory[1] = ItemHelper.cloneStack((ItemStack)this.inventory[0], (int)1);
            --this.inventory[0].field_77994_a;
            if (this.inventory[0].field_77994_a <= 0) {
                this.inventory[0] = null;
            }
        }
        if ((recipeCharger = ChargerManager.getRecipe(this.inventory[0])) == null || this.energyStorage.getEnergyStored() < recipeCharger.getEnergy()) {
            return false;
        }
        if (this.inventory[0].field_77994_a < recipeCharger.getInput().field_77994_a) {
            return false;
        }
        ItemStack itemStack = recipeCharger.getOutput();
        if (this.inventory[2] == null) {
            return true;
        }
        if (!this.inventory[2].func_77969_a(itemStack)) {
            return false;
        }
        return this.inventory[2].field_77994_a + itemStack.field_77994_a <= itemStack.func_77976_d();
    }

    @Override
    protected boolean hasValidInput() {
        if (this.containerItem != null) {
            return true;
        }
        ChargerManager.RecipeCharger recipeCharger = ChargerManager.getRecipe(this.inventory[1]);
        return recipeCharger == null ? false : recipeCharger.getInput().field_77994_a <= this.inventory[1].field_77994_a;
    }

    @Override
    protected void processStart() {
        ChargerManager.RecipeCharger recipeCharger = ChargerManager.getRecipe(this.inventory[0]);
        this.processRem = this.processMax = recipeCharger.getEnergy();
        this.inventory[1] = ItemHelper.cloneStack((ItemStack)this.inventory[0], (int)recipeCharger.getInput().field_77994_a);
        this.inventory[0].field_77994_a -= recipeCharger.getInput().field_77994_a;
        if (this.inventory[0].field_77994_a <= 0) {
            this.inventory[0] = null;
        }
    }

    @Override
    protected void processFinish() {
        ChargerManager.RecipeCharger recipeCharger = ChargerManager.getRecipe(this.inventory[1]);
        if (recipeCharger == null) {
            this.isActive = false;
            this.wasActive = true;
            this.tracker.markTime(((TileEntity)this).field_145850_b);
            this.processRem = 0;
            return;
        }
        ItemStack itemStack = recipeCharger.getOutput();
        if (this.inventory[2] == null) {
            this.inventory[2] = itemStack;
        } else {
            this.inventory[2].field_77994_a += itemStack.field_77994_a;
        }
        this.inventory[1] = null;
    }

    @Override
    protected void transferInput() {
        if (!this.augmentAutoInput) {
            return;
        }
        for (int i = this.inputTracker + 1; i <= this.inputTracker + 6; ++i) {
            int n = i % 6;
            if (this.sideCache[n] != 1 || !this.extractItem(0, TileMachineBase.AUTO_TRANSFER[this.level], n)) continue;
            this.inputTracker = n;
            break;
        }
    }

    @Override
    protected void transferOutput() {
        if (!this.augmentAutoOutput) {
            return;
        }
        if (this.containerItem != null) {
            if (this.inventory[2] == null) {
                this.inventory[2] = ItemHelper.cloneStack((ItemStack)this.inventory[1], (int)1);
                this.inventory[1] = null;
                this.containerItem = null;
            } else if (this.inventory[1].func_77976_d() > 1 && ItemHelper.itemsIdentical((ItemStack)this.inventory[1], (ItemStack)this.inventory[2]) && this.inventory[2].field_77994_a + 1 <= this.inventory[2].func_77976_d()) {
                ++this.inventory[2].field_77994_a;
                this.inventory[1] = null;
                this.containerItem = null;
            }
        }
        if (this.containerItem == null && EnergyHelper.isEnergyContainerItem((ItemStack)this.inventory[0])) {
            this.inventory[1] = ItemHelper.cloneStack((ItemStack)this.inventory[0], (int)1);
            --this.inventory[0].field_77994_a;
            if (this.inventory[0].field_77994_a <= 0) {
                this.inventory[0] = null;
            }
        }
        for (int i = this.outputTracker + 1; i <= this.outputTracker + 6; ++i) {
            int n = i % 6;
            if (this.sideCache[n] != 2 || !this.transferItem(2, TileMachineBase.AUTO_TRANSFER[this.level], n)) continue;
            this.outputTracker = n;
            break;
        }
    }

    @Override
    protected void onLevelChange() {
        super.onLevelChange();
    }

    protected void processContainerItem() {
        if (this.isActive) {
            this.updateContainerCharge();
            if (!this.redstoneControlOrDisable()) {
                this.isActive = false;
                this.wasActive = true;
                this.tracker.markTime(((TileEntity)this).field_145850_b);
            } else if (this.containerItem == null) {
                if (EnergyHelper.isEnergyContainerItem((ItemStack)this.inventory[1])) {
                    this.updateContainerItem();
                    this.isActive = true;
                } else {
                    this.isActive = false;
                    this.wasActive = true;
                    this.tracker.markTime(((TileEntity)this).field_145850_b);
                }
            }
        } else if (this.redstoneControlOrDisable()) {
            if (this.timeCheck()) {
                this.transferOutput();
            }
            if (this.containerItem == null && EnergyHelper.isEnergyContainerItem((ItemStack)this.inventory[1])) {
                this.updateContainerItem();
            }
            if (this.containerItem != null) {
                this.isActive = true;
            }
        }
    }

    protected void updateContainerItem() {
        this.containerItem = (IEnergyContainerItem)this.inventory[1].func_77973_b();
        if (this.containerItem != null) {
            this.processMax = this.containerItem.getMaxEnergyStored(this.inventory[1]);
            this.processRem = this.processMax - this.containerItem.getEnergyStored(this.inventory[1]);
        }
    }

    protected void updateContainerCharge() {
        int n = Math.min(this.energyStorage.getEnergyStored(), this.calcEnergy());
        int n2 = this.energyStorage.extractEnergy(this.containerItem.receiveEnergy(this.inventory[1], n, false), false);
        this.processRem -= n2;
        if (this.processRem <= 0) {
            this.transferOutput();
            if (!this.redstoneControlOrDisable()) {
                this.isActive = false;
                this.wasActive = true;
                this.tracker.markTime(((TileEntity)this).field_145850_b);
            }
        }
    }

    public Object getGuiClient(InventoryPlayer inventoryPlayer) {
        return new GuiCharger(inventoryPlayer, (TileEntity)this);
    }

    public Object getGuiServer(InventoryPlayer inventoryPlayer) {
        return new ContainerCharger(inventoryPlayer, (TileEntity)this);
    }

    @Override
    public void func_145839_a(NBTTagCompound nBTTagCompound) {
        super.func_145839_a(nBTTagCompound);
        this.inputTracker = nBTTagCompound.func_74762_e("TrackIn");
        this.outputTracker = nBTTagCompound.func_74762_e("TrackOut");
    }

    @Override
    public void func_145841_b(NBTTagCompound nBTTagCompound) {
        super.func_145841_b(nBTTagCompound);
        nBTTagCompound.func_74768_a("TrackIn", this.inputTracker);
        nBTTagCompound.func_74768_a("TrackOut", this.outputTracker);
    }

    @Override
    public ItemStack func_70298_a(int n, int n2) {
        ItemStack itemStack = super.func_70298_a(n, n2);
        if (ServerHelper.isServerWorld((World)((TileEntity)this).field_145850_b) && n == 1 && this.isActive && (this.inventory[n] == null || !this.hasValidInput())) {
            this.isActive = false;
            this.wasActive = true;
            this.tracker.markTime(((TileEntity)this).field_145850_b);
            this.processRem = 0;
            this.containerItem = null;
        }
        return itemStack;
    }

    @Override
    public void func_70299_a(int n, ItemStack itemStack) {
        if (ServerHelper.isServerWorld((World)((TileEntity)this).field_145850_b) && n == 1) {
            if (!(!this.isActive || this.inventory[n] == null || itemStack != null && itemStack.func_77969_a(this.inventory[n]) && this.hasValidInput())) {
                this.isActive = false;
                this.wasActive = true;
                this.tracker.markTime(((TileEntity)this).field_145850_b);
                this.processRem = 0;
            }
            this.containerItem = null;
        }
        this.inventory[n] = itemStack;
        if (itemStack != null && itemStack.field_77994_a > this.func_70297_j_()) {
            itemStack.field_77994_a = this.func_70297_j_();
        }
    }

    @Override
    public void func_70296_d() {
        if (this.isActive && !this.hasValidInput()) {
            this.containerItem = null;
        }
        super.func_70296_d();
    }

    @Override
    public boolean func_94041_b(int n, ItemStack itemStack) {
        return n == 0 ? EnergyHelper.isEnergyContainerItem((ItemStack)itemStack) || ChargerManager.recipeExists(itemStack) : true;
    }

    @Override
    public int getInfoEnergyPerTick() {
        return this.calcEnergy();
    }

    @Override
    public int getInfoMaxEnergyPerTick() {
        return this.energyConfig.maxPower;
    }
}

