/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.plate;

import cofh.core.RegistrySocial;
import cofh.core.network.PacketCoFHBase;
import cofh.lib.util.helpers.EnergyHelper;
import cofh.thermalexpansion.block.plate.BlockPlate;
import cofh.thermalexpansion.block.plate.TilePlatePoweredBase;
import cofh.thermalexpansion.gui.client.plate.GuiPlateCharge;
import cofh.thermalexpansion.gui.container.ContainerTEBase;
import com.mojang.authlib.GameProfile;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;

public class TilePlateCharge
extends TilePlatePoweredBase {
    protected static final int CHARGE_RATE = 1000;
    protected long worldTime;
    protected int chargeLeft;
    public boolean chargeItems = true;

    public static void initialize() {
        GameRegistry.registerTileEntity(TilePlateCharge.class, (String)"cofh.thermalexpansion.PlateCharger");
    }

    public TilePlateCharge() {
        super(BlockPlate.Types.CHARGE, 80000);
        this.storage.setMaxTransfer(1000);
        this.filterSecure = true;
    }

    @Override
    public void onEntityCollidedWithBlock(Entity entity) {
        GameProfile gameProfile;
        Object object;
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        Class<EntityLivingBase> clazz = EntityLivingBase.class;
        if (!this.getAccess().isPublic()) {
            clazz = EntityPlayer.class;
        }
        if (!(clazz.isInstance(entity) || this.chargeItems && entity instanceof EntityItem)) {
            return;
        }
        if (this.worldTime != entity.field_70170_p.func_82737_E()) {
            this.worldTime = entity.field_70170_p.func_82737_E();
            this.chargeLeft = Math.min(1000, this.storage.getEnergyStored());
        }
        if (this.chargeLeft <= 0) {
            return;
        }
        if (this.filterSecure && !this.getAccess().isPublic() && !(entity instanceof EntityItem ? (object = ((EntityItem)entity).func_145800_j()) != null && (this.getAccess().isRestricted() && RegistrySocial.playerHasAccess((String)object, (GameProfile)this.getOwner()) || (gameProfile = MinecraftServer.func_71276_C().func_152358_ax().func_152655_a((String)object)) != null && this.getOwner().getId().equals(gameProfile.getId())) : this.canPlayerAccess((EntityPlayer)entity))) {
            return;
        }
        if (entity instanceof EntityItem) {
            object = ((EntityItem)entity).func_92059_d();
            if (this.chargeItem((ItemStack)object)) {
                ((EntityItem)entity).field_70292_b = 0;
            }
            ((EntityItem)entity).func_92058_a(object);
        } else {
            for (int i = 0; i < 5; ++i) {
                this.chargeItem(((EntityLivingBase)entity).func_71124_b(i));
            }
        }
    }

    protected boolean chargeItem(ItemStack itemStack) {
        int n = EnergyHelper.insertEnergyIntoContainer((ItemStack)itemStack, (int)this.chargeLeft, (boolean)false);
        this.chargeLeft -= this.storage.extractEnergy(n, false);
        return n > 0;
    }

    public Object getGuiClient(InventoryPlayer inventoryPlayer) {
        return new GuiPlateCharge(inventoryPlayer, (TileEntity)this);
    }

    public ContainerTEBase getGuiServer(InventoryPlayer inventoryPlayer) {
        return new ContainerTEBase(inventoryPlayer, (TileEntity)this, false, false);
    }

    @Override
    public void func_145839_a(NBTTagCompound nBTTagCompound) {
        super.func_145839_a(nBTTagCompound);
        this.chargeItems = nBTTagCompound.func_74767_n("chargeItems");
        if (!nBTTagCompound.func_74764_b("FilterSecure")) {
            this.filterSecure = true;
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nBTTagCompound) {
        super.func_145841_b(nBTTagCompound);
        nBTTagCompound.func_74757_a("chargeItems", this.chargeItems);
    }

    @Override
    public PacketCoFHBase getPacket() {
        PacketCoFHBase packetCoFHBase = super.getPacket();
        packetCoFHBase.addBool(this.chargeItems);
        return packetCoFHBase;
    }

    @Override
    public PacketCoFHBase getGuiPacket() {
        PacketCoFHBase packetCoFHBase = super.getGuiPacket();
        packetCoFHBase.addBool(this.chargeItems);
        return packetCoFHBase;
    }

    @Override
    public PacketCoFHBase getModePacket() {
        PacketCoFHBase packetCoFHBase = super.getModePacket();
        packetCoFHBase.addBool(this.chargeItems);
        return packetCoFHBase;
    }

    @Override
    protected void handleGuiPacket(PacketCoFHBase packetCoFHBase) {
        super.handleGuiPacket(packetCoFHBase);
        this.chargeItems = packetCoFHBase.getBool();
    }

    @Override
    protected void handleModePacket(PacketCoFHBase packetCoFHBase) {
        super.handleModePacket(packetCoFHBase);
        this.chargeItems = packetCoFHBase.getBool();
        this.sendDescPacket();
    }

    @Override
    public void handleTilePacket(PacketCoFHBase packetCoFHBase, boolean bl) {
        super.handleTilePacket(packetCoFHBase, bl);
        if (!bl) {
            this.chargeItems = packetCoFHBase.getBool();
        } else {
            packetCoFHBase.getBool();
        }
    }
}

