/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.gui.container;

import cofh.api.core.ICustomInventory;
import cofh.lib.gui.container.CustomInventoryWrapper;
import cofh.lib.gui.slot.SlotFalseCopy;
import cofh.lib.inventory.InventoryCraftingCustom;
import cofh.lib.util.helpers.ItemHelper;
import cofh.lib.util.helpers.ServerHelper;
import cofh.thermalexpansion.block.workbench.TileWorkbench;
import cofh.thermalexpansion.gui.container.ContainerTEBase;
import cofh.thermalexpansion.gui.container.ISchematicContainer;
import cofh.thermalexpansion.gui.slot.SlotCraftingOutputWorkbench;
import cofh.thermalexpansion.gui.slot.SlotSpecificItemWorkbench;
import cofh.thermalexpansion.item.TEItems;
import cofh.thermalexpansion.util.helpers.SchematicHelper;
import cpw.mods.fml.common.Optional;
import gnu.trove.map.hash.THashMap;
import invtweaks.api.container.ChestContainer;
import invtweaks.api.container.ContainerSection;
import invtweaks.api.container.ContainerSectionCallback;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class ContainerWorkbench
extends ContainerTEBase
implements ISchematicContainer {
    TileWorkbench myTile;
    IInventory craftResult = new InventoryCraftResult();
    int type = 1;
    int numSchematic = 3;
    int numInventory = 18;
    int rowSize = 9;
    public InventoryCraftingCustom craftMatrix;
    public SlotCraftingOutputWorkbench myOutput;

    public ContainerWorkbench(InventoryPlayer inventoryPlayer, TileEntity tileEntity) {
        super(tileEntity);
        this.myTile = (TileWorkbench)tileEntity;
        this.type = this.myTile.getType();
        this.numSchematic = TileWorkbench.SCHEMATICS[this.type];
        this.numInventory = TileWorkbench.INVENTORY[this.type];
        int n = 44;
        switch (this.type) {
            case 1: {
                this.addPlayerSlotsToContainer(inventoryPlayer, 8, 128);
                this.addSchematicSlotsToContainer(17, 18, 3, 1);
                this.addInventorySlotsToContainer(this.myTile, 8, 79, 2, 9);
                this.myOutput = new SlotCraftingOutputWorkbench(this.myTile, this, inventoryPlayer.field_70458_d, this.craftResult, 0, 143, 37);
                this.rowSize = 9;
                break;
            }
            case 2: {
                this.addPlayerSlotsToContainer(inventoryPlayer, 8, 146);
                this.addSchematicSlotsToContainer(10, 18, 3, 2);
                this.addInventorySlotsToContainer(this.myTile, 8, 79, 3, 9);
                this.myOutput = new SlotCraftingOutputWorkbench(this.myTile, this, inventoryPlayer.field_70458_d, this.craftResult, 0, 143, 37);
                this.rowSize = 9;
                n = 54;
                break;
            }
            case 3: {
                this.addPlayerSlotsToContainer(inventoryPlayer, 26, 146);
                this.addSchematicSlotsToContainer(16, 18, 3, 3);
                this.addInventorySlotsToContainer(this.myTile, 8, 79, 3, 11);
                this.myOutput = new SlotCraftingOutputWorkbench(this.myTile, this, inventoryPlayer.field_70458_d, this.craftResult, 0, 179, 37);
                this.rowSize = 11;
                n = 80;
                break;
            }
            default: {
                this.addPlayerSlotsToContainer(inventoryPlayer, 35, 146);
                this.addSchematicSlotsToContainer(16, 18, 3, 4);
                this.addInventorySlotsToContainer(this.myTile, 8, 79, 3, 12);
                this.myOutput = new SlotCraftingOutputWorkbench(this.myTile, this, inventoryPlayer.field_70458_d, this.craftResult, 0, 197, 37);
                this.rowSize = 13;
                n = 98;
            }
        }
        this.craftMatrix = new InventoryCraftingCustom((Container)this, 3, 3, (IInventory)new CustomInventoryWrapper((ICustomInventory)this.myTile, 0), 0);
        this.func_75146_a(this.myOutput);
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.func_75146_a((Slot)new SlotFalseCopy((IInventory)this.craftMatrix, j + i * 3, n + j * 18, 19 + i * 18));
            }
        }
        this.func_75130_a(null);
    }

    private void addPlayerSlotsToContainer(InventoryPlayer inventoryPlayer, int n, int n2) {
        int n3;
        for (n3 = 0; n3 < 3; ++n3) {
            for (int i = 0; i < 9; ++i) {
                this.func_75146_a(new Slot((IInventory)inventoryPlayer, i + n3 * 9 + 9, n + i * 18, n2 + n3 * 18));
            }
        }
        for (n3 = 0; n3 < 9; ++n3) {
            this.func_75146_a(new Slot((IInventory)inventoryPlayer, n3, n + n3 * 18, n2 + 58));
        }
    }

    private void addInventorySlotsToContainer(IInventory iInventory, int n, int n2, int n3, int n4) {
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n4; ++j) {
                this.func_75146_a(new Slot(iInventory, this.numSchematic + j + i * n4, n + j * 18, n2 + i * 18));
            }
        }
    }

    private void addSchematicSlotsToContainer(int n, int n2, int n3, int n4) {
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n4; ++j) {
                this.func_75146_a((Slot)new SlotSpecificItemWorkbench(this.myTile, j + i * n4, n + j * 19, n2 + i * 19, TEItems.diagramSchematic).setSlotStackLimit(1));
            }
        }
    }

    public void func_75130_a(IInventory iInventory) {
        this.craftResult.func_70299_a(0, ItemHelper.findMatchingRecipe((InventoryCrafting)this.craftMatrix, (World)this.myTile.func_145831_w()));
    }

    public ItemStack func_75144_a(int n, int n2, int n3, EntityPlayer entityPlayer) {
        Slot slot;
        this.myTile.updateClient = true;
        int n4 = 36;
        int n5 = n4 + this.numSchematic;
        int n6 = n5 + this.numInventory;
        if (n == n6) {
            n3 = 0;
        }
        if (n >= n4 && n < n5 && (slot = (Slot)((Container)this).field_75151_b.get(n)).func_75216_d()) {
            int n7 = this.myTile.getCurrentSchematicSlot();
            this.myTile.setCurrentSchematicSlot(slot.getSlotIndex());
            if (n2 == 1 && n3 == 1) {
                this.myTile.setCraftingGrid();
                n3 = 0;
                n = n6;
            } else if (n7 != this.myTile.getCurrentSchematicSlot()) {
                return entityPlayer.field_71071_by.func_70445_o();
            }
        }
        if (ServerHelper.isClientWorld((World)entityPlayer.field_70170_p)) {
            slot = super.func_75144_a(n, n2, n3, entityPlayer);
            if (n >= n5 && n < n6) {
                this.myTile.createItemClient(false, this.myOutput.getStackNoUpdate());
            }
            return slot;
        }
        return super.func_75144_a(n, n2, n3, entityPlayer);
    }

    public boolean hasSchematic() {
        return SchematicHelper.isSchematic(this.myTile.func_70301_a(this.myTile.getCurrentSchematicSlot()));
    }

    @Override
    public void writeSchematic() {
        ItemStack itemStack = this.myTile.func_70301_a(this.myTile.selectedSchematic);
        if (itemStack != null && this.craftResult.func_70301_a(0) != null) {
            ItemStack itemStack2 = SchematicHelper.writeNBTToSchematic(itemStack, SchematicHelper.getNBTForSchematic((InventoryCrafting)this.craftMatrix, this.myTile.func_145831_w(), this.craftResult.func_70301_a(0)));
            itemStack2.field_77994_a = itemStack.field_77994_a;
            this.myTile.func_70299_a(this.myTile.selectedSchematic, itemStack2);
        }
    }

    @Override
    public boolean canWriteSchematic() {
        return this.hasSchematic() && this.craftResult.func_70301_a(0) != null;
    }

    @Override
    public Slot[] getCraftingSlots() {
        return null;
    }

    @Override
    public Slot getResultSlot() {
        return null;
    }

    @Optional.Method(modid="inventorytweaks")
    @ChestContainer.RowSizeCallback
    public int getRowSize() {
        return this.rowSize;
    }

    @ContainerSectionCallback
    @Optional.Method(modid="inventorytweaks")
    public Map<ContainerSection, List<Slot>> getContainerSections() {
        THashMap tHashMap = new THashMap();
        tHashMap.put(ContainerSection.INVENTORY, ((Container)this).field_75151_b.subList(0, 36));
        tHashMap.put(ContainerSection.INVENTORY_NOT_HOTBAR, ((Container)this).field_75151_b.subList(0, 27));
        tHashMap.put(ContainerSection.INVENTORY_HOTBAR, ((Container)this).field_75151_b.subList(27, 36));
        tHashMap.put(ContainerSection.CHEST, ((Container)this).field_75151_b.subList(36, 36 + this.numInventory));
        return tHashMap;
    }
}

