/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.render.transformation;

import cofh.repack.codechicken.lib.vec.Matrix4;
import cofh.repack.codechicken.lib.vec.RedundantTransformation;
import cofh.repack.codechicken.lib.vec.Transformation;
import cofh.repack.codechicken.lib.vec.Vector3;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;

public class TorchTransformation
extends Transformation {
    public static Transformation[] sideTransformations = new Transformation[]{new RedundantTransformation(), new TorchTransformation(1), new TorchTransformation(2), new TorchTransformation(3), new TorchTransformation(4), new TorchTransformation(5)};
    int alignment;

    public TorchTransformation(int n) {
        this.alignment = n;
    }

    public void apply(Matrix4 matrix4) {
    }

    public void applyN(Vector3 vector3) {
        this.apply(vector3);
    }

    public void apply(Vector3 vector3) {
        if (this.alignment > 1 && this.alignment < 6) {
            double d = 0.25;
            if (vector3.y <= 0.5) {
                d += 0.25;
            }
            switch (this.alignment) {
                case 2: {
                    vector3.z -= d;
                    break;
                }
                case 3: {
                    vector3.z += d;
                    break;
                }
                case 4: {
                    vector3.x -= d;
                    break;
                }
                case 5: {
                    vector3.x += d;
                }
            }
            vector3.y += 0.1875;
        } else if (this.alignment == 1) {
            vector3.y = 0.5 - vector3.y + 0.5;
            vector3.z = 0.5 - vector3.z + 0.5;
        }
    }

    public Transformation merge(Transformation transformation) {
        if (transformation.getClass() == TorchTransformation.class) {
            TorchTransformation torchTransformation = (TorchTransformation)transformation;
            if ((torchTransformation.alignment ^ 1) == this.alignment) {
                return sideTransformations[0];
            }
        }
        return this.isRedundant() ? transformation : null;
    }

    public Transformation inverse() {
        return new TorchTransformation(this.alignment ^ 1);
    }

    public boolean isRedundant() {
        return this.alignment <= 0 || this.alignment >= 6;
    }

    @SideOnly(value=Side.CLIENT)
    public void glApply() {
    }
}

