/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.container;

import cofh.api.item.IToolHammer;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import mcjty.lib.api.Infusable;
import mcjty.lib.base.GeneralConfig;
import mcjty.lib.base.ModBase;
import mcjty.lib.compat.waila.WailaInfoProvider;
import mcjty.lib.container.EmptyContainer;
import mcjty.lib.container.WrenchUsage;
import mcjty.lib.entity.GenericTileEntity;
import mcjty.lib.varia.BlockTools;
import mcjty.lib.varia.WrenchChecker;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.input.Keyboard;

public abstract class GenericBlock
extends Block
implements ITileEntityProvider,
WailaInfoProvider {
    protected ModBase modBase;
    protected IIcon iconInd;
    protected IIcon iconSide;
    protected IIcon iconTop;
    protected IIcon iconBottom;
    protected final Class<? extends TileEntity> tileEntityClass;
    private boolean creative;
    private boolean horizRotation = false;

    public GenericBlock(ModBase mod, Material material, Class<? extends TileEntity> tileEntityClass, boolean isContainer) {
        super(material);
        this.modBase = mod;
        this.field_149758_A = isContainer;
        this.creative = false;
        this.tileEntityClass = tileEntityClass;
        this.func_149711_c(2.0f);
        this.func_149672_a(field_149777_j);
        this.setHarvestLevel("pickaxe", 0);
    }

    public boolean isHorizRotation() {
        return this.horizRotation;
    }

    public void setHorizRotation(boolean horizRotation) {
        this.horizRotation = horizRotation;
    }

    public boolean isCreative() {
        return this.creative;
    }

    public void setCreative(boolean creative) {
        this.creative = creative;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        Block block = accessor.getBlock();
        TileEntity tileEntity = accessor.getTileEntity();
        if (tileEntity instanceof GenericTileEntity) {
            GenericTileEntity genericTileEntity = (GenericTileEntity)tileEntity;
            if (block instanceof Infusable) {
                int infused = genericTileEntity.getInfused();
                int pct = infused * 100 / GeneralConfig.maxInfuse;
                currenttip.add(EnumChatFormatting.YELLOW + "Infused: " + pct + "%");
            }
            if ((Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) && GeneralConfig.manageOwnership && genericTileEntity.getOwnerName() != null && !genericTileEntity.getOwnerName().isEmpty()) {
                int securityChannel = genericTileEntity.getSecurityChannel();
                if (securityChannel == -1) {
                    currenttip.add(EnumChatFormatting.YELLOW + "Owned by: " + genericTileEntity.getOwnerName());
                } else {
                    currenttip.add(EnumChatFormatting.YELLOW + "Owned by: " + genericTileEntity.getOwnerName() + " (channel " + securityChannel + ")");
                }
                if (genericTileEntity.getOwnerUUID() == null) {
                    currenttip.add(EnumChatFormatting.RED + "Warning! Ownership not correctly set! Please place block again!");
                }
            }
        }
        return currenttip;
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack itemStack, EntityPlayer player, List list, boolean whatIsThis) {
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound != null) {
            if (tagCompound.func_74764_b("Energy")) {
                int energy = tagCompound.func_74762_e("Energy");
                list.add(EnumChatFormatting.GREEN + "Energy: " + energy + " rf");
            }
            if (this instanceof Infusable) {
                int infused = tagCompound.func_74762_e("infused");
                int pct = infused * 100 / GeneralConfig.maxInfuse;
                list.add(EnumChatFormatting.YELLOW + "Infused: " + pct + "%");
            }
            if (GeneralConfig.manageOwnership && tagCompound.func_74764_b("owner")) {
                String owner = tagCompound.func_74779_i("owner");
                int securityChannel = -1;
                if (tagCompound.func_74764_b("secChannel")) {
                    securityChannel = tagCompound.func_74762_e("secChannel");
                }
                if (securityChannel == -1) {
                    list.add(EnumChatFormatting.YELLOW + "Owned by: " + owner);
                } else {
                    list.add(EnumChatFormatting.YELLOW + "Owned by: " + owner + " (channel " + securityChannel + ")");
                }
                if (!tagCompound.func_74764_b("idM")) {
                    list.add(EnumChatFormatting.RED + "Warning! Ownership not correctly set! Please place block again!");
                }
            }
        }
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity instanceof GenericTileEntity) {
            ItemStack stack = new ItemStack(Item.func_150898_a((Block)this));
            NBTTagCompound tagCompound = new NBTTagCompound();
            ((GenericTileEntity)tileEntity).writeRestorableToNBT(tagCompound);
            stack.func_77982_d(tagCompound);
            ArrayList<ItemStack> result = new ArrayList<ItemStack>();
            result.add(stack);
            return result;
        }
        return super.getDrops(world, x, y, z, metadata, fortune);
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z, boolean willHarvest) {
        if (willHarvest) {
            return true;
        }
        return super.removedByPlayer(world, player, x, y, z, willHarvest);
    }

    public void func_149636_a(World world, EntityPlayer player, int x, int y, int z, int meta) {
        super.func_149636_a(world, player, x, y, z, meta);
        world.func_147468_f(x, y, z);
    }

    public TileEntity func_149915_a(World world, int i) {
        return null;
    }

    public TileEntity createTileEntity(World world, int metadata) {
        try {
            return this.tileEntityClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private WrenchUsage testWrenchUsage(int x, int y, int z, EntityPlayer player) {
        Item item;
        ItemStack itemStack = player.func_70694_bm();
        WrenchUsage wrenchUsed = WrenchUsage.NOT;
        if (itemStack != null && (item = itemStack.func_77973_b()) != null) {
            wrenchUsed = this.getWrenchUsage(x, y, z, player, itemStack, wrenchUsed, item);
        }
        if (wrenchUsed == WrenchUsage.NORMAL && player.func_70093_af()) {
            wrenchUsed = WrenchUsage.SNEAKING;
        }
        return wrenchUsed;
    }

    protected WrenchUsage getWrenchUsage(int x, int y, int z, EntityPlayer player, ItemStack itemStack, WrenchUsage wrenchUsed, Item item) {
        if (item instanceof IToolHammer) {
            IToolHammer hammer = (IToolHammer)item;
            if (hammer.isUsable(itemStack, (EntityLivingBase)player, x, y, z)) {
                hammer.toolUsed(itemStack, (EntityLivingBase)player, x, y, z);
                wrenchUsed = WrenchUsage.NORMAL;
            } else {
                wrenchUsed = WrenchUsage.DISABLED;
            }
        } else if (WrenchChecker.isAWrench(item)) {
            wrenchUsed = WrenchUsage.NORMAL;
        }
        return wrenchUsed;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float sidex, float sidey, float sidez) {
        WrenchUsage wrenchUsed = this.testWrenchUsage(x, y, z, player);
        switch (wrenchUsed) {
            case NOT: {
                return this.openGui(world, x, y, z, player);
            }
            case NORMAL: {
                return this.wrenchUse(world, x, y, z, player);
            }
            case SNEAKING: {
                return this.wrenchSneak(world, x, y, z, player);
            }
            case DISABLED: {
                return this.wrenchDisabled(world, x, y, z, player);
            }
            case SELECT: {
                return this.wrenchSelect(world, x, y, z, player);
            }
            case SNEAK_SELECT: {
                return this.wrenchSneakSelect(world, x, y, z, player);
            }
        }
        return false;
    }

    protected boolean wrenchUse(World world, int x, int y, int z, EntityPlayer player) {
        this.rotateBlock(world, x, y, z);
        return true;
    }

    protected boolean wrenchSneak(World world, int x, int y, int z, EntityPlayer player) {
        this.breakAndRemember(world, player, x, y, z);
        return true;
    }

    protected boolean wrenchDisabled(World world, int x, int y, int z, EntityPlayer player) {
        return false;
    }

    protected boolean wrenchSelect(World world, int x, int y, int z, EntityPlayer player) {
        return false;
    }

    protected boolean wrenchSneakSelect(World world, int x, int y, int z, EntityPlayer player) {
        return false;
    }

    protected boolean openGui(World world, int x, int y, int z, EntityPlayer player) {
        if (this.getGuiID() != -1) {
            if (world.field_72995_K) {
                return true;
            }
            TileEntity te = world.func_147438_o(x, y, z);
            if (this.field_149758_A && !this.tileEntityClass.isInstance(te)) {
                return false;
            }
            if (this.checkAccess(world, player, te)) {
                return true;
            }
            player.openGui((Object)this.modBase, this.getGuiID(), world, x, y, z);
            return true;
        }
        return false;
    }

    protected boolean checkAccess(World world, EntityPlayer player, TileEntity te) {
        return false;
    }

    protected ForgeDirection getOrientation(int x, int y, int z, EntityLivingBase entityLivingBase) {
        if (this.horizRotation) {
            return BlockTools.determineOrientationHoriz(entityLivingBase);
        }
        return BlockTools.determineOrientation(x, y, z, entityLivingBase);
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entityLivingBase, ItemStack itemStack) {
        ForgeDirection dir = this.getOrientation(x, y, z, entityLivingBase);
        int meta = world.func_72805_g(x, y, z);
        if (this.horizRotation) {
            int power = world.func_72879_k(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ, dir.ordinal());
            meta = BlockTools.setRedstoneSignalIn(meta, power > 0);
            world.func_72921_c(x, y, z, BlockTools.setOrientationHoriz(meta, dir), 2);
        } else {
            world.func_72921_c(x, y, z, BlockTools.setOrientation(meta, dir), 2);
        }
        this.restoreBlockFromNBT(world, x, y, z, itemStack);
        if (!world.field_72995_K && GeneralConfig.manageOwnership) {
            this.setOwner(world, x, y, z, entityLivingBase);
        }
    }

    protected void setOwner(World world, int x, int y, int z, EntityLivingBase entityLivingBase) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof GenericTileEntity && entityLivingBase instanceof EntityPlayer) {
            GenericTileEntity genericTileEntity = (GenericTileEntity)te;
            EntityPlayer player = (EntityPlayer)entityLivingBase;
            genericTileEntity.setOwner(player);
        }
    }

    protected void rotateBlock(World world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        if (this.horizRotation) {
            ForgeDirection dir = BlockTools.getOrientationHoriz(meta);
            dir = dir.getRotation(ForgeDirection.UP);
            world.func_72921_c(x, y, z, BlockTools.setOrientationHoriz(meta, dir), 2);
        } else {
            ForgeDirection dir = BlockTools.getOrientation(meta);
            dir = dir.getRotation(ForgeDirection.UP);
            world.func_72921_c(x, y, z, BlockTools.setOrientation(meta, dir), 2);
        }
    }

    public boolean shouldCheckWeakPower(IBlockAccess world, int x, int y, int z, int side) {
        return false;
    }

    protected void checkRedstone(World world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        int powered = world.func_94577_B(x, y, z);
        meta = this.horizRotation ? BlockTools.setRedstoneSignalIn(meta, powered > 0) : BlockTools.setRedstoneSignal(meta, powered > 0);
        world.func_72921_c(x, y, z, meta, 2);
    }

    protected void checkRedstoneWithTE(World world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof GenericTileEntity) {
            int powered = world.func_94577_B(x, y, z);
            GenericTileEntity genericTileEntity = (GenericTileEntity)te;
            genericTileEntity.setPowered(powered);
        }
    }

    protected void breakAndRemember(World world, EntityPlayer player, int x, int y, int z) {
        if (!world.field_72995_K) {
            this.func_149636_a(world, player, x, y, z, world.func_72805_g(x, y, z));
        }
    }

    protected void restoreBlockFromNBT(World world, int x, int y, int z, ItemStack itemStack) {
        TileEntity te;
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound != null && (te = world.func_147438_o(x, y, z)) instanceof GenericTileEntity) {
            ((GenericTileEntity)te).readRestorableFromNBT(tagCompound);
        }
    }

    public void func_149651_a(IIconRegister iconRegister) {
        if (this.getIdentifyingIconName() != null) {
            this.iconInd = iconRegister.func_94245_a(this.modBase.getModId() + ":" + this.getIdentifyingIconName());
        }
        this.iconSide = iconRegister.func_94245_a(this.modBase.getModId() + ":" + this.getSideIconName());
        this.iconTop = iconRegister.func_94245_a(this.modBase.getModId() + ":" + this.getTopIconName());
        this.iconBottom = iconRegister.func_94245_a(this.modBase.getModId() + ":" + this.getBottomIconName());
    }

    public String getSideIconName() {
        if (this.creative) {
            return "machineSideC";
        }
        return "machineSide";
    }

    public String getTopIconName() {
        if (this.creative) {
            return "machineSideC";
        }
        return "machineTop";
    }

    public String getBottomIconName() {
        if (this.creative) {
            return "machineSideC";
        }
        return "machineBottom";
    }

    public String getIdentifyingIconName() {
        return null;
    }

    public abstract int getGuiID();

    public Container createServerContainer(EntityPlayer entityPlayer, TileEntity tileEntity) {
        return new EmptyContainer(entityPlayer);
    }

    @SideOnly(value=Side.CLIENT)
    public GuiContainer createClientGui(EntityPlayer entityPlayer, TileEntity tileEntity) {
        return null;
    }

    public IIcon func_149673_e(IBlockAccess blockAccess, int x, int y, int z, int side) {
        int meta = blockAccess.func_72805_g(x, y, z);
        ForgeDirection k = this.getOrientation(meta);
        if (this.iconInd != null && side == k.ordinal()) {
            return this.getIconInd(blockAccess, x, y, z, meta);
        }
        if (this.iconTop != null && side == BlockTools.getTopDirection(k).ordinal()) {
            return this.iconTop;
        }
        if (this.iconBottom != null && side == BlockTools.getBottomDirection(k).ordinal()) {
            return this.iconBottom;
        }
        return this.iconSide;
    }

    public ForgeDirection getOrientation(int meta) {
        ForgeDirection k = this.horizRotation ? BlockTools.getOrientationHoriz(meta) : BlockTools.getOrientation(meta);
        return k;
    }

    public IIcon func_149691_a(int side, int meta) {
        if (this.iconInd != null && side == ForgeDirection.SOUTH.ordinal()) {
            return this.iconInd;
        }
        if (this.iconTop != null && side == ForgeDirection.UP.ordinal()) {
            return this.iconTop;
        }
        if (this.iconBottom != null && side == ForgeDirection.DOWN.ordinal()) {
            return this.iconBottom;
        }
        return this.iconSide;
    }

    public IIcon getIconInd(IBlockAccess blockAccess, int x, int y, int z, int meta) {
        return this.iconInd;
    }

    public boolean func_149696_a(World world, int x, int y, int z, int eventId, int eventData) {
        if (this.field_149758_A) {
            super.func_149696_a(world, x, y, z, eventId, eventData);
            TileEntity tileentity = world.func_147438_o(x, y, z);
            return tileentity != null && tileentity.func_145842_c(eventId, eventData);
        }
        return super.func_149696_a(world, x, y, z, eventId, eventData);
    }
}

