/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.network;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import mcjty.lib.network.AbstractServerCommand;
import mcjty.lib.network.Argument;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class PacketUpdateNBTItem
implements IMessage,
IMessageHandler<PacketUpdateNBTItem, IMessage> {
    private Map<String, Argument> args;

    public void fromBytes(ByteBuf buf) {
        this.args = AbstractServerCommand.readArguments(buf);
    }

    public void toBytes(ByteBuf buf) {
        AbstractServerCommand.writeArguments(buf, this.args);
    }

    public PacketUpdateNBTItem() {
    }

    public PacketUpdateNBTItem(Argument ... arguments) {
        if (arguments == null) {
            this.args = null;
        } else {
            this.args = new HashMap<String, Argument>(arguments.length);
            for (Argument arg : arguments) {
                this.args.put(arg.getName(), arg);
            }
        }
    }

    public IMessage onMessage(PacketUpdateNBTItem message, MessageContext ctx) {
        EntityPlayerMP playerEntity = ctx.getServerHandler().field_147369_b;
        ItemStack heldItem = playerEntity.func_70694_bm();
        if (heldItem == null) {
            return null;
        }
        NBTTagCompound tagCompound = heldItem.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
            heldItem.func_77982_d(tagCompound);
        }
        for (Map.Entry<String, Argument> entry : message.args.entrySet()) {
            String key = entry.getKey();
            switch (entry.getValue().getType()) {
                case TYPE_STRING: {
                    tagCompound.func_74778_a(key, entry.getValue().getString());
                    break;
                }
                case TYPE_INTEGER: {
                    tagCompound.func_74768_a(key, entry.getValue().getInteger().intValue());
                    break;
                }
                case TYPE_COORDINATE: {
                    throw new RuntimeException("Coordinate not supported for PacketUpdateNBTItem!");
                }
                case TYPE_BOOLEAN: {
                    tagCompound.func_74757_a(key, entry.getValue().getBoolean());
                    break;
                }
                case TYPE_DOUBLE: {
                    tagCompound.func_74780_a(key, entry.getValue().getDouble().doubleValue());
                }
            }
        }
        return null;
    }
}

