/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.tiles;

import cofh.api.energy.IEnergyConnection;
import forestry.api.core.IErrorLogic;
import forestry.apiculture.network.packets.PacketActiveUpdate;
import forestry.core.config.Config;
import forestry.core.errors.EnumErrorCode;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.proxy.Proxies;
import forestry.core.tiles.IActivatable;
import forestry.core.tiles.TemperatureState;
import forestry.core.tiles.TileBase;
import forestry.core.utils.BlockUtil;
import forestry.energy.EnergyManager;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TileEngine
extends TileBase
implements IEnergyConnection,
IActivatable {
    private static final int CANT_SEND_ENERGY_TIME = 20;
    private boolean active = false;
    private int cantSendEnergyCountdown = 20;
    private int stagePiston = 0;
    private float pistonSpeedServer = 0.0f;
    protected int currentOutput = 0;
    protected int heat;
    protected final int maxHeat;
    protected boolean forceCooldown = false;
    public float progress;
    protected final EnergyManager energyManager;

    protected TileEngine(String hintKey, int maxHeat, int maxEnergy) {
        super(hintKey);
        this.maxHeat = maxHeat;
        this.energyManager = new EnergyManager(2000, maxEnergy);
        this.energyManager.setReceiveOnly();
        this.hints.addAll(Config.hints.get((Object)"engine"));
    }

    @Override
    public void rotateAfterPlacement(EntityPlayer player, int side) {
        ForgeDirection orientation = ForgeDirection.getOrientation((int)side).getOpposite();
        if (this.isOrientedAtEnergyReciever(orientation)) {
            this.setOrientation(orientation);
        } else {
            super.rotateAfterPlacement(player, side);
            this.rotate();
        }
    }

    protected void addHeat(int i) {
        this.heat += i;
        if (this.heat > this.maxHeat) {
            this.heat = this.maxHeat;
        }
    }

    protected abstract int dissipateHeat();

    protected abstract int generateHeat();

    protected boolean mayBurn() {
        return !this.forceCooldown;
    }

    protected abstract void burn();

    @Override
    public void updateClientSide() {
        if (this.stagePiston != 0) {
            this.progress += this.pistonSpeedServer;
            if (this.progress > 1.0f) {
                this.stagePiston = 0;
                this.progress = 0.0f;
            }
        } else if (this.active) {
            this.stagePiston = 1;
        }
    }

    @Override
    protected void updateServerSide() {
        TemperatureState energyState = this.getTemperatureState();
        if (energyState == TemperatureState.MELTING && this.heat > 0) {
            this.forceCooldown = true;
        } else if (this.forceCooldown && this.heat <= 0) {
            this.forceCooldown = false;
        }
        IErrorLogic errorLogic = this.getErrorLogic();
        errorLogic.setCondition(this.forceCooldown, EnumErrorCode.FORCED_COOLDOWN);
        boolean enabledRedstone = this.isRedstoneActivated();
        errorLogic.setCondition(!enabledRedstone, EnumErrorCode.NO_REDSTONE);
        TileEntity tile = this.field_145850_b.func_147438_o(this.field_145851_c + this.getOrientation().offsetX, this.field_145848_d + this.getOrientation().offsetY, this.field_145849_e + this.getOrientation().offsetZ);
        float newPistonSpeed = this.getPistonSpeed();
        if (newPistonSpeed != this.pistonSpeedServer) {
            this.pistonSpeedServer = newPistonSpeed;
            this.setNeedsNetworkUpdate();
        }
        if (this.stagePiston != 0) {
            this.progress += this.pistonSpeedServer;
            this.energyManager.sendEnergy(this.getOrientation(), tile);
            if ((double)this.progress > 0.25 && this.stagePiston == 1) {
                this.stagePiston = 2;
            } else if ((double)this.progress >= 0.5) {
                this.progress = 0.0f;
                this.stagePiston = 0;
            }
        } else if (enabledRedstone && BlockUtil.isEnergyReceiverOrEngine(this.getOrientation().getOpposite(), tile)) {
            if (this.energyManager.canSendEnergy(this.getOrientation(), tile)) {
                this.stagePiston = 1;
                this.setActive(true);
                this.cantSendEnergyCountdown = 20;
            } else if (this.isActive()) {
                --this.cantSendEnergyCountdown;
                if (this.cantSendEnergyCountdown <= 0) {
                    this.setActive(false);
                }
            }
        } else {
            this.setActive(false);
        }
        this.dissipateHeat();
        this.generateHeat();
        if (this.mayBurn()) {
            this.burn();
        } else {
            this.energyManager.drainEnergy(20);
        }
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void setActive(boolean active) {
        if (this.active == active) {
            return;
        }
        this.active = active;
        if (!this.field_145850_b.field_72995_K) {
            Proxies.net.sendNetworkPacket(new PacketActiveUpdate(this), this.field_145850_b);
        }
    }

    @Override
    public boolean rotate(ForgeDirection axis) {
        this.rotate();
        return true;
    }

    private void rotate() {
        for (int i = this.getOrientation().ordinal() + 1; i <= this.getOrientation().ordinal() + 6; ++i) {
            ForgeDirection orientation = ForgeDirection.values()[i % 6];
            if (!this.isOrientedAtEnergyReciever(orientation)) continue;
            this.setOrientation(orientation);
            return;
        }
    }

    private boolean isOrientedAtEnergyReciever(ForgeDirection orientation) {
        TileEntity tile = this.field_145850_b.func_147438_o(this.field_145851_c + orientation.offsetX, this.field_145848_d + orientation.offsetY, this.field_145849_e + orientation.offsetZ);
        return BlockUtil.isEnergyReceiverOrEngine(this.getOrientation().getOpposite(), tile);
    }

    protected double getHeatLevel() {
        return (double)this.heat / (double)this.maxHeat;
    }

    protected abstract boolean isBurning();

    public int getBurnTimeRemainingScaled(int i) {
        return 0;
    }

    public boolean hasFuelMin(float percentage) {
        return false;
    }

    public int getCurrentOutput() {
        if (this.isBurning() && this.isRedstoneActivated()) {
            return this.currentOutput;
        }
        return 0;
    }

    public int getHeat() {
        return this.heat;
    }

    public TemperatureState getTemperatureState() {
        return TemperatureState.getState(this.heat, this.maxHeat);
    }

    protected float getPistonSpeed() {
        switch (this.getTemperatureState()) {
            case COOL: {
                return 0.03f;
            }
            case WARMED_UP: {
                return 0.04f;
            }
            case OPERATING_TEMPERATURE: {
                return 0.05f;
            }
            case RUNNING_HOT: {
                return 0.06f;
            }
            case OVERHEATING: {
                return 0.07f;
            }
            case MELTING: {
                return 0.08f;
            }
        }
        return 0.0f;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.energyManager.readFromNBT(nbt);
        this.heat = nbt.func_74762_e("EngineHeat");
        this.progress = nbt.func_74760_g("EngineProgress");
        this.forceCooldown = nbt.func_74767_n("ForceCooldown");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.energyManager.writeToNBT(nbt);
        nbt.func_74768_a("EngineHeat", this.heat);
        nbt.func_74776_a("EngineProgress", this.progress);
        nbt.func_74757_a("ForceCooldown", this.forceCooldown);
    }

    @Override
    public void writeData(DataOutputStreamForestry data) throws IOException {
        super.writeData(data);
        data.writeBoolean(this.active);
        data.writeInt(this.heat);
        data.writeFloat(this.pistonSpeedServer);
        this.energyManager.writeData(data);
    }

    @Override
    public void readData(DataInputStreamForestry data) throws IOException {
        super.readData(data);
        this.active = data.readBoolean();
        this.heat = data.readInt();
        this.pistonSpeedServer = data.readFloat();
        this.energyManager.readData(data);
    }

    public abstract void getGUINetworkData(int var1, int var2);

    public abstract void sendGUINetworkData(Container var1, ICrafting var2);

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return this.energyManager.canConnectEnergy(from);
    }

    public EnergyManager getEnergyManager() {
        return this.energyManager;
    }
}

