/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.spaceprojector;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import cpw.mods.fml.common.registry.GameRegistry;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import mcjty.lib.container.GenericItemBlock;
import mcjty.lib.varia.Logging;
import mcjty.rftools.CommonProxy;
import mcjty.rftools.GeneralConfiguration;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.ModBlocks;
import mcjty.rftools.blocks.RFToolsTools;
import mcjty.rftools.blocks.spaceprojector.BuilderBlock;
import mcjty.rftools.blocks.spaceprojector.BuilderTileEntity;
import mcjty.rftools.blocks.spaceprojector.ProxyBlock;
import mcjty.rftools.blocks.spaceprojector.ProxyBlockTileEntity;
import mcjty.rftools.blocks.spaceprojector.SpaceChamberBlock;
import mcjty.rftools.blocks.spaceprojector.SpaceChamberCardItem;
import mcjty.rftools.blocks.spaceprojector.SpaceChamberControllerBlock;
import mcjty.rftools.blocks.spaceprojector.SpaceChamberControllerTileEntity;
import mcjty.rftools.blocks.spaceprojector.SpaceProjectorBlock;
import mcjty.rftools.blocks.spaceprojector.SpaceProjectorTileEntity;
import mcjty.rftools.blocks.spaceprojector.SupportBlock;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class SpaceProjectorSetup {
    public static ProxyBlock proxyBlock;
    public static SpaceChamberBlock spaceChamberBlock;
    public static SpaceChamberControllerBlock spaceChamberControllerBlock;
    public static SpaceProjectorBlock spaceProjectorBlock;
    public static BuilderBlock builderBlock;
    public static SupportBlock supportBlock;
    public static SpaceChamberCardItem spaceChamberCardItem;
    private static Map<String, BlockInformation> blockInformationMap;

    public static void setupBlocks() {
        proxyBlock = new ProxyBlock();
        GameRegistry.registerBlock((Block)proxyBlock, (String)"proxyBlock");
        GameRegistry.registerTileEntity(ProxyBlockTileEntity.class, (String)"ProxyBlockTileEntity");
        spaceChamberBlock = new SpaceChamberBlock();
        GameRegistry.registerBlock((Block)spaceChamberBlock, (String)"spaceChamberBlock");
        spaceChamberControllerBlock = new SpaceChamberControllerBlock();
        GameRegistry.registerBlock((Block)spaceChamberControllerBlock, GenericItemBlock.class, (String)"spaceChamberControllerBlock");
        GameRegistry.registerTileEntity(SpaceChamberControllerTileEntity.class, (String)"SpaceChamberControllerTileEntity");
        spaceProjectorBlock = new SpaceProjectorBlock();
        GameRegistry.registerBlock((Block)spaceProjectorBlock, GenericItemBlock.class, (String)"spaceProjectorBlock");
        GameRegistry.registerTileEntity(SpaceProjectorTileEntity.class, (String)"SpaceProjectorTileEntity");
        builderBlock = new BuilderBlock();
        GameRegistry.registerBlock((Block)builderBlock, GenericItemBlock.class, (String)"builderBlock");
        GameRegistry.registerTileEntity(BuilderTileEntity.class, (String)"BuilderTileEntity");
        supportBlock = new SupportBlock();
        GameRegistry.registerBlock((Block)supportBlock, (String)"supportBlock");
        SpaceProjectorSetup.readBuilderBlocksInternal();
        SpaceProjectorSetup.readBuilderBlocksConfig();
    }

    public static void setupItems() {
        spaceChamberCardItem = new SpaceChamberCardItem();
        spaceChamberCardItem.func_77655_b("SpaceChamberCard");
        spaceChamberCardItem.func_77637_a(RFTools.tabRfTools);
        spaceChamberCardItem.func_111206_d("rftools:spaceChamberCardItem");
        GameRegistry.registerItem((Item)spaceChamberCardItem, (String)"spaceChamberCardItem");
    }

    public static void setupCrafting() {
        Object redstoneTorch = Item.field_150901_e.func_82594_a("redstone_torch");
        ItemStack lapisStack = new ItemStack(Items.field_151100_aR, 1, 4);
        GameRegistry.addRecipe((ItemStack)new ItemStack((Block)spaceChamberBlock), (Object[])new Object[]{"lgl", "gMg", "lgl", Character.valueOf('M'), ModBlocks.machineFrame, Character.valueOf('g'), Blocks.field_150359_w, Character.valueOf('l'), lapisStack});
        GameRegistry.addRecipe((ItemStack)new ItemStack((Block)spaceChamberControllerBlock), (Object[])new Object[]{" e ", "tMt", " e ", Character.valueOf('M'), spaceChamberBlock, Character.valueOf('t'), redstoneTorch, Character.valueOf('e'), Items.field_151079_bi});
        if (GeneralConfiguration.enableBuilderRecipe) {
            GameRegistry.addRecipe((ItemStack)new ItemStack((Block)builderBlock), (Object[])new Object[]{"beb", "rMr", "brb", Character.valueOf('M'), ModBlocks.machineFrame, Character.valueOf('e'), Items.field_151079_bi, Character.valueOf('r'), Items.field_151137_ax, Character.valueOf('b'), Blocks.field_150336_V});
        }
        GameRegistry.addRecipe((ItemStack)new ItemStack((Item)spaceChamberCardItem), (Object[])new Object[]{" b ", "rir", " b ", Character.valueOf('r'), Items.field_151137_ax, Character.valueOf('i'), Items.field_151042_j, Character.valueOf('b'), Items.field_151118_aC});
    }

    private static void readBuilderBlocksInternal() {
        try {
            InputStream inputstream = RFTools.class.getResourceAsStream("/assets/rftools/text/builder.json");
            SpaceProjectorSetup.parseBuilderJson(inputstream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void readBuilderBlocksConfig() {
        File modConfigDir = CommonProxy.modConfigDir;
        try {
            File file = new File(modConfigDir.getPath() + File.separator + "rftools", "userbuilder.json");
            FileInputStream inputstream = new FileInputStream(file);
            SpaceProjectorSetup.parseBuilderJson(inputstream);
        }
        catch (IOException e) {
            Logging.log((String)"Could not read 'userbuilder.json', this is not an error!");
        }
    }

    private static void parseBuilderJson(InputStream inputstream) throws UnsupportedEncodingException {
        BufferedReader br = new BufferedReader(new InputStreamReader(inputstream, "UTF-8"));
        JsonParser parser = new JsonParser();
        JsonElement element = parser.parse((Reader)br);
        for (Map.Entry entry : element.getAsJsonObject().entrySet()) {
            if ("movables".equals(entry.getKey())) {
                SpaceProjectorSetup.readMovablesFromJson((JsonElement)entry.getValue());
                continue;
            }
            if (!"rotatables".equals(entry.getKey())) continue;
            SpaceProjectorSetup.readRotatablesFromJson((JsonElement)entry.getValue());
        }
    }

    private static void readMovablesFromJson(JsonElement element) {
        for (JsonElement entry : element.getAsJsonArray()) {
            String blockName = entry.getAsJsonArray().get(0).getAsString();
            String warningType = entry.getAsJsonArray().get(1).getAsString();
            double costFactor = entry.getAsJsonArray().get(2).getAsDouble();
            int status = "-".equals(warningType) ? 2 : ("+".equals(warningType) ? 0 : 1);
            BlockInformation old = blockInformationMap.get(blockName);
            if (old == null) {
                old = BlockInformation.OK;
            }
            blockInformationMap.put(blockName, new BlockInformation(old, blockName, status, costFactor));
        }
    }

    private static void readRotatablesFromJson(JsonElement element) {
        for (JsonElement entry : element.getAsJsonArray()) {
            String blockName = entry.getAsJsonArray().get(0).getAsString();
            String rotatable = entry.getAsJsonArray().get(1).getAsString();
            BlockInformation old = blockInformationMap.get(blockName);
            if (old == null) {
                old = BlockInformation.OK;
            }
            blockInformationMap.put(blockName, new BlockInformation(old, rotatable));
        }
    }

    public static BlockInformation getBlockInformation(Block block) {
        BlockInformation blockInformation = blockInformationMap.get(block.func_149739_a());
        if (blockInformation == null) {
            String modid = RFToolsTools.getModidForBlock(block);
            blockInformation = blockInformationMap.get("modid:" + modid);
        }
        return blockInformation;
    }

    static {
        blockInformationMap = new HashMap<String, BlockInformation>();
    }

    public static class BlockInformation {
        private final String blockName;
        private final int blockLevel;
        private final double costFactor;
        private final int rotateInfo;
        public static final int ROTATE_invalid = -1;
        public static final int ROTATE_mmmm = 0;
        public static final int ROTATE_mfff = 1;
        public static final BlockInformation INVALID = new BlockInformation("", 2, 1.0);
        public static final BlockInformation OK = new BlockInformation("", 0, 1.0, 0);
        public static final BlockInformation FREE = new BlockInformation("", 0, 0.0, 0);

        private static int rotateStringToId(String rotateString) {
            if ("mmmm".equals(rotateString)) {
                return 0;
            }
            if ("mfff".equals(rotateString)) {
                return 1;
            }
            return -1;
        }

        public BlockInformation(String blockName, int blockLevel, double costFactor) {
            this.blockName = blockName;
            this.blockLevel = blockLevel;
            this.costFactor = costFactor;
            this.rotateInfo = 0;
        }

        public BlockInformation(String blockName, int blockLevel, double costFactor, int rotateInfo) {
            this.blockName = blockName;
            this.blockLevel = blockLevel;
            this.costFactor = costFactor;
            this.rotateInfo = rotateInfo;
        }

        public BlockInformation(BlockInformation other, String rotateInfo) {
            this(other.blockName, other.blockLevel, other.costFactor, BlockInformation.rotateStringToId(rotateInfo));
        }

        public BlockInformation(BlockInformation other, String blockName, int blockLevel, double costFactor) {
            this(blockName, blockLevel, costFactor, other.rotateInfo);
        }

        public int getBlockLevel() {
            return this.blockLevel;
        }

        public String getBlockName() {
            return this.blockName;
        }

        public double getCostFactor() {
            return this.costFactor;
        }

        public int getRotateInfo() {
            return this.rotateInfo;
        }
    }
}

