/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.special;

import java.util.List;
import mcjty.lib.entity.GenericTileEntity;
import mcjty.rftools.blocks.special.SpecialSetup;
import mcjty.rftools.blocks.special.VolcanicEvents;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraftforge.common.util.ForgeDirection;

public class VolcanicTileEntity
extends GenericTileEntity {
    private int age = 0;
    private AxisAlignedBB beamBox = null;
    private int ticker = 20;

    private void igniteNearEntities() {
        if (this.beamBox == null) {
            this.beamBox = AxisAlignedBB.func_72330_a((double)((double)this.field_145851_c - 0.5), (double)((double)this.field_145848_d - 0.5), (double)((double)this.field_145849_e - 0.5), (double)((double)this.field_145851_c + 1.5), (double)((double)this.field_145848_d + 2.5), (double)((double)this.field_145849_e + 1.5));
        }
        List l = this.field_145850_b.func_72872_a(Entity.class, this.beamBox);
        for (Entity entity : l) {
            boolean wet;
            if (!entity.func_70045_F()) {
                entity.func_70097_a(DamageSource.field_76372_a, 6.0f);
            }
            if (wet = entity.func_70026_G()) continue;
            entity.func_70015_d(6);
        }
    }

    private int checkSurroundings() {
        int cntHot = 0;
        for (ForgeDirection direction : ForgeDirection.values()) {
            if (direction == ForgeDirection.UNKNOWN) continue;
            int ox = this.field_145851_c + direction.offsetX;
            int oy = this.field_145848_d + direction.offsetY;
            int oz = this.field_145849_e + direction.offsetZ;
            Block block = this.field_145850_b.func_147439_a(ox, oy, oz);
            if (block == Blocks.field_150353_l || block == SpecialSetup.volcanicBlock || block == SpecialSetup.volcanicCoreBlock || block == Blocks.field_150356_k || block == Blocks.field_150480_ab) {
                ++cntHot;
                continue;
            }
            if (block != Blocks.field_150355_j) continue;
            this.field_145850_b.func_147465_d(ox, oy, oz, Blocks.field_150347_e, 0, 2);
        }
        return cntHot;
    }

    protected void checkStateServer() {
        --this.ticker;
        if (this.ticker < 0) {
            this.ticker = 20;
            this.igniteNearEntities();
            int cntHot = this.checkSurroundings();
            if (cntHot <= 3 && VolcanicEvents.random.nextInt(120) < 2) {
                this.coolDown();
                return;
            }
        }
        if (VolcanicEvents.random.nextFloat() < 0.01f) {
            ++this.age;
            this.func_70296_d();
            int meta = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            if (VolcanicEvents.random.nextInt(150) < this.age - 26) {
                this.coolDown();
            } else {
                int event = VolcanicEvents.random.nextInt(2048 + this.age * 100);
                switch (event) {
                    case 0: {
                        VolcanicEvents.explosion(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 2, 1.0f + (float)meta * 4.0f / 15.0f);
                        break;
                    }
                    case 20: 
                    case 21: 
                    case 22: 
                    case 23: 
                    case 24: 
                    case 25: {
                        VolcanicEvents.randomFire(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 3 + meta * 8 / 15);
                        break;
                    }
                    case 100: 
                    case 101: 
                    case 102: 
                    case 103: 
                    case 104: 
                    case 105: 
                    case 106: 
                    case 107: 
                    case 108: 
                    case 109: 
                    case 110: {
                        VolcanicEvents.randomLava(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 1);
                        break;
                    }
                    case 111: 
                    case 112: 
                    case 113: 
                    case 114: 
                    case 115: 
                    case 116: 
                    case 117: 
                    case 118: 
                    case 119: 
                    case 120: 
                    case 121: 
                    case 122: 
                    case 123: {
                        if (meta <= 3) break;
                        VolcanicEvents.randomLava(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 1);
                        break;
                    }
                    default: {
                        this.spawnVolcanicBlock();
                    }
                }
            }
        }
    }

    private void coolDown() {
        this.field_145850_b.func_147465_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, Blocks.field_150347_e, 0, 2);
    }

    private void spawnVolcanicBlock() {
        int meta = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (meta > 0) {
            int dir = VolcanicEvents.random.nextInt(6);
            ForgeDirection direction = ForgeDirection.values()[dir];
            int x = this.field_145851_c + direction.offsetX;
            int y = this.field_145848_d + direction.offsetY;
            int z = this.field_145849_e + direction.offsetZ;
            if (y < 1 || y >= this.field_145850_b.func_72800_K()) {
                return;
            }
            Block block = this.field_145850_b.func_147439_a(x, y, z);
            if (block == null || block.func_149688_o() == Material.field_151579_a) {
                float chanceToSpawn = direction == ForgeDirection.DOWN ? 0.5f : 0.1f;
                Block blockBelow = this.field_145850_b.func_147439_a(x, y - 1, z);
                if ((blockBelow == null || blockBelow.func_149688_o() == Material.field_151579_a) && VolcanicEvents.random.nextFloat() > chanceToSpawn) {
                    return;
                }
                switch (direction) {
                    case DOWN: {
                        break;
                    }
                    case UP: {
                        meta -= 2;
                        break;
                    }
                    case NORTH: 
                    case SOUTH: 
                    case EAST: 
                    case WEST: {
                        if (!(VolcanicEvents.random.nextFloat() > 0.2f)) break;
                        --meta;
                        break;
                    }
                }
                if (meta >= 0) {
                    this.field_145850_b.func_147465_d(x, y, z, (Block)SpecialSetup.volcanicBlock, meta, 2);
                }
            }
        }
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.age = tagCompound.func_74762_e("age");
    }

    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        tagCompound.func_74768_a("age", this.age);
    }
}

