/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.storage;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.GenericRFToolsBlock;
import mcjty.rftools.blocks.storage.GuiModularStorage;
import mcjty.rftools.blocks.storage.ModularStorageContainer;
import mcjty.rftools.blocks.storage.ModularStorageTileEntity;
import mcjty.rftools.blocks.storage.PacketGetCountInfo;
import mcjty.rftools.blocks.storage.ReturnCountInfoHelper;
import mcjty.rftools.blocks.storage.modules.TypeModule;
import mcjty.rftools.items.storage.DimletTypeItem;
import mcjty.rftools.items.storage.GenericTypeItem;
import mcjty.rftools.items.storage.OreDictTypeItem;
import mcjty.rftools.network.RFToolsMessages;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.material.Material;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import org.lwjgl.input.Keyboard;

public class ModularStorageBlock
extends GenericRFToolsBlock {
    public static int RENDERID_MODULARSTORAGE;
    private IIcon overlayIcon;
    private Map<Class<? extends TypeModule>, IIcon> icons = new HashMap<Class<? extends TypeModule>, IIcon>();
    private static long lastTime;

    public ModularStorageBlock() {
        super(Material.field_151573_f, ModularStorageTileEntity.class, true);
        this.func_149663_c("modularStorageBlock");
        this.func_149647_a(RFTools.tabRfTools);
    }

    public int getGuiID() {
        return RFTools.GUI_MODULAR_STORAGE;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return RENDERID_MODULARSTORAGE;
    }

    public String getIdentifyingIconName() {
        return "machineModularStorage";
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack itemStack, EntityPlayer player, List list, boolean whatIsThis) {
        super.addInformation(itemStack, player, list, whatIsThis);
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            list.add(EnumChatFormatting.WHITE + "This modular storage system can store a lot");
            list.add(EnumChatFormatting.WHITE + "of items and allows easy searching and filtering.");
            list.add(EnumChatFormatting.WHITE + "You must first insert a storage module item before");
            list.add(EnumChatFormatting.WHITE + "you can use it");
        } else {
            list.add(EnumChatFormatting.WHITE + "<Press Shift>");
        }
    }

    @SideOnly(value=Side.CLIENT)
    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.getWailaBody(itemStack, currenttip, accessor, config);
        TileEntity te = accessor.getTileEntity();
        if (te instanceof ModularStorageTileEntity) {
            ModularStorageTileEntity modularStorageTileEntity = (ModularStorageTileEntity)te;
            int maxSize = modularStorageTileEntity.getMaxSize();
            if (maxSize == 0) {
                currenttip.add(EnumChatFormatting.YELLOW + "No storage module!");
            } else {
                int stacks;
                if (System.currentTimeMillis() - lastTime > 500L) {
                    lastTime = System.currentTimeMillis();
                    RFToolsMessages.INSTANCE.sendToServer((IMessage)new PacketGetCountInfo(modularStorageTileEntity.func_145831_w().field_73011_w.field_76574_g, modularStorageTileEntity.field_145851_c, modularStorageTileEntity.field_145848_d, modularStorageTileEntity.field_145849_e));
                }
                if ((stacks = ReturnCountInfoHelper.cnt) == -1) {
                    currenttip.add(EnumChatFormatting.YELLOW + "Maximum size: " + maxSize);
                } else {
                    currenttip.add(EnumChatFormatting.GREEN + "" + stacks + " out of " + maxSize);
                }
            }
        }
        return currenttip;
    }

    public void func_149651_a(IIconRegister iconRegister) {
        this.icons.put(DimletTypeItem.class, iconRegister.func_94245_a("rftools:machineModularStorageDimlet"));
        this.icons.put(OreDictTypeItem.class, iconRegister.func_94245_a("rftools:machineModularStorageOre"));
        this.icons.put(GenericTypeItem.class, iconRegister.func_94245_a("rftools:machineModularStorageGeneric"));
        this.overlayIcon = iconRegister.func_94245_a("rftools:modularStorageOverlay");
        super.func_149651_a(iconRegister);
    }

    public IIcon getOverlayIcon() {
        return this.overlayIcon;
    }

    @SideOnly(value=Side.CLIENT)
    public GuiContainer createClientGui(EntityPlayer entityPlayer, TileEntity tileEntity) {
        ModularStorageTileEntity modularStorageTileEntity = (ModularStorageTileEntity)tileEntity;
        ModularStorageContainer modularStorageContainer = new ModularStorageContainer(entityPlayer, modularStorageTileEntity);
        return new GuiModularStorage(modularStorageTileEntity, modularStorageContainer);
    }

    public Container createServerContainer(EntityPlayer entityPlayer, TileEntity tileEntity) {
        ModularStorageTileEntity modularStorageTileEntity = (ModularStorageTileEntity)tileEntity;
        modularStorageTileEntity.syncToClient();
        return new ModularStorageContainer(entityPlayer, modularStorageTileEntity);
    }

    public IIcon getIconInd(IBlockAccess blockAccess, int x, int y, int z, int meta) {
        IIcon icon;
        ModularStorageTileEntity modularStorageTileEntity;
        ItemStack stack;
        TileEntity te = blockAccess.func_147438_o(x, y, z);
        if (te instanceof ModularStorageTileEntity && (stack = (modularStorageTileEntity = (ModularStorageTileEntity)te).func_70301_a(1)) != null && stack.field_77994_a > 0 && stack.func_77973_b() instanceof TypeModule && (icon = this.icons.get(stack.func_77973_b().getClass())) != null) {
            return icon;
        }
        return super.getIconInd(blockAccess, x, y, z, meta);
    }

    static {
        lastTime = 0L;
    }
}

