/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.storage;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import mcjty.rftools.blocks.storage.ModularStorageTileEntity;
import mcjty.rftools.blocks.storage.PacketReturnCountInfo;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class PacketGetCountInfo
implements IMessage,
IMessageHandler<PacketGetCountInfo, PacketReturnCountInfo> {
    private int x;
    private int y;
    private int z;
    private int dim;

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.dim = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        buf.writeInt(this.dim);
    }

    public PacketGetCountInfo() {
    }

    public PacketGetCountInfo(int dim, int x, int y, int z) {
        this.dim = dim;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public PacketReturnCountInfo onMessage(PacketGetCountInfo message, MessageContext ctx) {
        TileEntity te;
        WorldServer world = DimensionManager.getWorld((int)message.dim);
        int cnt = -1;
        if (world != null && (te = world.func_147438_o(message.x, message.y, message.z)) instanceof ModularStorageTileEntity) {
            ModularStorageTileEntity modularStorageTileEntity = (ModularStorageTileEntity)te;
            cnt = modularStorageTileEntity.getNumStacks();
        }
        return new PacketReturnCountInfo(cnt);
    }
}

