/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.teleporter;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import mcjty.lib.api.Infusable;
import mcjty.lib.container.EmptyContainer;
import mcjty.lib.varia.Coordinate;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.GenericRFToolsBlock;
import mcjty.rftools.blocks.teleporter.GuiMatterTransmitter;
import mcjty.rftools.blocks.teleporter.MatterTransmitterTileEntity;
import mcjty.rftools.dimension.network.PacketGetDestinationInfo;
import mcjty.rftools.dimension.network.ReturnDestinationInfoHelper;
import mcjty.rftools.network.RFToolsMessages;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.material.Material;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.input.Keyboard;

public class MatterTransmitterBlock
extends GenericRFToolsBlock
implements Infusable {
    private IIcon iconTop;
    private static long lastTime = 0L;

    public MatterTransmitterBlock() {
        super(Material.field_151573_f, MatterTransmitterTileEntity.class, true);
        this.func_149663_c("matterTransmitterBlock");
        this.func_149647_a(RFTools.tabRfTools);
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack itemStack, EntityPlayer player, List list, boolean whatIsThis) {
        super.addInformation(itemStack, player, list, whatIsThis);
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound != null) {
            boolean once;
            String name = tagCompound.func_74779_i("tpName");
            list.add(EnumChatFormatting.GREEN + "Name: " + name);
            boolean dialed = false;
            Coordinate c = Coordinate.readFromNBT((NBTTagCompound)tagCompound, (String)"dest");
            if (c != null && c.getY() >= 0) {
                dialed = true;
            } else if (tagCompound.func_74764_b("destId") && tagCompound.func_74762_e("destId") != -1) {
                dialed = true;
            }
            if (dialed) {
                int destId = tagCompound.func_74762_e("destId");
                if (System.currentTimeMillis() - lastTime > 500L) {
                    lastTime = System.currentTimeMillis();
                    RFToolsMessages.INSTANCE.sendToServer((IMessage)new PacketGetDestinationInfo(destId));
                }
                String destname = "?";
                if (ReturnDestinationInfoHelper.id != null && ReturnDestinationInfoHelper.id == destId) {
                    destname = ReturnDestinationInfoHelper.name;
                }
                list.add(EnumChatFormatting.YELLOW + "[DIALED to " + destname + "]");
            }
            if (once = tagCompound.func_74767_n("once")) {
                list.add(EnumChatFormatting.YELLOW + "[ONCE]");
            }
        }
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            list.add(EnumChatFormatting.WHITE + "If you place this block near a Dialing Device then");
            list.add(EnumChatFormatting.WHITE + "you can dial it to a Matter Receiver. Make sure to give");
            list.add(EnumChatFormatting.WHITE + "it sufficient power!");
            list.add(EnumChatFormatting.WHITE + "Use a Destination Analyzer adjacent to this block");
            list.add(EnumChatFormatting.WHITE + "to check destination status (red is bad, green ok,");
            list.add(EnumChatFormatting.WHITE + "yellow is unknown).");
            list.add(EnumChatFormatting.WHITE + "Use a  Matter Booster adjacent to this block");
            list.add(EnumChatFormatting.WHITE + "to be able to teleport to unpowered receivers.");
            list.add(EnumChatFormatting.YELLOW + "Infusing bonus: reduced power consumption and");
            list.add(EnumChatFormatting.YELLOW + "increased teleportation speed.");
        } else {
            list.add(EnumChatFormatting.WHITE + "<Press Shift>");
        }
    }

    @SideOnly(value=Side.CLIENT)
    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.getWailaBody(itemStack, currenttip, accessor, config);
        TileEntity te = accessor.getTileEntity();
        if (te instanceof MatterTransmitterTileEntity) {
            MatterTransmitterTileEntity matterTransmitterTileEntity = (MatterTransmitterTileEntity)te;
            currenttip.add(EnumChatFormatting.GREEN + "Name: " + matterTransmitterTileEntity.getName());
            if (matterTransmitterTileEntity.isDialed()) {
                if (System.currentTimeMillis() - lastTime > 500L) {
                    lastTime = System.currentTimeMillis();
                    RFToolsMessages.INSTANCE.sendToServer((IMessage)new PacketGetDestinationInfo(matterTransmitterTileEntity.getTeleportId()));
                }
                String name = "?";
                if (ReturnDestinationInfoHelper.id != null && ReturnDestinationInfoHelper.id == matterTransmitterTileEntity.getTeleportId()) {
                    name = ReturnDestinationInfoHelper.name;
                }
                currenttip.add(EnumChatFormatting.YELLOW + "[DIALED to " + name + "]");
            }
            if (matterTransmitterTileEntity.isOnce()) {
                currenttip.add(EnumChatFormatting.YELLOW + "[ONCE]");
            }
        }
        return currenttip;
    }

    public int getGuiID() {
        return RFTools.GUI_MATTER_TRANSMITTER;
    }

    @SideOnly(value=Side.CLIENT)
    public GuiContainer createClientGui(EntityPlayer entityPlayer, TileEntity tileEntity) {
        MatterTransmitterTileEntity matterTransmitterTileEntity = (MatterTransmitterTileEntity)tileEntity;
        EmptyContainer matterTransmitterContainer = new EmptyContainer(entityPlayer);
        return new GuiMatterTransmitter(matterTransmitterTileEntity, matterTransmitterContainer);
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entityLivingBase, ItemStack itemStack) {
        this.restoreBlockFromNBT(world, x, y, z, itemStack);
        this.setOwner(world, x, y, z, entityLivingBase);
    }

    public void func_149651_a(IIconRegister iconRegister) {
        this.iconTop = iconRegister.func_94245_a("rftools:machineTransmitter");
        this.iconSide = iconRegister.func_94245_a("rftools:machineSide");
        this.iconBottom = iconRegister.func_94245_a("rftools:machineBottom");
    }

    public IIcon func_149673_e(IBlockAccess blockAccess, int x, int y, int z, int side) {
        if (side == ForgeDirection.UP.ordinal()) {
            return this.iconTop;
        }
        if (side == ForgeDirection.DOWN.ordinal()) {
            return this.iconBottom;
        }
        return this.iconSide;
    }

    public IIcon func_149691_a(int side, int meta) {
        if (side == ForgeDirection.UP.ordinal()) {
            return this.iconTop;
        }
        if (side == ForgeDirection.DOWN.ordinal()) {
            return this.iconBottom;
        }
        return this.iconSide;
    }
}

