/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.commands;

import mcjty.rftools.commands.AbstractRfToolsCommand;
import mcjty.rftools.dimension.DimensionInformation;
import mcjty.rftools.dimension.RfToolsDimensionManager;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;

public class CmdInfo
extends AbstractRfToolsCommand {
    @Override
    public String getHelp() {
        return "[<dimension number>]";
    }

    @Override
    public String getCommand() {
        return "info";
    }

    @Override
    public int getPermissionLevel() {
        return 0;
    }

    @Override
    public boolean isClientSide() {
        return false;
    }

    @Override
    public void execute(ICommandSender sender, String[] args) {
        int dim = 0;
        World world = sender.func_130014_f_();
        if (args.length == 2) {
            dim = this.fetchInt(sender, args, 1, 0);
        } else {
            if (args.length > 2) {
                sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "Too many parameters!"));
                return;
            }
            dim = world.field_73011_w.field_76574_g;
        }
        RfToolsDimensionManager dimensionManager = RfToolsDimensionManager.getDimensionManager(world);
        DimensionInformation information = dimensionManager.getDimensionInformation(dim);
        if (information == null) {
            sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "Not an RFTools dimension!"));
            return;
        }
        sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.YELLOW + "Dimension ID " + dim));
        sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.YELLOW + "Description string " + information.getDescriptor().getDescriptionString()));
        String ownerName = information.getOwnerName();
        if (ownerName != null && !ownerName.isEmpty()) {
            sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.YELLOW + "Owned by: " + ownerName));
        }
        if (sender instanceof EntityPlayer) {
            information.dump((EntityPlayer)sender);
        }
    }
}

