/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.dimension.world;

import java.util.Map;
import mcjty.rftools.dimension.world.GenericWorldChunkManager;
import mcjty.rftools.dimension.world.types.ControllerType;
import mcjty.rftools.items.dimlets.BiomeControllerMapping;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.IntCache;

public class GenLayerFiltered
extends GenLayer {
    private final GenericWorldChunkManager chunkManager;
    private final ControllerType type;

    public GenLayerFiltered(GenericWorldChunkManager chunkManager, long seed, GenLayer parent, ControllerType type) {
        super(seed);
        this.field_75909_a = parent;
        this.chunkManager = chunkManager;
        this.type = type;
    }

    private Map<Integer, Integer> getFilterFromType() {
        switch (this.type) {
            case CONTROLLER_DEFAULT: 
            case CONTROLLER_SINGLE: 
            case CONTROLLER_CHECKERBOARD: {
                return null;
            }
            case CONTROLLER_COLD: {
                return BiomeControllerMapping.coldBiomeReplacements;
            }
            case CONTROLLER_MEDIUM: {
                return BiomeControllerMapping.mediumBiomeReplacements;
            }
            case CONTROLLER_WARM: {
                return BiomeControllerMapping.warmBiomeReplacements;
            }
            case CONTROLLER_DRY: {
                return BiomeControllerMapping.dryBiomeReplacements;
            }
            case CONTROLLER_WET: {
                return BiomeControllerMapping.wetBiomeReplacements;
            }
            case CONTROLLER_FIELDS: {
                return BiomeControllerMapping.fieldsBiomeReplacements;
            }
            case CONTROLLER_MOUNTAINS: {
                return BiomeControllerMapping.mountainsBiomeReplacements;
            }
            case CONTROLLER_MAGICAL: {
                return BiomeControllerMapping.magicalBiomeReplacements;
            }
            case CONTROLLER_FOREST: {
                return BiomeControllerMapping.forestBiomeReplacements;
            }
            case CONTROLLER_FILTERED: {
                return this.chunkManager.getDimensionInformation().getBiomeMapping();
            }
        }
        return null;
    }

    public int[] func_75904_a(int x, int z, int width, int length) {
        int[] ints = this.field_75909_a.func_75904_a(x, z, width, length);
        Map<Integer, Integer> filterMap = this.getFilterFromType();
        if (filterMap != null) {
            int[] aint = IntCache.func_76445_a((int)(width * length));
            for (int i = 0; i < width * length; ++i) {
                Integer biome = filterMap.get(ints[i]);
                aint[i] = biome != null ? biome : ints[i];
            }
            return aint;
        }
        return ints;
    }
}

