/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.items.dimlets;

import java.util.HashMap;
import java.util.Map;
import mcjty.rftools.dimension.world.types.ControllerType;
import net.minecraft.world.biome.BiomeGenBase;

public class BiomeControllerMapping {
    public static final Map<Integer, Integer> coldBiomeReplacements = new HashMap<Integer, Integer>();
    public static final Map<Integer, Integer> warmBiomeReplacements = new HashMap<Integer, Integer>();
    public static final Map<Integer, Integer> mediumBiomeReplacements = new HashMap<Integer, Integer>();
    public static final Map<Integer, Integer> wetBiomeReplacements = new HashMap<Integer, Integer>();
    public static final Map<Integer, Integer> dryBiomeReplacements = new HashMap<Integer, Integer>();
    public static final Map<Integer, Integer> fieldsBiomeReplacements = new HashMap<Integer, Integer>();
    public static final Map<Integer, Integer> mountainsBiomeReplacements = new HashMap<Integer, Integer>();
    public static final Map<Integer, Integer> magicalBiomeReplacements = new HashMap<Integer, Integer>();
    public static final Map<Integer, Integer> forestBiomeReplacements = new HashMap<Integer, Integer>();

    public static void setupControllerBiomes() {
        BiomeGenBase[] biomeGenArray = BiomeGenBase.func_150565_n();
        BiomeControllerMapping.makeFilteredBiomeMap(biomeGenArray, coldBiomeReplacements, ControllerType.CONTROLLER_COLD);
        BiomeControllerMapping.makeFilteredBiomeMap(biomeGenArray, warmBiomeReplacements, ControllerType.CONTROLLER_WARM);
        BiomeControllerMapping.makeFilteredBiomeMap(biomeGenArray, mediumBiomeReplacements, ControllerType.CONTROLLER_MEDIUM);
        BiomeControllerMapping.makeFilteredBiomeMap(biomeGenArray, wetBiomeReplacements, ControllerType.CONTROLLER_WET);
        BiomeControllerMapping.makeFilteredBiomeMap(biomeGenArray, dryBiomeReplacements, ControllerType.CONTROLLER_DRY);
        BiomeControllerMapping.makeFilteredBiomeMap(biomeGenArray, fieldsBiomeReplacements, ControllerType.CONTROLLER_FIELDS);
        BiomeControllerMapping.makeFilteredBiomeMap(biomeGenArray, mountainsBiomeReplacements, ControllerType.CONTROLLER_MOUNTAINS);
        BiomeControllerMapping.makeFilteredBiomeMap(biomeGenArray, magicalBiomeReplacements, ControllerType.CONTROLLER_MAGICAL);
        BiomeControllerMapping.makeFilteredBiomeMap(biomeGenArray, forestBiomeReplacements, ControllerType.CONTROLLER_FOREST);
    }

    private static void makeFilteredBiomeMap(BiomeGenBase[] biomeGenArray, Map<Integer, Integer> map, ControllerType type) {
        BiomeControllerMapping.makeFilteredBiomeMap(biomeGenArray, map, type.getFilter());
    }

    public static void makeFilteredBiomeMap(BiomeGenBase[] biomeGenArray, Map<Integer, Integer> map, ControllerType.BiomeFilter filter) {
        boolean ok = false;
        for (BiomeGenBase biome : biomeGenArray) {
            if (biome == null || !filter.match(biome)) continue;
            ok = true;
            break;
        }
        if (!ok) {
            for (BiomeGenBase biome : biomeGenArray) {
                if (biome == null) continue;
                map.put(biome.field_76756_M, biome.field_76756_M);
            }
        } else {
            for (BiomeGenBase biome : biomeGenArray) {
                if (biome == null) continue;
                if (filter.match(biome)) {
                    map.put(biome.field_76756_M, biome.field_76756_M);
                    continue;
                }
                map.put(biome.field_76756_M, BiomeControllerMapping.findSuitableBiomes(biomeGenArray, biome, filter));
            }
        }
    }

    private static int findSuitableBiomes(BiomeGenBase[] biomeGenArray, BiomeGenBase biome, ControllerType.BiomeFilter filter) {
        double bestdist = 1.0E9;
        int bestidx = 0;
        for (BiomeGenBase base : biomeGenArray) {
            if (base == null || !filter.match(base)) continue;
            if (biome.func_150562_l() == base.func_150562_l()) {
                return base.field_76756_M;
            }
            double dist = filter.calculateBiomeDistance(biome, base);
            if (!(dist < bestdist)) continue;
            bestdist = dist;
            bestidx = base.field_76756_M;
        }
        return bestidx;
    }
}

