/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.items.dimlets;

import mcjty.rftools.blocks.dimlets.DimletConfiguration;
import mcjty.rftools.items.dimlets.DimletKey;

public class DimletEntry {
    private final DimletKey key;
    private final int rfCreateCost;
    private final int rfMaintainCost;
    private final int tickCost;
    private final int rarity;
    private final boolean randomNotAllowed;
    private final boolean lootNotAllowed;

    public DimletEntry(DimletKey key, int rfCreateCost, int rfMaintainCost, int tickCost, int rarity, boolean randomNotAllowed, boolean lootNotAllowed) {
        this.key = key;
        this.rfCreateCost = rfCreateCost;
        this.rfMaintainCost = rfMaintainCost;
        this.tickCost = tickCost;
        this.rarity = rarity;
        this.randomNotAllowed = randomNotAllowed;
        this.lootNotAllowed = lootNotAllowed;
    }

    public DimletKey getKey() {
        return this.key;
    }

    public int getRfCreateCost() {
        return this.rfCreateCost;
    }

    public int getBaseRfMaintainCost() {
        return this.rfMaintainCost;
    }

    public int getRfMaintainCost() {
        int cost = this.rfMaintainCost;
        if (cost > 0) {
            float factor = DimletConfiguration.maintenanceCostPercentage / 100.0f;
            if (factor < -0.9f) {
                factor = -0.9f;
            }
            cost = (int)((float)cost + (float)cost * factor);
        }
        return cost;
    }

    public int getTickCost() {
        return this.tickCost;
    }

    public int getRarity() {
        return this.rarity;
    }

    public boolean isRandomNotAllowed() {
        return this.randomNotAllowed;
    }

    public boolean isLootNotAllowed() {
        return this.lootNotAllowed;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DimletEntry that = (DimletEntry)o;
        if (this.randomNotAllowed != that.randomNotAllowed) {
            return false;
        }
        if (this.rarity != that.rarity) {
            return false;
        }
        if (this.rfCreateCost != that.rfCreateCost) {
            return false;
        }
        if (this.rfMaintainCost != that.rfMaintainCost) {
            return false;
        }
        if (this.tickCost != that.tickCost) {
            return false;
        }
        return this.key.equals(that.key);
    }

    public int hashCode() {
        int result = this.key.hashCode();
        result = 31 * result + this.rfCreateCost;
        result = 31 * result + this.rfMaintainCost;
        result = 31 * result + this.tickCost;
        result = 31 * result + this.rarity;
        result = 31 * result + (this.randomNotAllowed ? 1 : 0);
        return result;
    }
}

